/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.FileUtils;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.internal.CollectionUtils;

public class NormalizingGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(NormalizingGroovyCompiler.class);
    private final Compiler<GroovyJavaJointCompileSpec> delegate;

    public NormalizingGroovyCompiler(Compiler<GroovyJavaJointCompileSpec> delegate) {
        this.delegate = delegate;
    }

    public WorkResult execute(GroovyJavaJointCompileSpec spec) {
        this.resolveAndFilterSourceFiles(spec);
        this.resolveNonStringsInCompilerArgs(spec);
        this.logSourceFiles(spec);
        this.logCompilerArguments(spec);
        return this.delegateAndHandleErrors(spec);
    }

    private void resolveAndFilterSourceFiles(GroovyJavaJointCompileSpec spec) {
        final List fileExtensions = CollectionUtils.collect(spec.getGroovyCompileOptions().getFileExtensions(), extension -> '.' + extension);
        Iterable filtered = Iterables.filter((Iterable)spec.getSourceFiles(), (Predicate)new Predicate<File>(){

            public boolean apply(File element) {
                for (String fileExtension : fileExtensions) {
                    if (!FileUtils.hasExtension((File)element, (String)fileExtension)) continue;
                    return true;
                }
                return false;
            }
        });
        spec.setSourceFiles((Iterable)ImmutableSet.copyOf((Iterable)filtered));
    }

    private void resolveNonStringsInCompilerArgs(GroovyJavaJointCompileSpec spec) {
        spec.getCompileOptions().setCompilerArgs(CollectionUtils.toStringList((Iterable)spec.getCompileOptions().getCompilerArgs()));
    }

    private void logSourceFiles(GroovyJavaJointCompileSpec spec) {
        if (!spec.getGroovyCompileOptions().isListFiles()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Source files to be compiled:");
        for (File file : spec.getSourceFiles()) {
            builder.append('\n');
            builder.append(file);
        }
        LOGGER.quiet(builder.toString());
    }

    private void logCompilerArguments(GroovyJavaJointCompileSpec spec) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        List compilerArgs = new JavaCompilerArgumentsBuilder((JavaCompileSpec)spec).includeLauncherOptions(true).includeSourceFiles(true).build();
        String joinedArgs = Joiner.on((char)' ').join((Iterable)compilerArgs);
        LOGGER.debug("Java compiler arguments: {}", (Object)joinedArgs);
    }

    private WorkResult delegateAndHandleErrors(GroovyJavaJointCompileSpec spec) {
        try {
            return this.delegate.execute((CompileSpec)spec);
        }
        catch (RuntimeException e) {
            if (spec.getCompileOptions().isFailOnError() && spec.getGroovyCompileOptions().isFailOnError() || !CompilationFailedException.class.getName().equals(e.getClass().getName())) {
                throw e;
            }
            LOGGER.debug("Ignoring compilation failure.");
            return WorkResults.didWork((boolean)false);
        }
    }
}

