/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.operations.execution.CachingDisabledReasonCategory;
import org.gradle.operations.execution.ExecuteWorkBuildOperationType;
import org.jspecify.annotations.Nullable;

public class ExecuteWorkBuildOperationFiringStep<C extends IdentityContext, R extends CachingResult>
extends BuildOperationStep<C, R>
implements Step<C, R> {
    private final Step<? super C, R> delegate;

    public ExecuteWorkBuildOperationFiringStep(BuildOperationRunner buildOperationRunner, Step<C, R> delegate) {
        super(buildOperationRunner);
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return (R)work.getBuildOperationWorkType().map(workType -> this.operation(operationContext -> {
            CachingResult result = (CachingResult)this.delegate.execute(work, (IdentityContext)context);
            ExecuteWorkResult operationResult = new ExecuteWorkResult(result.getExecution(), result.getCachingState(), result.getReusedOutputOriginMetadata(), result.getExecutionReasons());
            operationContext.setResult((Object)operationResult);
            result.getExecution().getFailure().ifPresent(arg_0 -> ((BuildOperationContext)operationContext).failed(arg_0));
            return result;
        }, BuildOperationDescriptor.displayName((String)"Execute unit of work").details((Object)new ExecuteWorkDetails((String)workType, context.getIdentity().getUniqueId())))).orElseGet(() -> (CachingResult)this.delegate.execute(work, (IdentityContext)context));
    }

    private static class ExecuteWorkDetails
    implements ExecuteWorkBuildOperationType.Details {
        private final String workType;
        private final String identity;

        public ExecuteWorkDetails(String workType, String identity) {
            this.workType = workType;
            this.identity = identity;
        }

        public @Nullable String getWorkType() {
            return this.workType;
        }

        public String getIdentity() {
            return this.identity;
        }
    }

    private static class ExecuteWorkResult
    implements ExecuteWorkBuildOperationType.Result {
        private final Try<ExecutionEngine.Execution> execution;
        private final CachingState cachingState;
        private final Optional<OriginMetadata> originMetadata;
        private final ImmutableList<String> executionReasons;

        public ExecuteWorkResult(Try<ExecutionEngine.Execution> execution, CachingState cachingState, Optional<OriginMetadata> originMetadata, ImmutableList<String> executionReasons) {
            this.execution = execution;
            this.cachingState = cachingState;
            this.originMetadata = originMetadata;
            this.executionReasons = executionReasons;
        }

        public @Nullable String getSkipMessage() {
            return (String)this.execution.map(ExecuteWorkResult::getSkipMessage).getOrMapFailure(f -> null);
        }

        public @Nullable String getOriginBuildInvocationId() {
            return this.originMetadata.map(OriginMetadata::getBuildInvocationId).orElse(null);
        }

        public byte @Nullable [] getOriginBuildCacheKeyBytes() {
            return this.originMetadata.map(OriginMetadata::getBuildCacheKey).map(HashCode::toByteArray).orElse(null);
        }

        public @Nullable Long getOriginExecutionTime() {
            return this.originMetadata.map(metadata -> metadata.getExecutionTime().toMillis()).orElse(null);
        }

        private static @Nullable String getSkipMessage(ExecutionEngine.Execution execution) {
            switch (execution.getOutcome()) {
                case SHORT_CIRCUITED: {
                    return "NO-SOURCE";
                }
                case FROM_CACHE: {
                    return "FROM-CACHE";
                }
                case UP_TO_DATE: {
                    return "UP-TO-DATE";
                }
                case EXECUTED_INCREMENTALLY: 
                case EXECUTED_NON_INCREMENTALLY: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Unknown execution outcome: " + (Object)((Object)execution.getOutcome()));
        }

        public List<String> getExecutionReasons() {
            return this.executionReasons;
        }

        public @Nullable String getCachingDisabledReasonMessage() {
            return this.getCachingDisabledReason().map(CachingDisabledReason::getMessage).orElse(null);
        }

        public @Nullable String getCachingDisabledReasonCategory() {
            return this.getCachingDisabledReason().map(CachingDisabledReason::getCategory).map(ExecuteWorkResult::convertNoCacheReasonCategory).map(Enum::name).orElse(null);
        }

        private static CachingDisabledReasonCategory convertNoCacheReasonCategory(org.gradle.internal.execution.caching.CachingDisabledReasonCategory category) {
            switch (category) {
                case UNKNOWN: {
                    return CachingDisabledReasonCategory.UNKNOWN;
                }
                case BUILD_CACHE_DISABLED: {
                    return CachingDisabledReasonCategory.BUILD_CACHE_DISABLED;
                }
                case NOT_CACHEABLE: {
                    return CachingDisabledReasonCategory.NOT_CACHEABLE;
                }
                case ENABLE_CONDITION_NOT_SATISFIED: {
                    return CachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED;
                }
                case DISABLE_CONDITION_SATISFIED: {
                    return CachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED;
                }
                case NO_OUTPUTS_DECLARED: {
                    return CachingDisabledReasonCategory.NO_OUTPUTS_DECLARED;
                }
                case NON_CACHEABLE_OUTPUT: {
                    return CachingDisabledReasonCategory.NON_CACHEABLE_TREE_OUTPUT;
                }
                case OVERLAPPING_OUTPUTS: {
                    return CachingDisabledReasonCategory.OVERLAPPING_OUTPUTS;
                }
                case VALIDATION_FAILURE: {
                    return CachingDisabledReasonCategory.VALIDATION_FAILURE;
                }
            }
            throw new AssertionError();
        }

        private Optional<CachingDisabledReason> getCachingDisabledReason() {
            return this.cachingState.whenDisabled().map(CachingState.Disabled::getDisabledReasons).map(reasons -> (CachingDisabledReason)reasons.get(0));
        }
    }
}

