/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import org.gradle.internal.hash.Hasher;

public class HasherExtensions {
    public static void putBooleans(Hasher hasher, boolean[] array) {
        hasher.putInt(array.length);
        for (boolean b : array) {
            hasher.putBoolean(b);
        }
    }

    public static void putChars(Hasher hasher, char[] array) {
        hasher.putInt(array.length);
        for (char c : array) {
            hasher.putInt(c);
        }
    }

    public static void putDoubles(Hasher hasher, double[] array) {
        hasher.putInt(array.length);
        for (double d : array) {
            hasher.putDouble(d);
        }
    }

    public static void putFloats(Hasher hasher, float[] array) {
        hasher.putInt(array.length);
        for (float f : array) {
            hasher.putInt(Float.floatToRawIntBits(f));
        }
    }

    public static void putLongs(Hasher hasher, long[] array) {
        hasher.putInt(array.length);
        for (long l : array) {
            hasher.putLong(l);
        }
    }

    public static void putInts(Hasher hasher, int[] array) {
        hasher.putInt(array.length);
        for (int i : array) {
            hasher.putInt(i);
        }
    }

    public static void putShorts(Hasher hasher, short[] array) {
        hasher.putInt(array.length);
        for (short s : array) {
            hasher.putInt(s);
        }
    }
}

