/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import tim.prune.config.ColourUtils;
import tim.prune.gui.colour.AltitudeColourer;
import tim.prune.gui.colour.ContinuousPointColourer;
import tim.prune.gui.colour.DateColourer;
import tim.prune.gui.colour.FileColourer;
import tim.prune.gui.colour.GradientColourer;
import tim.prune.gui.colour.PointColourer;
import tim.prune.gui.colour.SegmentColourer;
import tim.prune.gui.colour.SpeedColourer;
import tim.prune.gui.colour.VertSpeedColourer;

public abstract class ColourerFactory {
    private static ColourerId getColourerId(char c) {
        switch (c) {
            case 'f': {
                return ColourerId.BY_FILE;
            }
            case 's': {
                return ColourerId.BY_SEGMENT;
            }
            case 'a': {
                return ColourerId.BY_ALTITUDE;
            }
            case 'p': {
                return ColourerId.BY_SPEED;
            }
            case 'v': {
                return ColourerId.BY_VSPEED;
            }
            case 'g': {
                return ColourerId.BY_GRADIENT;
            }
            case 'd': {
                return ColourerId.BY_DATE;
            }
        }
        return ColourerId.NONE;
    }

    private static char getColourerPrefix(PointColourer pointColourer) {
        if (pointColourer instanceof FileColourer) {
            return 'f';
        }
        if (pointColourer instanceof SegmentColourer) {
            return 's';
        }
        if (pointColourer instanceof AltitudeColourer) {
            return 'a';
        }
        if (pointColourer instanceof SpeedColourer) {
            return 'p';
        }
        if (pointColourer instanceof VertSpeedColourer) {
            return 'v';
        }
        if (pointColourer instanceof GradientColourer) {
            return 'g';
        }
        if (pointColourer instanceof DateColourer) {
            return 'd';
        }
        throw new IllegalArgumentException("Unrecognised colourer: " + pointColourer.getClass().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PointColourer createColourer(ColourerId colourerId, Color color, Color color2, String string, boolean bl) {
        try {
            switch (colourerId) {
                case NONE: {
                    return null;
                }
                case BY_FILE: {
                    return new FileColourer(color, color2, Integer.parseInt(string), bl);
                }
                case BY_SEGMENT: {
                    return new SegmentColourer(color, color2, Integer.parseInt(string), bl);
                }
                case BY_ALTITUDE: {
                    return new AltitudeColourer(color, color2, bl);
                }
                case BY_SPEED: {
                    return new SpeedColourer(color, color2, bl);
                }
                case BY_VSPEED: {
                    return new VertSpeedColourer(color, color2, bl);
                }
                case BY_GRADIENT: {
                    return new GradientColourer(color, color2, bl);
                }
                case BY_DATE: {
                    return new DateColourer(color, color2, Integer.parseInt(string), bl);
                }
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public static PointColourer createColourer(String string) {
        try {
            String[] stringArray = string.split(";");
            if (stringArray.length == 4 || stringArray.length == 5) {
                ColourerId colourerId = ColourerFactory.getColourerId(stringArray[0].charAt(0));
                Color color = ColourUtils.colourFromHex(stringArray[1]);
                Color color2 = ColourUtils.colourFromHex(stringArray[2]);
                String string2 = stringArray[3];
                boolean bl = stringArray.length == 5 && stringArray[4].equals("w");
                return ColourerFactory.createColourer(colourerId, color, color2, string2, bl);
            }
        }
        catch (NullPointerException | NumberFormatException runtimeException) {}
        return null;
    }

    public static String pointColourerToString(PointColourer pointColourer) {
        if (pointColourer != null) {
            String string = ColourUtils.makeHexCode(pointColourer.getStartColour());
            String string2 = ColourUtils.makeHexCode(pointColourer.getEndColour());
            boolean bl = pointColourer instanceof ContinuousPointColourer;
            int n = bl ? 0 : pointColourer.getMaxColours();
            String string3 = String.valueOf(ColourerFactory.getColourerPrefix(pointColourer)) + ";" + string + ";" + string2 + ";" + n;
            if (pointColourer.isWideHueScaling()) {
                string3 = String.valueOf(string3) + ";w";
            }
            return string3;
        }
        return null;
    }

    public static String getDescriptionKey(ColourerId colourerId) {
        switch (colourerId) {
            case NONE: {
                return "none";
            }
            case BY_FILE: {
                return "byfile";
            }
            case BY_SEGMENT: {
                return "bysegment";
            }
            case BY_ALTITUDE: {
                return "byaltitude";
            }
            case BY_SPEED: {
                return "byspeed";
            }
            case BY_VSPEED: {
                return "byvertspeed";
            }
            case BY_GRADIENT: {
                return "bygradient";
            }
            case BY_DATE: {
                return "bydate";
            }
        }
        return null;
    }

    public static ColourerId getId(PointColourer pointColourer) {
        if (pointColourer != null) {
            if (pointColourer instanceof FileColourer) {
                return ColourerId.BY_FILE;
            }
            if (pointColourer instanceof SegmentColourer) {
                return ColourerId.BY_SEGMENT;
            }
            if (pointColourer instanceof AltitudeColourer) {
                return ColourerId.BY_ALTITUDE;
            }
            if (pointColourer instanceof SpeedColourer) {
                return ColourerId.BY_SPEED;
            }
            if (pointColourer instanceof VertSpeedColourer) {
                return ColourerId.BY_VSPEED;
            }
            if (pointColourer instanceof GradientColourer) {
                return ColourerId.BY_GRADIENT;
            }
            if (pointColourer instanceof DateColourer) {
                return ColourerId.BY_DATE;
            }
        }
        return ColourerId.NONE;
    }

    public static enum ColourerId {
        NONE,
        BY_FILE,
        BY_SEGMENT,
        BY_ALTITUDE,
        BY_SPEED,
        BY_VSPEED,
        BY_GRADIENT,
        BY_DATE;

    }
}

