/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Table;

class CpalTable
implements Table {
    private final int _version;
    private final int _numPalettesEntries;
    private final int _numPalette;
    private final int _numColorRecords;
    private final int _offsetFirstColorRecord;
    private final int[] _colorRecordIndices;
    private final int _offsetPaletteTypeArray;
    private final int _offsetPaletteLabelArray;
    private final int _offsetPaletteEntryLabelArray;
    private final ColorRecord[] _colorRecords;

    protected CpalTable(DataInput dataInput) throws IOException {
        int n;
        this._version = dataInput.readUnsignedShort();
        this._numPalettesEntries = dataInput.readUnsignedShort();
        this._numPalette = dataInput.readUnsignedShort();
        this._numColorRecords = dataInput.readUnsignedShort();
        this._offsetFirstColorRecord = dataInput.readInt();
        int n2 = 12;
        this._colorRecordIndices = new int[this._numPalette];
        for (n = 0; n < this._numPalette; ++n) {
            this._colorRecordIndices[n] = dataInput.readUnsignedShort();
            n2 += 2;
        }
        if (this._version == 1) {
            this._offsetPaletteTypeArray = dataInput.readInt();
            this._offsetPaletteLabelArray = dataInput.readInt();
            this._offsetPaletteEntryLabelArray = dataInput.readInt();
            n2 += 12;
        } else {
            this._offsetPaletteTypeArray = -1;
            this._offsetPaletteLabelArray = -1;
            this._offsetPaletteEntryLabelArray = -1;
        }
        if (this._offsetFirstColorRecord > n2) {
            dataInput.skipBytes(n2 - this._offsetFirstColorRecord);
        }
        this._colorRecords = new ColorRecord[this._numColorRecords];
        for (n = 0; n < this._numColorRecords; ++n) {
            this._colorRecords[n] = new ColorRecord(dataInput);
        }
        if (this._version == 1) {
            // empty if block
        }
    }

    public int getNumPalettesEntries() {
        return this._numPalettesEntries;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'CPAL' Table\n------------\nColor Record Indices\n");
        int n = 0;
        for (int n3 : this._colorRecordIndices) {
            stringBuilder.append(String.format("%d: %d\n", n++, n3));
        }
        stringBuilder.append("\nColor Records\n");
        n = 0;
        for (ColorRecord colorRecord : this._colorRecords) {
            stringBuilder.append(String.format("%d: B: %3d, G: %3d, R: %3d, A: %3d\n", n++, colorRecord.getBlue(), colorRecord.getGreen(), colorRecord.getRed(), colorRecord.getAlpha()));
        }
        return stringBuilder.toString();
    }

    static class ColorRecord {
        private final short _blue;
        private final short _green;
        private final short _red;
        private final short _alpha;

        ColorRecord(DataInput dataInput) throws IOException {
            this._blue = (short)dataInput.readUnsignedByte();
            this._green = (short)dataInput.readUnsignedByte();
            this._red = (short)dataInput.readUnsignedByte();
            this._alpha = (short)dataInput.readUnsignedByte();
        }

        short getBlue() {
            return this._blue;
        }

        short getGreen() {
            return this._green;
        }

        short getRed() {
            return this._red;
        }

        short getAlpha() {
            return this._alpha;
        }
    }
}

