/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastGlyph;
import jogamp.graph.font.typecast.TypecastHMetrics;
import jogamp.graph.font.typecast.TypecastRenderer;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.TTFont;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.KernSubtable;
import jogamp.graph.font.typecast.ot.table.KernTable;
import jogamp.graph.font.typecast.ot.table.PostTable;

class TypecastFont
implements Font {
    static final boolean DEBUG = false;
    final TTFont font;
    private final CmapFormat cmapFormat;
    private final int cmapentries;
    private final IntObjectHashMap idToGlyph;
    private final TypecastHMetrics metrics;
    private static final boolean forceAscii = false;

    public TypecastFont(OTFontCollection oTFontCollection) {
        this.font = oTFontCollection.getFont(0);
        CmapTable cmapTable = this.font.getCmapTable();
        int n = -1;
        int n2 = -1;
        n = 3;
        n2 = 1;
        CmapFormat cmapFormat = cmapTable.getCmapFormat((short)3, (short)1);
        if (cmapFormat == null) {
            n2 = 0;
            cmapFormat = cmapTable.getCmapFormat((short)3, (short)0);
        }
        if (cmapFormat == null) {
            throw new RuntimeException("Cannot find a suitable cmap table");
        }
        this.cmapFormat = cmapFormat;
        int n3 = 0;
        for (int i = 0; i < this.cmapFormat.getRangeCount(); ++i) {
            CmapFormat.Range range = this.cmapFormat.getRange(i);
            n3 += range.getEndCode() - range.getStartCode() + 1;
        }
        this.cmapentries = n3;
        this.idToGlyph = new IntObjectHashMap(this.cmapentries + this.cmapentries / 4);
        this.metrics = new TypecastHMetrics(this);
    }

    @Override
    public String getName(int n) {
        return this.font.getName(n);
    }

    @Override
    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        return this.font.getAllNames(stringBuilder, string);
    }

    @Override
    public String getFullFamilyName() {
        return this.getName(1) + "-" + this.getName(2);
    }

    @Override
    public float getAdvanceWidth(int n) {
        return this.metrics.getScale(this.font.getHmtxTable().getAdvanceWidth(n));
    }

    @Override
    public int getAdvanceWidthFU(int n) {
        return this.font.getHmtxTable().getAdvanceWidth(n);
    }

    @Override
    public final Font.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public int getGlyphID(char c) {
        int n = this.cmapFormat.mapCharCode(c);
        if (0 < n) {
            return n;
        }
        return 0;
    }

    PostTable getPostTable() {
        return this.font.getPostTable();
    }

    @Override
    public int getGlyphCount() {
        return this.font.getGlyphCount();
    }

    @Override
    public Font.Glyph getGlyph(int n) {
        TypecastGlyph typecastGlyph = (TypecastGlyph)this.idToGlyph.get(n);
        if (null == typecastGlyph) {
            boolean bl;
            OutlineShape outlineShape;
            AABBox aABBox;
            Object object;
            Object object2;
            short s;
            int n2;
            PostTable postTable;
            Glyph glyph = this.font.getGlyph(n);
            String string = null != glyph ? (null != (postTable = this.font.getPostTable()) ? postTable.getGlyphName(n) : "") : "";
            int n3 = this.metrics.getAscentFU() - this.metrics.getDescentFU();
            if (null != glyph) {
                n2 = glyph.getAdvanceWidth();
                s = glyph.getLeftSideBearing();
                object2 = glyph.getBBox();
                object = TypecastRenderer.buildShape(this.metrics.getUnitsPerEM(), glyph);
                if (0 < ((OutlineShape)object).getVertexCount()) {
                    aABBox = object2;
                    outlineShape = object;
                    bl = false;
                } else {
                    aABBox = new AABBox(0.0f, 0.0f, 0.0f, n2, n3, 0.0f);
                    outlineShape = TypecastRenderer.buildEmptyShape(this.metrics.getUnitsPerEM(), aABBox);
                    bl = true;
                }
            } else {
                n2 = this.getAdvanceWidthFU(n);
                s = 0;
                aABBox = new AABBox(0.0f, 0.0f, 0.0f, n2, n3, 0.0f);
                outlineShape = TypecastRenderer.buildEmptyShape(this.metrics.getUnitsPerEM(), aABBox);
                bl = true;
            }
            object2 = null;
            object = this.font.getKernTable();
            if (object != null) {
                object2 = ((KernTable)object).getSubtable0();
            }
            typecastGlyph = new TypecastGlyph(this, n, string, aABBox, n2, s, (KernSubtable)object2, outlineShape, bl);
            if (null != glyph) {
                glyph.clearPointData();
            }
            this.idToGlyph.put(n, (Object)typecastGlyph);
        }
        return typecastGlyph;
    }

    @Override
    public float getLineHeight() {
        return this.metrics.getScale(this.getLineHeightFU());
    }

    @Override
    public int getLineHeightFU() {
        Font.Metrics metrics = this.getMetrics();
        return metrics.getAscentFU() - metrics.getDescentFU() + metrics.getLineGapFU();
    }

    @Override
    public AABBox getMetricBounds(CharSequence charSequence) {
        return this.getMetricBoundsFU(charSequence).scale2(1.0f / (float)this.metrics.getUnitsPerEM());
    }

    @Override
    public AABBox getMetricBoundsFU(CharSequence charSequence) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        AABBox aABBox = new AABBox();
        int n = charSequence.length();
        int n2 = this.getLineHeightFU();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                n4 = 0;
                n3 -= n2;
            } else {
                n4 += this.getAdvanceWidthFU(this.getGlyphID(c));
            }
            aABBox.resize(n4, n3, 0.0f);
        }
        if (0 < n4) {
            aABBox.resize(n4, n3 -= n2, 0.0f);
        }
        return aABBox;
    }

    @Override
    public AABBox getGlyphBounds(CharSequence charSequence) {
        return this.getGlyphBounds(charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox getGlyphBounds(CharSequence charSequence, AffineTransform affineTransform, AffineTransform affineTransform2) {
        return this.getGlyphBoundsFU(charSequence, affineTransform, affineTransform2).scale2(1.0f / (float)this.metrics.getUnitsPerEM());
    }

    @Override
    public AABBox getGlyphBoundsFU(CharSequence charSequence) {
        return this.getGlyphBoundsFU(charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox getGlyphBoundsFU(CharSequence charSequence, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        AABBox aABBox = new AABBox();
        int n = charSequence.length();
        int n2 = this.getLineHeightFU();
        int n3 = 0;
        int n4 = 0;
        Font.Glyph glyph = null;
        AABBox aABBox2 = new AABBox();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) {
                n3 -= n2;
                n4 = 0;
                glyph = null;
                continue;
            }
            affineTransform.setToIdentity();
            int n5 = this.getGlyphID(c);
            Font.Glyph glyph2 = this.getGlyph(n5);
            OutlineShape outlineShape = glyph2.getShape();
            if (null == outlineShape) {
                n4 += glyph2.getAdvanceFU();
                glyph = null;
                continue;
            }
            if (glyph2.isWhiteSpace()) {
                glyph = null;
            }
            if (null != glyph) {
                n4 += glyph.getKerningFU(n5);
            }
            affineTransform.translate(n4, n3, affineTransform2);
            aABBox.resize(affineTransform.transform(glyph2.getBoundsFU(), aABBox2));
            n4 += glyph2.getAdvanceFU();
            if (glyph2.isWhiteSpace()) continue;
            glyph = glyph2;
        }
        return aABBox;
    }

    @Override
    public AABBox getGlyphShapeBounds(AffineTransform affineTransform, CharSequence charSequence) {
        return this.getGlyphShapeBounds(affineTransform, charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox getGlyphShapeBounds(AffineTransform affineTransform, CharSequence charSequence, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

            @Override
            public final void visit(char c, Font.Glyph glyph, AffineTransform affineTransform) {
            }
        };
        return this.processString(glyphVisitor, affineTransform, charSequence, affineTransform2, affineTransform3);
    }

    @Override
    public AABBox processString(Font.GlyphVisitor glyphVisitor, AffineTransform affineTransform, CharSequence charSequence) {
        return this.processString(glyphVisitor, affineTransform, charSequence, new AffineTransform(), new AffineTransform());
    }

    @Override
    public AABBox processString(Font.GlyphVisitor glyphVisitor, AffineTransform affineTransform, CharSequence charSequence, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        if (null == charSequence || 0 == charSequence.length()) {
            return new AABBox();
        }
        AABBox aABBox = new AABBox();
        int n = charSequence.length();
        float f = this.getLineHeight();
        float f2 = 0.0f;
        float f3 = 0.0f;
        Font.Glyph glyph = null;
        AABBox aABBox2 = new AABBox();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) {
                f2 -= f;
                f3 = 0.0f;
                glyph = null;
                continue;
            }
            if (null != affineTransform) {
                affineTransform2.setTransform(affineTransform);
            } else {
                affineTransform2.setToIdentity();
            }
            int n2 = this.getGlyphID(c);
            Font.Glyph glyph2 = this.getGlyph(n2);
            OutlineShape outlineShape = glyph2.getShape();
            if (null == outlineShape) {
                f3 += glyph2.getAdvance();
                glyph = null;
                continue;
            }
            if (glyph2.isWhiteSpace()) {
                glyph = null;
            }
            if (null != glyph) {
                f3 += glyph.getKerning(n2);
            }
            affineTransform2.translate(f3, f2, affineTransform3);
            aABBox.resize(affineTransform2.transform(outlineShape.getBounds(), aABBox2));
            glyphVisitor.visit(c, glyph2, affineTransform2);
            f3 += glyph2.getAdvance();
            if (glyph2.isWhiteSpace()) continue;
            glyph = glyph2;
        }
        return aABBox;
    }

    @Override
    public void processString(Font.GlyphVisitor2 glyphVisitor2, CharSequence charSequence) {
        if (null == charSequence || 0 == charSequence.length()) {
            return;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            Font.Glyph glyph;
            char c = charSequence.charAt(i);
            if ('\n' == c || null == (glyph = this.getGlyph(this.getGlyphID(c))).getShape()) continue;
            glyphVisitor2.visit(c, glyph);
        }
    }

    @Override
    public final int getNumGlyphs() {
        return this.font.getNumGlyphs();
    }

    @Override
    public boolean isPrintableChar(char c) {
        return FontFactory.isPrintableChar(c);
    }

    @Override
    public final int hashCode() {
        return this.font.getName(3).hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TypecastFont) {
            return ((TypecastFont)object).font.getName(3).equals(this.font.getName(3));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getFullFamilyName();
    }

    @Override
    public String fullString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString()).append("[ ").append(this.font.toString());
        stringBuilder.append("\n").append(this.font.getHeadTable());
        stringBuilder.append("\n\n").append(this.font.getHheaTable());
        if (null != this.font.getVheaTable()) {
            stringBuilder.append("\n\n").append(this.font.getVheaTable());
        }
        stringBuilder.append("\n\n").append(this.font.getCmapTable());
        stringBuilder.append("\n").append(this.font.getMaxpTable());
        stringBuilder.append("\n\n").append(this.font.getOS2Table());
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }
}

