%%
%% %CopyrightBegin%
%%
%% SPDX-License-Identifier: Apache-2.0 AND LicenseRef-scancode-wxwindows-free-doc-3
%%
%% Copyright Ericsson AB 2008-2025. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% For documentation, wxWindow Free Documentation License, Version 3 applies.
%% wxWindows Free Documentation Licence, Version 3, as follows.
%% ===============================================
%%
%% Everyone is permitted to copy and distribute verbatim copies
%% of this licence document, but changing it is not allowed.
%%
%%                  WXWINDOWS FREE DOCUMENTATION LICENCE
%%    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
%%
%% 1. Permission is granted to make and distribute verbatim copies of this
%% manual or piece of documentation provided any copyright notice and this
%% permission notice are preserved on all copies.
%%
%% 2. Permission is granted to process this file or document through a
%% document processing system and, at your option and the option of any third
%% party, print the results, provided a printed document carries a copying
%% permission notice identical to this one.
%%
%% 3. Permission is granted to copy and distribute modified versions of this
%% manual or piece of documentation under the conditions for verbatim copying,
%% provided also that any sections describing licensing conditions for this
%% manual, such as, in particular, the GNU General Public Licence, the GNU
%% Library General Public Licence, and any wxWindows Licence are included
%% exactly as in the original, and provided that the entire resulting derived
%% work is distributed under the terms of a permission notice identical to
%% this one.
%%
%% 4. Permission is granted to copy and distribute translations of this manual
%% or piece of documentation into another language, under the above conditions
%% for modified versions, except that sections related to licensing, including
%% this paragraph, may also be included in translations approved by the
%% copyright holders of the respective licence documents in addition to the
%% original English.
%%
%% %CopyrightEnd%
%% This file is generated DO NOT EDIT

-module(wxMouseEvent).
-moduledoc """
This event class contains information about the events generated by the mouse: they
include mouse buttons press and release events and mouse move events.

All mouse events involving the buttons use `wxMOUSE_BTN_LEFT` for the left mouse button, `wxMOUSE_BTN_MIDDLE`
for the middle one and `wxMOUSE_BTN_RIGHT` for the right one. And if the system supports
more buttons, the `wxMOUSE_BTN_AUX1` and `wxMOUSE_BTN_AUX2` events can also be generated.
Note that not all mice have even a middle button so a portable application should avoid
relying on the events from it (but the right button click can be emulated using the left
mouse button with the control key under Mac platforms with a single button mouse).

For the `wxEVT_ENTER_WINDOW` and `wxEVT_LEAVE_WINDOW` events purposes, the mouse is
considered to be inside the window if it is in the window client area and not inside one
of its children. In other words, the parent window receives `wxEVT_LEAVE_WINDOW` event not
only when the mouse leaves the window entirely but also when it enters one of its children.

The position associated with a mouse event is expressed in the window coordinates of the
window which generated the event, you can use `wxWindow:clientToScreen/3` to convert it to screen coordinates and
possibly call `wxWindow:screenToClient/2` next to convert it to window coordinates of another window.

Note: Note the difference between methods like `leftDown/1` and the inherited `leftIsDown/1`: the former returns
true when the event corresponds to the left mouse button click while the latter returns
true if the left mouse button is currently being pressed. For example, when the user is
dragging the mouse you can use `leftIsDown/1` to test whether the left mouse button is (still)
depressed. Also, by convention, if `leftDown/1` returns true, `leftIsDown/1` will also return true in wxWidgets
whatever the underlying GUI behaviour is (which is platform-dependent). The same applies,
of course, to other mouse buttons as well.

See: `m:wxKeyEvent`

This class is derived, and can use functions, from:

* `m:wxEvent`

wxWidgets docs: [wxMouseEvent](https://docs.wxwidgets.org/3.2/classwx_mouse_event.html)

## Events

Use `wxEvtHandler:connect/3` with `wxMouseEventType` to subscribe to events of this type.
""".
-include("wxe.hrl").
-export([altDown/1,aux1DClick/1,aux1Down/1,aux1Up/1,aux2DClick/1,aux2Down/1,
  aux2Up/1,button/2,buttonDClick/1,buttonDClick/2,buttonDown/1,buttonDown/2,
  buttonUp/1,buttonUp/2,cmdDown/1,controlDown/1,dragging/1,entering/1,
  getButton/1,getLinesPerAction/1,getLogicalPosition/2,getPosition/1,
  getWheelAxis/1,getWheelDelta/1,getWheelRotation/1,getX/1,getY/1,isButton/1,
  isPageScroll/1,leaving/1,leftDClick/1,leftDown/1,leftIsDown/1,leftUp/1,
  metaDown/1,middleDClick/1,middleDown/1,middleIsDown/1,middleUp/1,moving/1,
  rightDClick/1,rightDown/1,rightIsDown/1,rightUp/1,shiftDown/1]).

%% inherited exports
-export([getId/1,getSkipped/1,getTimestamp/1,isCommandEvent/1,parent_class/1,
  resumePropagation/2,shouldPropagate/1,skip/1,skip/2,stopPropagation/1]).

-type wxMouseEvent() :: wx:wx_object().
-include("wx.hrl").
-type wxMouseEventType() :: 'left_down' | 'left_up' | 'middle_down' | 'middle_up' | 'right_down' | 'right_up' | 'motion' | 'enter_window' | 'leave_window' | 'left_dclick' | 'middle_dclick' | 'right_dclick' | 'mousewheel' | 'aux1_down' | 'aux1_up' | 'aux1_dclick' | 'aux2_down' | 'aux2_up' | 'aux2_dclick'.
-export_type([wxMouseEvent/0, wxMouse/0, wxMouseEventType/0]).
-doc false.
parent_class(wxEvent) -> true;
parent_class(_Class) -> erlang:error({badtype, ?MODULE}).

-doc """
Returns true if the Alt key is pressed.

Notice that `wxKeyEvent:getModifiers/1` should usually be used instead of this one.
""".
-spec altDown(This) -> boolean() when
	This::wxMouseEvent().
altDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_AltDown),
  wxe_util:rec(?wxMouseEvent_AltDown).

-doc "Returns true if the event was generated by the specified button.".
%%  But = ?wxMOUSE_BTN_ANY | ?wxMOUSE_BTN_NONE | ?wxMOUSE_BTN_LEFT | ?wxMOUSE_BTN_MIDDLE | ?wxMOUSE_BTN_RIGHT | ?wxMOUSE_BTN_AUX1 | ?wxMOUSE_BTN_AUX2 | ?wxMOUSE_BTN_MAX
-spec button(This, But) -> boolean() when
	This::wxMouseEvent(), But::wx:wx_enum().
button(#wx_ref{type=ThisT}=This,But)
 when is_integer(But) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,But,?get_env(),?wxMouseEvent_Button),
  wxe_util:rec(?wxMouseEvent_Button).

-doc(#{equiv => buttonDClick(This, [])}).
-spec buttonDClick(This) -> boolean() when
	This::wxMouseEvent().

buttonDClick(This)
 when is_record(This, wx_ref) ->
  buttonDClick(This, []).

-doc """
If the argument is omitted, this returns true if the event was a mouse double click
event.

Otherwise the argument specifies which double click event was generated (see `button/2` for the
possible values).
""".
%%  But = ?wxMOUSE_BTN_ANY | ?wxMOUSE_BTN_NONE | ?wxMOUSE_BTN_LEFT | ?wxMOUSE_BTN_MIDDLE | ?wxMOUSE_BTN_RIGHT | ?wxMOUSE_BTN_AUX1 | ?wxMOUSE_BTN_AUX2 | ?wxMOUSE_BTN_MAX
-spec buttonDClick(This, [Option]) -> boolean() when
	This::wxMouseEvent(),
	Option :: {'but', wx:wx_enum()}.
buttonDClick(#wx_ref{type=ThisT}=This, Options)
 when is_list(Options) ->
  ?CLASS(ThisT,wxMouseEvent),
  MOpts = fun({but, _but} = Arg) -> Arg;
          (BadOpt) -> erlang:error({badoption, BadOpt}) end,
  Opts = lists:map(MOpts, Options),
  wxe_util:queue_cmd(This, Opts,?get_env(),?wxMouseEvent_ButtonDClick),
  wxe_util:rec(?wxMouseEvent_ButtonDClick).

-doc(#{equiv => buttonDown(This, [])}).
-spec buttonDown(This) -> boolean() when
	This::wxMouseEvent().

buttonDown(This)
 when is_record(This, wx_ref) ->
  buttonDown(This, []).

-doc """
If the argument is omitted, this returns true if the event was a mouse button down event.

Otherwise the argument specifies which button-down event was generated (see `button/2` for the
possible values).
""".
%%  But = ?wxMOUSE_BTN_ANY | ?wxMOUSE_BTN_NONE | ?wxMOUSE_BTN_LEFT | ?wxMOUSE_BTN_MIDDLE | ?wxMOUSE_BTN_RIGHT | ?wxMOUSE_BTN_AUX1 | ?wxMOUSE_BTN_AUX2 | ?wxMOUSE_BTN_MAX
-spec buttonDown(This, [Option]) -> boolean() when
	This::wxMouseEvent(),
	Option :: {'but', wx:wx_enum()}.
buttonDown(#wx_ref{type=ThisT}=This, Options)
 when is_list(Options) ->
  ?CLASS(ThisT,wxMouseEvent),
  MOpts = fun({but, _but} = Arg) -> Arg;
          (BadOpt) -> erlang:error({badoption, BadOpt}) end,
  Opts = lists:map(MOpts, Options),
  wxe_util:queue_cmd(This, Opts,?get_env(),?wxMouseEvent_ButtonDown),
  wxe_util:rec(?wxMouseEvent_ButtonDown).

-doc(#{equiv => buttonUp(This, [])}).
-spec buttonUp(This) -> boolean() when
	This::wxMouseEvent().

buttonUp(This)
 when is_record(This, wx_ref) ->
  buttonUp(This, []).

-doc """
If the argument is omitted, this returns true if the event was a mouse button up event.

Otherwise the argument specifies which button-up event was generated (see `button/2` for the
possible values).
""".
%%  But = ?wxMOUSE_BTN_ANY | ?wxMOUSE_BTN_NONE | ?wxMOUSE_BTN_LEFT | ?wxMOUSE_BTN_MIDDLE | ?wxMOUSE_BTN_RIGHT | ?wxMOUSE_BTN_AUX1 | ?wxMOUSE_BTN_AUX2 | ?wxMOUSE_BTN_MAX
-spec buttonUp(This, [Option]) -> boolean() when
	This::wxMouseEvent(),
	Option :: {'but', wx:wx_enum()}.
buttonUp(#wx_ref{type=ThisT}=This, Options)
 when is_list(Options) ->
  ?CLASS(ThisT,wxMouseEvent),
  MOpts = fun({but, _but} = Arg) -> Arg;
          (BadOpt) -> erlang:error({badoption, BadOpt}) end,
  Opts = lists:map(MOpts, Options),
  wxe_util:queue_cmd(This, Opts,?get_env(),?wxMouseEvent_ButtonUp),
  wxe_util:rec(?wxMouseEvent_ButtonUp).

-doc """
Returns true if the key used for command accelerators is pressed.

Same as `controlDown/1`. Deprecated.

Notice that `wxKeyEvent:getModifiers/1` should usually be used instead of this one.
""".
-spec cmdDown(This) -> boolean() when
	This::wxMouseEvent().
cmdDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_CmdDown),
  wxe_util:rec(?wxMouseEvent_CmdDown).

-doc """
Returns true if the Control key or Apple/Command key under macOS is pressed.

This function doesn't distinguish between right and left control keys.

Notice that `wxKeyEvent:getModifiers/1` should usually be used instead of this one.
""".
-spec controlDown(This) -> boolean() when
	This::wxMouseEvent().
controlDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_ControlDown),
  wxe_util:rec(?wxMouseEvent_ControlDown).

-doc """
Returns true if this was a dragging event (motion while a button is depressed).

See: `moving/1`
""".
-spec dragging(This) -> boolean() when
	This::wxMouseEvent().
dragging(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Dragging),
  wxe_util:rec(?wxMouseEvent_Dragging).

-doc """
Returns true if the mouse was entering the window.

See: `leaving/1`
""".
-spec entering(This) -> boolean() when
	This::wxMouseEvent().
entering(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Entering),
  wxe_util:rec(?wxMouseEvent_Entering).

-doc """
Returns the mouse button which generated this event or `wxMOUSE\_BTN\_NONE` if no button
is involved (for mouse move, enter or leave event, for example).

Otherwise `wxMOUSE_BTN_LEFT` is returned for the left button down, up and double click
events, `wxMOUSE_BTN_MIDDLE` and `wxMOUSE_BTN_RIGHT` for the same events for the middle
and the right buttons respectively.
""".
-spec getButton(This) -> integer() when
	This::wxMouseEvent().
getButton(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetButton),
  wxe_util:rec(?wxMouseEvent_GetButton).

-doc "Returns the physical mouse position.".
-spec getPosition(This) -> {X::integer(), Y::integer()} when
	This::wxMouseEvent().
getPosition(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetPosition),
  wxe_util:rec(?wxMouseEvent_GetPosition).

-doc """
Returns the logical mouse position in pixels (i.e. translated according to the
translation set for the DC, which usually indicates that the window has been scrolled).
""".
-spec getLogicalPosition(This, Dc) -> {X::integer(), Y::integer()} when
	This::wxMouseEvent(), Dc::wxDC:wxDC().
getLogicalPosition(#wx_ref{type=ThisT}=This,#wx_ref{type=DcT}=Dc) ->
  ?CLASS(ThisT,wxMouseEvent),
  ?CLASS(DcT,wxDC),
  wxe_util:queue_cmd(This,Dc,?get_env(),?wxMouseEvent_GetLogicalPosition),
  wxe_util:rec(?wxMouseEvent_GetLogicalPosition).

-doc """
Returns the configured number of lines (or whatever) to be scrolled per wheel action.

Default value under most platforms is three.
""".
-spec getLinesPerAction(This) -> integer() when
	This::wxMouseEvent().
getLinesPerAction(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetLinesPerAction),
  wxe_util:rec(?wxMouseEvent_GetLinesPerAction).

-doc """
Get wheel rotation, positive or negative indicates direction of rotation.

Current devices all send an event when rotation is at least +/-WheelDelta, but finer
resolution devices can be created in the future.

Because of this you shouldn't assume that one event is equal to 1 line, but you should be
able to either do partial line scrolling or wait until several events accumulate before
scrolling.
""".
-spec getWheelRotation(This) -> integer() when
	This::wxMouseEvent().
getWheelRotation(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetWheelRotation),
  wxe_util:rec(?wxMouseEvent_GetWheelRotation).

-doc """
Get wheel delta, normally 120.

This is the threshold for action to be taken, and one such action (for example, scrolling
one increment) should occur for each delta.
""".
-spec getWheelDelta(This) -> integer() when
	This::wxMouseEvent().
getWheelDelta(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetWheelDelta),
  wxe_util:rec(?wxMouseEvent_GetWheelDelta).

-doc "Returns X coordinate of the physical mouse event position.".
-spec getX(This) -> integer() when
	This::wxMouseEvent().
getX(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetX),
  wxe_util:rec(?wxMouseEvent_GetX).

-doc "Returns Y coordinate of the physical mouse event position.".
-spec getY(This) -> integer() when
	This::wxMouseEvent().
getY(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetY),
  wxe_util:rec(?wxMouseEvent_GetY).

-doc """
Returns true if the event was a mouse button event (not necessarily a button down event -
that may be tested using `buttonDown/2`).
""".
-spec isButton(This) -> boolean() when
	This::wxMouseEvent().
isButton(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_IsButton),
  wxe_util:rec(?wxMouseEvent_IsButton).

-doc """
Returns true if the system has been setup to do page scrolling with the mouse wheel
instead of line scrolling.
""".
-spec isPageScroll(This) -> boolean() when
	This::wxMouseEvent().
isPageScroll(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_IsPageScroll),
  wxe_util:rec(?wxMouseEvent_IsPageScroll).

-doc """
Returns true if the mouse was leaving the window.

See: `entering/1`
""".
-spec leaving(This) -> boolean() when
	This::wxMouseEvent().
leaving(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Leaving),
  wxe_util:rec(?wxMouseEvent_Leaving).

-doc "Returns true if the event was a left double click.".
-spec leftDClick(This) -> boolean() when
	This::wxMouseEvent().
leftDClick(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_LeftDClick),
  wxe_util:rec(?wxMouseEvent_LeftDClick).

-doc "Returns true if the left mouse button changed to down.".
-spec leftDown(This) -> boolean() when
	This::wxMouseEvent().
leftDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_LeftDown),
  wxe_util:rec(?wxMouseEvent_LeftDown).

-doc "Returns true if the left mouse button is currently down.".
-spec leftIsDown(This) -> boolean() when
	This::wxMouseEvent().
leftIsDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_LeftIsDown),
  wxe_util:rec(?wxMouseEvent_LeftIsDown).

-doc "Returns true if the left mouse button changed to up.".
-spec leftUp(This) -> boolean() when
	This::wxMouseEvent().
leftUp(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_LeftUp),
  wxe_util:rec(?wxMouseEvent_LeftUp).

-doc "Returns true if the Meta key was down at the time of the event.".
-spec metaDown(This) -> boolean() when
	This::wxMouseEvent().
metaDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_MetaDown),
  wxe_util:rec(?wxMouseEvent_MetaDown).

-doc "Returns true if the event was a middle double click.".
-spec middleDClick(This) -> boolean() when
	This::wxMouseEvent().
middleDClick(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_MiddleDClick),
  wxe_util:rec(?wxMouseEvent_MiddleDClick).

-doc "Returns true if the middle mouse button changed to down.".
-spec middleDown(This) -> boolean() when
	This::wxMouseEvent().
middleDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_MiddleDown),
  wxe_util:rec(?wxMouseEvent_MiddleDown).

-doc "Returns true if the middle mouse button is currently down.".
-spec middleIsDown(This) -> boolean() when
	This::wxMouseEvent().
middleIsDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_MiddleIsDown),
  wxe_util:rec(?wxMouseEvent_MiddleIsDown).

-doc "Returns true if the middle mouse button changed to up.".
-spec middleUp(This) -> boolean() when
	This::wxMouseEvent().
middleUp(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_MiddleUp),
  wxe_util:rec(?wxMouseEvent_MiddleUp).

-doc """
Returns true if this was a motion event and no mouse buttons were pressed.

If any mouse button is held pressed, then this method returns false and `dragging/1` returns true.
""".
-spec moving(This) -> boolean() when
	This::wxMouseEvent().
moving(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Moving),
  wxe_util:rec(?wxMouseEvent_Moving).

-doc "Returns true if the event was a right double click.".
-spec rightDClick(This) -> boolean() when
	This::wxMouseEvent().
rightDClick(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_RightDClick),
  wxe_util:rec(?wxMouseEvent_RightDClick).

-doc "Returns true if the right mouse button changed to down.".
-spec rightDown(This) -> boolean() when
	This::wxMouseEvent().
rightDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_RightDown),
  wxe_util:rec(?wxMouseEvent_RightDown).

-doc "Returns true if the right mouse button is currently down.".
-spec rightIsDown(This) -> boolean() when
	This::wxMouseEvent().
rightIsDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_RightIsDown),
  wxe_util:rec(?wxMouseEvent_RightIsDown).

-doc "Returns true if the right mouse button changed to up.".
-spec rightUp(This) -> boolean() when
	This::wxMouseEvent().
rightUp(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_RightUp),
  wxe_util:rec(?wxMouseEvent_RightUp).

-doc """
Returns true if the Shift key is pressed.

This function doesn't distinguish between right and left shift keys.

Notice that `wxKeyEvent:getModifiers/1` should usually be used instead of this one.
""".
-spec shiftDown(This) -> boolean() when
	This::wxMouseEvent().
shiftDown(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_ShiftDown),
  wxe_util:rec(?wxMouseEvent_ShiftDown).

-doc """
Gets the axis the wheel operation concerns.

Usually the mouse wheel is used to scroll vertically so `wxMOUSE_WHEEL_VERTICAL` is
returned but some mice (and most trackpads) also allow to use the wheel to scroll
horizontally in which case `wxMOUSE_WHEEL_HORIZONTAL` is returned.

Notice that before wxWidgets 2.9.4 this method returned `int`.
""".
%%  Res = ?wxMOUSE_WHEEL_VERTICAL | ?wxMOUSE_WHEEL_HORIZONTAL
-spec getWheelAxis(This) -> wx:wx_enum() when
	This::wxMouseEvent().
getWheelAxis(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_GetWheelAxis),
  wxe_util:rec(?wxMouseEvent_GetWheelAxis).

-doc "Returns true if the event was a first extra button double click.".
-spec aux1DClick(This) -> boolean() when
	This::wxMouseEvent().
aux1DClick(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Aux1DClick),
  wxe_util:rec(?wxMouseEvent_Aux1DClick).

-doc "Returns true if the first extra button mouse button changed to down.".
-spec aux1Down(This) -> boolean() when
	This::wxMouseEvent().
aux1Down(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Aux1Down),
  wxe_util:rec(?wxMouseEvent_Aux1Down).

-doc "Returns true if the first extra button mouse button changed to up.".
-spec aux1Up(This) -> boolean() when
	This::wxMouseEvent().
aux1Up(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Aux1Up),
  wxe_util:rec(?wxMouseEvent_Aux1Up).

-doc "Returns true if the event was a second extra button double click.".
-spec aux2DClick(This) -> boolean() when
	This::wxMouseEvent().
aux2DClick(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Aux2DClick),
  wxe_util:rec(?wxMouseEvent_Aux2DClick).

-doc "Returns true if the second extra button mouse button changed to down.".
-spec aux2Down(This) -> boolean() when
	This::wxMouseEvent().
aux2Down(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Aux2Down),
  wxe_util:rec(?wxMouseEvent_Aux2Down).

-doc "Returns true if the second extra button mouse button changed to up.".
-spec aux2Up(This) -> boolean() when
	This::wxMouseEvent().
aux2Up(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxMouseEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxMouseEvent_Aux2Up),
  wxe_util:rec(?wxMouseEvent_Aux2Up).

 %% From wxEvent
-doc false.
stopPropagation(This) -> wxEvent:stopPropagation(This).
-doc false.
skip(This, Options) -> wxEvent:skip(This, Options).
-doc false.
skip(This) -> wxEvent:skip(This).
-doc false.
shouldPropagate(This) -> wxEvent:shouldPropagate(This).
-doc false.
resumePropagation(This,PropagationLevel) -> wxEvent:resumePropagation(This,PropagationLevel).
-doc false.
isCommandEvent(This) -> wxEvent:isCommandEvent(This).
-doc false.
getTimestamp(This) -> wxEvent:getTimestamp(This).
-doc false.
getSkipped(This) -> wxEvent:getSkipped(This).
-doc false.
getId(This) -> wxEvent:getId(This).
