/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.project.ProjectExportData;
import org.jkiss.dbeaver.tools.project.ProjectExportWizardPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.XMLBuilder;

public class ProjectExportWizard
extends Wizard
implements IExportWizard {
    private static final Log log = Log.getLog(ProjectExportWizard.class);
    private static final int COPY_BUFFER_SIZE = 5000;
    private static final String PROJECT_DESC_FILE = ".project";
    private static final Set<String> IGNORED_RESOURCES = new HashSet<String>();
    private ProjectExportWizardPage mainPage;

    static {
        IGNORED_RESOURCES.add(PROJECT_DESC_FILE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(CoreMessages.dialog_project_export_wizard_window_title);
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ProjectExportWizardPage(CoreMessages.dialog_project_export_wizard_main_page);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        ProjectExportData exportData = this.mainPage.getExportData();
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                try {
                    this.exportProjects(monitor, exportData);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ex) {
            DBWorkbench.getPlatformUI().showError("Export error", "Cannot export projects", ex.getTargetException());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void exportProjects(DBRProgressMonitor monitor, ProjectExportData exportData) throws IOException, CoreException, InterruptedException {
        boolean overwrite;
        if (!exportData.getOutputFolder().exists() && !exportData.getOutputFolder().mkdirs()) {
            throw new IOException("Cannot create directory '" + exportData.getOutputFolder().getAbsolutePath() + "'");
        }
        String archiveName = exportData.getArchiveFileName() + ".dbp";
        File archiveFile = new File(exportData.getOutputFolder(), archiveName);
        if (archiveFile.exists() && !(overwrite = DBWorkbench.getPlatformUI().confirmAction(CoreMessages.dialog_project_export_wizard_file_overwrite_window_title, NLS.bind((String)CoreMessages.dialog_project_export_wizard_file_overwrite_confirm, (Object)archiveName), true))) {
            return;
        }
        FileOutputStream exportStream = new FileOutputStream(archiveFile);
        try {
            ByteArrayOutputStream metaBuffer = new ByteArrayOutputStream(10000);
            ZipOutputStream archiveStream = new ZipOutputStream(exportStream);
            XMLBuilder meta = new XMLBuilder((OutputStream)metaBuffer, GeneralUtils.UTF8_ENCODING);
            meta.startElement("archive");
            meta.addAttribute("version", 1);
            exportData.initExport((DBPWorkspaceEclipse)DBPPlatformDesktop.getInstance().getWorkspace(), meta, archiveStream);
            InetAddress localHost = RuntimeUtils.getLocalHostOrLoopback();
            meta.startElement("source");
            meta.addAttribute("time", System.currentTimeMillis());
            meta.addAttribute("address", localHost.getHostAddress());
            meta.addAttribute("host", localHost.getHostName());
            meta.endElement();
            HashMap<RCPProject, Integer> resCountMap = new HashMap<RCPProject, Integer>();
            monitor.beginTask(CoreMessages.dialog_project_export_wizard_monitor_collect_info, exportData.getProjectsToExport().size());
            for (RCPProject rCPProject : exportData.getProjectsToExport()) {
                DBPDataSourceRegistry dataSourceRegistry = rCPProject.getDataSourceRegistry();
                if (dataSourceRegistry != null) {
                    for (DBPDataSourceContainer dBPDataSourceContainer : dataSourceRegistry.getDataSources()) {
                        exportData.usedDrivers.add(dBPDataSourceContainer.getDriver());
                    }
                }
                resCountMap.put(rCPProject, this.getChildCount(exportData, (IResource)rCPProject.getEclipseProject()));
                monitor.worked(1);
            }
            monitor.done();
            Throwable throwable = null;
            Iterator<RCPProject> iterator = null;
            try (XMLBuilder.Element ignored = exportData.meta.startElement("projects");){
                for (RCPProject rCPProject : exportData.getProjectsToExport()) {
                    monitor.beginTask(NLS.bind((String)CoreMessages.dialog_project_export_wizard_monitor_export_project, (Object)rCPProject.getName()), ((Integer)resCountMap.get(rCPProject)).intValue());
                    try {
                        this.exportProject(monitor, exportData, rCPProject.getEclipseProject());
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
            catch (Throwable throwable2) {
                void var10_17;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var10_17;
            }
            if (exportData.isExportDrivers()) {
                HashSet<Path> hashSet = new HashSet<Path>();
                HashMap<String, Path> libPathMap = new HashMap<String, Path>();
                for (DBPDriver driver : exportData.usedDrivers) {
                    for (DBPDriverLibrary fileDescriptor : driver.getDriverLibraries()) {
                        Path libraryFile = fileDescriptor.getLocalFile();
                        if (libraryFile == null || fileDescriptor.isDisabled() || !Files.exists(libraryFile, new LinkOption[0])) continue;
                        hashSet.add(libraryFile);
                        libPathMap.put(fileDescriptor.getPath(), libraryFile);
                    }
                }
                if (!hashSet.isEmpty()) {
                    monitor.beginTask(CoreMessages.dialog_project_export_wizard_monitor_export_libraries, hashSet.size());
                    ZipEntry driversFolder = new ZipEntry("drivers/");
                    driversFolder.setComment("Database driver libraries");
                    exportData.archiveStream.putNextEntry(driversFolder);
                    exportData.archiveStream.closeEntry();
                    exportData.meta.startElement("libraries");
                    HashSet<String> hashSet2 = new HashSet<String>();
                    for (String libPath : libPathMap.keySet()) {
                        Path libFile = (Path)libPathMap.get(libPath);
                        if (Files.isDirectory(libFile, new LinkOption[0])) continue;
                        String libFileName = libFile.getFileName().toString();
                        if (hashSet2.contains(libFileName)) {
                            log.warn((Object)("Duplicate driver library file name: " + libFileName));
                            continue;
                        }
                        hashSet2.add(libFileName);
                        monitor.subTask(libFileName);
                        exportData.meta.startElement("file");
                        exportData.meta.addAttribute("path", libPath);
                        exportData.meta.addAttribute("file", "drivers/" + libFileName);
                        exportData.meta.endElement();
                        ZipEntry driverFile = new ZipEntry("drivers/" + libFileName);
                        driverFile.setComment("Driver library");
                        exportData.archiveStream.putNextEntry(driverFile);
                        Throwable throwable4 = null;
                        Object var20_33 = null;
                        try (InputStream is = Files.newInputStream(libFile, new OpenOption[0]);){
                            IOUtils.copyStream((InputStream)is, (OutputStream)exportData.archiveStream, (int)5000);
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                        exportData.archiveStream.closeEntry();
                        monitor.worked(1);
                    }
                    exportData.meta.endElement();
                    monitor.done();
                }
            }
            exportData.meta.endElement();
            exportData.meta.flush();
            archiveStream.putNextEntry(new ZipEntry("meta.xml"));
            archiveStream.write(metaBuffer.toByteArray());
            archiveStream.closeEntry();
            archiveStream.finish();
        }
        finally {
            ContentUtils.close((Closeable)exportStream);
        }
    }

    private int getChildCount(ProjectExportData exportData, IResource resource) throws CoreException {
        if (DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resource) == null) {
            return 0;
        }
        int childCount = 1;
        if (resource instanceof IContainer) {
            IResource[] iResourceArray = ((IContainer)resource).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                childCount += this.getChildCount(exportData, child);
                ++n2;
            }
        }
        return childCount;
    }

    private void exportProject(DBRProgressMonitor monitor, ProjectExportData exportData, IProject project) throws CoreException, IOException {
        monitor.subTask(project.getName());
        project.refreshLocal(2, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
        exportData.meta.startElement("project");
        exportData.meta.addAttribute("name", project.getName());
        exportData.meta.addAttribute("description", project.getDescription().getComment());
        String projectPath = "projects/" + project.getName() + "/";
        exportData.archiveStream.putNextEntry(new ZipEntry(projectPath));
        exportData.archiveStream.closeEntry();
        IResource[] iResourceArray = project.members(8);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            this.exportResourceTree(monitor, exportData, projectPath, child);
            ++n2;
        }
        exportData.meta.endElement();
        monitor.worked(1);
    }

    private void exportResourceTree(DBRProgressMonitor monitor, ProjectExportData exportData, String parentPath, IResource resource) throws CoreException, IOException {
        if (IGNORED_RESOURCES.contains(resource.getName())) {
            return;
        }
        monitor.subTask((String)parentPath + resource.getName());
        exportData.meta.startElement("resource");
        exportData.meta.addAttribute("name", resource.getName());
        if (resource instanceof IContainer) {
            IResource[] members;
            parentPath = (String)parentPath + resource.getName() + "/";
            exportData.archiveStream.putNextEntry(new ZipEntry((String)parentPath));
            exportData.archiveStream.closeEntry();
            IResource[] iResourceArray = members = ((IContainer)resource).members(10);
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (!child.isLinked()) {
                    this.exportResourceTree(monitor, exportData, (String)parentPath, child);
                }
                ++n2;
            }
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            exportData.archiveStream.putNextEntry(new ZipEntry((String)parentPath + resource.getName()));
            Throwable throwable = null;
            Object var7_11 = null;
            try (InputStream is = file.getContents();){
                IOUtils.copyStream((InputStream)is, (OutputStream)exportData.archiveStream, (int)5000);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            exportData.archiveStream.closeEntry();
        }
        exportData.meta.endElement();
        monitor.worked(1);
    }
}

