/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IChangeGroupingRequestor;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSetManager;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class ActiveChangeSetManager
extends ChangeSetManager
implements IDiffChangeListener,
IChangeGroupingRequestor {
    private static final String CTX_DEFAULT_SET = "defaultSet";
    private ActiveChangeSet defaultSet;

    protected ChangeSet getChangeSet(IResourceDiffTree tree) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet changeSet = changeSetArray[n2];
            if (((DiffChangeSet)changeSet).getDiffTree() == tree) {
                return changeSet;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void add(ChangeSet set) {
        Assert.isTrue((boolean)(set instanceof ActiveChangeSet));
        super.add(set);
    }

    @Override
    protected void handleSetAdded(ChangeSet set) {
        Assert.isTrue((boolean)(set instanceof ActiveChangeSet));
        ((DiffChangeSet)set).getDiffTree().addDiffChangeListener(this.getDiffTreeListener());
        super.handleSetAdded(set);
        this.handleAddedResources(set, ((ActiveChangeSet)set).internalGetDiffTree().getDiffs());
    }

    @Override
    protected void handleSetRemoved(ChangeSet set) {
        ((DiffChangeSet)set).getDiffTree().removeDiffChangeListener(this.getDiffTreeListener());
        super.handleSetRemoved(set);
    }

    protected IDiffChangeListener getDiffTreeListener() {
        return this;
    }

    @Override
    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IResourceDiffTree tree = (IResourceDiffTree)event.getTree();
        this.handleSyncSetChange(tree, event.getAdditions(), this.getAllResources(event));
    }

    @Override
    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    @Override
    public boolean isModified(IFile file) throws CoreException {
        IDiff diff = this.getDiff((IResource)file);
        if (diff != null) {
            return this.isModified(diff);
        }
        return false;
    }

    public boolean isModified(IDiff diff) {
        if (diff != null) {
            if (diff instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)diff;
                int dir = twd.getDirection();
                return dir == 256 || dir == 768;
            }
            return diff.getKind() != 0;
        }
        return false;
    }

    public ActiveChangeSet getSet(String name) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            if (set.getName().equals(name) && set instanceof ActiveChangeSet) {
                return (ActiveChangeSet)set;
            }
            ++n2;
        }
        return null;
    }

    public ActiveChangeSet createSet(String title, IFile[] files) throws CoreException {
        ArrayList<IDiff> infos = new ArrayList<IDiff>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            IDiff diff = this.getDiff((IResource)file);
            if (diff != null) {
                infos.add(diff);
            }
            ++n2;
        }
        return this.createSet(title, infos.toArray(new IDiff[infos.size()]));
    }

    public ActiveChangeSet createSet(String title, IDiff[] diffs) {
        ActiveChangeSet commitSet = this.doCreateSet(title);
        if (diffs != null && diffs.length > 0) {
            commitSet.add(diffs);
        }
        return commitSet;
    }

    protected ActiveChangeSet doCreateSet(String name) {
        return new ActiveChangeSet(this, name);
    }

    public abstract IDiff getDiff(IResource var1) throws CoreException;

    protected boolean isSingleSetPerResource() {
        return true;
    }

    private IPath[] getAllResources(IDiffChangeEvent event) {
        IDiff[] changedResources;
        IDiff[] addedResources;
        HashSet<IPath> allResources = new HashSet<IPath>();
        IDiff[] iDiffArray = addedResources = event.getAdditions();
        int n = addedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            allResources.add(diff.getPath());
            ++n2;
        }
        IDiff[] iDiffArray2 = changedResources = event.getChanges();
        int n3 = changedResources.length;
        n = 0;
        while (n < n3) {
            IDiff diff = iDiffArray2[n];
            allResources.add(diff.getPath());
            ++n;
        }
        IPath[] removals = event.getRemovals();
        Collections.addAll(allResources, removals);
        return allResources.toArray(new IPath[allResources.size()]);
    }

    protected void handleAddedResources(ChangeSet set, IDiff[] diffs) {
        if (this.isSingleSetPerResource() && ((ActiveChangeSet)set).isUserCreated()) {
            ChangeSet[] sets;
            IResource[] resources = new IResource[diffs.length];
            int i = 0;
            while (i < resources.length) {
                resources[i] = ((DiffChangeSet)set).getDiffTree().getResource(diffs[i]);
                ++i;
            }
            ChangeSet[] changeSetArray = sets = this.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet otherSet = changeSetArray[n2];
                if (otherSet != set && ((ActiveChangeSet)otherSet).isUserCreated()) {
                    otherSet.remove(resources);
                }
                ++n2;
            }
        }
    }

    private void handleSyncSetChange(IResourceDiffTree tree, IDiff[] addedDiffs, IPath[] allAffectedResources) {
        ChangeSet changeSet = this.getChangeSet(tree);
        if (tree.isEmpty() && changeSet != null) {
            this.remove(changeSet);
        }
        this.fireResourcesChangedEvent(changeSet, allAffectedResources);
        this.handleAddedResources(changeSet, addedDiffs);
    }

    public void makeDefault(ActiveChangeSet set) {
        if (set != null && !this.contains(set)) {
            this.add(set);
        }
        ActiveChangeSet oldSet = this.defaultSet;
        this.defaultSet = set;
        this.fireDefaultChangedEvent(oldSet, this.defaultSet);
    }

    public boolean isDefault(ActiveChangeSet set) {
        return set == this.defaultSet;
    }

    public ActiveChangeSet getDefaultSet() {
        return this.defaultSet;
    }

    public ResourceTraversal[] adjustInputTraversals(ResourceTraversal[] traversals) {
        ChangeSet[] sets;
        CompoundResourceTraversal traversal = new CompoundResourceTraversal();
        traversal.addTraversals(traversals);
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            this.handleIntersect(traversal, set);
            ++n2;
        }
        return traversal.asTraversals();
    }

    private void handleIntersect(CompoundResourceTraversal traversal, ChangeSet set) {
        IResource[] resources;
        IResource[] iResourceArray = resources = set.getResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (traversal.isCovered(resource, 0)) {
                traversal.addResources(resources, 0);
                return;
            }
            ++n2;
        }
    }

    protected void save(Preferences prefs) {
        int n;
        int n2;
        Object[] objectArray;
        if (!this.isInitialized()) {
            return;
        }
        try {
            String[] oldSetNames = prefs.childrenNames();
            objectArray = oldSetNames;
            n2 = oldSetNames.length;
            n = 0;
            while (n < n2) {
                String string = objectArray[n];
                prefs.node(string).removeNode();
                ++n;
            }
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_5, (Object)this.getName()), e);
        }
        ChangeSet[] sets = this.getSets();
        objectArray = sets;
        n2 = sets.length;
        n = 0;
        while (n < n2) {
            Object set = objectArray[n];
            if (set instanceof ActiveChangeSet && !((ChangeSet)set).isEmpty()) {
                String childPrefName = ActiveChangeSetManager.escapePrefName(((ActiveChangeSet)set).getTitle());
                Preferences child = prefs.node(childPrefName);
                ((ActiveChangeSet)set).save(child);
            }
            ++n;
        }
        if (this.getDefaultSet() != null) {
            prefs.put(CTX_DEFAULT_SET, this.getDefaultSet().getTitle());
        } else {
            prefs.remove(CTX_DEFAULT_SET);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_3, (Object)this.getName()), e);
        }
    }

    private static String escapePrefName(String string) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '/': {
                    out.append("\\s");
                    break;
                }
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    protected void load(Preferences prefs) {
        String defaultSetTitle = prefs.get(CTX_DEFAULT_SET, null);
        try {
            String[] childNames;
            String[] stringArray = childNames = prefs.childrenNames();
            int n = childNames.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                Preferences childPrefs = prefs.node(string);
                ActiveChangeSet set = this.createSet(childPrefs);
                if (!set.isEmpty()) {
                    if (this.getDefaultSet() == null && defaultSetTitle != null && set.getTitle().equals(defaultSetTitle)) {
                        this.makeDefault(set);
                    }
                    this.add(set);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, NLS.bind((String)Messages.SubscriberChangeSetCollector_4, (Object)this.getName()), e);
        }
    }

    protected abstract String getName();

    protected ActiveChangeSet createSet(Preferences childPrefs) {
        ActiveChangeSet changeSet = this.doCreateSet(null);
        changeSet.init(childPrefs);
        return changeSet;
    }

    @Override
    public void ensureChangesGrouped(IProject project, IFile[] files, String name) throws CoreException {
        ActiveChangeSet set = this.getSet(name);
        if (set == null) {
            set = this.createSet(name, files);
            set.setUserCreated(false);
            this.add(set);
        } else {
            set.setUserCreated(false);
            set.add((IResource[])files);
        }
    }
}

