/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.data;

import java.sql.Timestamp;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStringValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;

public class SQLServerDateTimeOffsetHandler
extends JDBCDateTimeValueHandler {
    private static final Log log = Log.getLog(JDBCStringValueHandler.class);

    public SQLServerDateTimeOffsetHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null && object.getClass().getName().equals("microsoft.sql.DateTimeOffset") && !this.formatSettings.isUseNativeDateTimeFormat()) {
            int offsetSeconds;
            Timestamp timestamp;
            block7: {
                timestamp = (Timestamp)BeanUtils.invokeObjectMethod((Object)object, (String)"getTimestamp");
                int offset = (Integer)BeanUtils.invokeObjectMethod((Object)object, (String)"getMinutesOffset");
                offsetSeconds = offset * 60;
                if (timestamp != null) break block7;
                log.debug((Object)"Extracted timestamp is null");
                return null;
            }
            try {
                return timestamp.toInstant().atOffset(ZoneOffset.ofTotalSeconds(offsetSeconds));
            }
            catch (Throwable e) {
                log.debug((Object)"error extracting datetimeoffset timestamp", e);
            }
        }
        if (object instanceof String) {
            DBDDataFormatter formatter = this.getFormatter(type);
            try {
                return formatter.parseValue((String)object, OffsetDateTime.class);
            }
            catch (ParseException e) {
                log.debug((Object)"Error parsing offset datetime value", (Throwable)e);
                return null;
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        return "timestamptz";
    }

    @NotNull
    protected DBDDataFormatter getFormatter(DBSTypedObject column) {
        return super.getFormatter(column);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        if (value instanceof OffsetDateTime) {
            String s = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)value);
            super.bindValueObject(session, statement, type, index, (Object)s);
            return;
        }
        super.bindValueObject(session, statement, type, index, value);
    }
}

