/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.ssi.ByteArrayServletOutputStream;
import org.apache.catalina.ssi.ResponseIncludeWrapper;
import org.apache.catalina.ssi.SSIProcessor;
import org.apache.catalina.ssi.SSIServletExternalResolver;

public class SSIFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    protected int debug = 0;
    protected Long expires = null;
    protected boolean isVirtualWebappRelative = false;
    protected Pattern contentTypeRegEx = null;
    protected final Pattern shtmlRegEx = Pattern.compile("text/x-server-parsed-html(;.*)?");
    protected boolean allowExec = false;

    public void init() throws ServletException {
        if (this.getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getInitParameter("debug"));
        }
        this.contentTypeRegEx = this.getInitParameter("contentType") != null ? Pattern.compile(this.getInitParameter("contentType")) : this.shtmlRegEx;
        this.isVirtualWebappRelative = Boolean.parseBoolean(this.getInitParameter("isVirtualWebappRelative"));
        if (this.getInitParameter("expires") != null) {
            this.expires = Long.valueOf(this.getInitParameter("expires"));
        }
        this.allowExec = Boolean.parseBoolean(this.getInitParameter("allowExec"));
        if (this.debug > 0) {
            this.getServletContext().log("SSIFilter.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ByteArrayServletOutputStream byteArrayServletOutputStream = new ByteArrayServletOutputStream();
        ResponseIncludeWrapper responseIncludeWrapper = new ResponseIncludeWrapper(httpServletResponse, byteArrayServletOutputStream);
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)responseIncludeWrapper);
        responseIncludeWrapper.flushOutputStreamOrWriter();
        byte[] byArray = byteArrayServletOutputStream.toByteArray();
        String string = responseIncludeWrapper.getContentType();
        if (string != null && this.contentTypeRegEx.matcher(string).matches()) {
            object = httpServletResponse.getCharacterEncoding();
            SSIServletExternalResolver sSIServletExternalResolver = new SSIServletExternalResolver(this.getServletContext(), httpServletRequest, httpServletResponse, this.isVirtualWebappRelative, this.debug, (String)object);
            SSIProcessor sSIProcessor = new SSIProcessor(sSIServletExternalResolver, this.debug, this.allowExec);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), (String)object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, (String)object));
            long l = sSIProcessor.process(inputStreamReader, responseIncludeWrapper.getLastModified(), printWriter);
            printWriter.flush();
            byArray = byteArrayOutputStream.toByteArray();
            if (this.expires != null) {
                httpServletResponse.setDateHeader("expires", new Date().getTime() + this.expires * 1000L);
            }
            if (l > 0L) {
                httpServletResponse.setDateHeader("last-modified", l);
            }
            httpServletResponse.setContentLength(byArray.length);
            Matcher matcher = this.shtmlRegEx.matcher(responseIncludeWrapper.getContentType());
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                httpServletResponse.setContentType("text/html" + (string2 != null ? string2 : ""));
            }
        }
        object = null;
        try {
            object = httpServletResponse.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (object == null) {
            httpServletResponse.getWriter().write(new String(byArray));
        } else {
            object.write(byArray);
        }
    }
}

