/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.LambdaExpression;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.util.ExceptionUtils;
import org.apache.el.util.MessageFactory;

public class ELSupport {
    private static final Long ZERO = 0L;
    protected static final boolean COERCE_TO_ZERO;

    public static int compare(ELContext eLContext, Object object, Object object2) throws ELException {
        if (object == object2 || ELSupport.equals(eLContext, object, object2)) {
            return 0;
        }
        if (ELSupport.isBigDecimalOp(object, object2)) {
            BigDecimal bigDecimal = (BigDecimal)ELSupport.coerceToNumber(eLContext, object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)ELSupport.coerceToNumber(eLContext, object2, BigDecimal.class);
            return bigDecimal.compareTo(bigDecimal2);
        }
        if (ELSupport.isDoubleOp(object, object2)) {
            Double d = (Double)ELSupport.coerceToNumber(eLContext, object, Double.class);
            Double d2 = (Double)ELSupport.coerceToNumber(eLContext, object2, Double.class);
            return d.compareTo(d2);
        }
        if (ELSupport.isBigIntegerOp(object, object2)) {
            BigInteger bigInteger = (BigInteger)ELSupport.coerceToNumber(eLContext, object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)ELSupport.coerceToNumber(eLContext, object2, BigInteger.class);
            return bigInteger.compareTo(bigInteger2);
        }
        if (ELSupport.isLongOp(object, object2)) {
            Long l = (Long)ELSupport.coerceToNumber(eLContext, object, Long.class);
            Long l2 = (Long)ELSupport.coerceToNumber(eLContext, object2, Long.class);
            return l.compareTo(l2);
        }
        if (object instanceof String || object2 instanceof String) {
            return ELSupport.coerceToString(eLContext, object).compareTo(ELSupport.coerceToString(eLContext, object2));
        }
        if (object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            return object2 != null ? comparable.compareTo(object2) : 1;
        }
        if (object2 instanceof Comparable) {
            Comparable comparable = (Comparable)object2;
            return object != null ? -comparable.compareTo(object) : -1;
        }
        throw new ELException(MessageFactory.get("error.compare", object, object2));
    }

    public static boolean equals(ELContext eLContext, Object object, Object object2) throws ELException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (ELSupport.isBigDecimalOp(object, object2)) {
            BigDecimal bigDecimal = (BigDecimal)ELSupport.coerceToNumber(eLContext, object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)ELSupport.coerceToNumber(eLContext, object2, BigDecimal.class);
            return bigDecimal.equals(bigDecimal2);
        }
        if (ELSupport.isDoubleOp(object, object2)) {
            Double d = (Double)ELSupport.coerceToNumber(eLContext, object, Double.class);
            Double d2 = (Double)ELSupport.coerceToNumber(eLContext, object2, Double.class);
            return d.equals(d2);
        }
        if (ELSupport.isBigIntegerOp(object, object2)) {
            BigInteger bigInteger = (BigInteger)ELSupport.coerceToNumber(eLContext, object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)ELSupport.coerceToNumber(eLContext, object2, BigInteger.class);
            return bigInteger.equals(bigInteger2);
        }
        if (ELSupport.isLongOp(object, object2)) {
            Long l = (Long)ELSupport.coerceToNumber(eLContext, object, Long.class);
            Long l2 = (Long)ELSupport.coerceToNumber(eLContext, object2, Long.class);
            return l.equals(l2);
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return ELSupport.coerceToBoolean(eLContext, object, false).equals(ELSupport.coerceToBoolean(eLContext, object2, false));
        }
        if (object.getClass().isEnum()) {
            return object.equals(ELSupport.coerceToEnum(eLContext, object2, object.getClass()));
        }
        if (object2.getClass().isEnum()) {
            return object2.equals(ELSupport.coerceToEnum(eLContext, object, object2.getClass()));
        }
        if (object instanceof String || object2 instanceof String) {
            int n = ELSupport.coerceToString(eLContext, object).compareTo(ELSupport.coerceToString(eLContext, object2));
            return n == 0;
        }
        return object.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enum<?> coerceToEnum(ELContext eLContext, Object object, Class clazz) {
        Object t;
        if (eLContext != null) {
            boolean bl = eLContext.isPropertyResolved();
            try {
                Object object2 = eLContext.getELResolver().convertToType(eLContext, object, clazz);
                if (eLContext.isPropertyResolved()) {
                    Enum enum_ = (Enum)object2;
                    return enum_;
                }
            }
            finally {
                eLContext.setPropertyResolved(bl);
            }
        }
        if (object == null || "".equals(object)) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (Enum)object;
        }
        if (!(object instanceof String)) {
            throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
        }
        try {
            t = Enum.valueOf(clazz, (String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean coerceToBoolean(ELContext eLContext, Object object, boolean bl) throws ELException {
        if (eLContext != null) {
            boolean bl2 = eLContext.isPropertyResolved();
            try {
                Boolean bl3 = (Boolean)eLContext.getELResolver().convertToType(eLContext, object, Boolean.class);
                if (eLContext.isPropertyResolved()) {
                    Boolean bl4 = bl3;
                    return bl4;
                }
            }
            finally {
                eLContext.setPropertyResolved(bl2);
            }
        }
        if (!COERCE_TO_ZERO && !bl && object == null) {
            return null;
        }
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), Boolean.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Character coerceToCharacter(ELContext eLContext, Object object) throws ELException {
        if (eLContext != null) {
            boolean bl = eLContext.isPropertyResolved();
            try {
                Character c = (Character)eLContext.getELResolver().convertToType(eLContext, object, Character.class);
                if (eLContext.isPropertyResolved()) {
                    Character c2 = c;
                    return c2;
                }
            }
            finally {
                eLContext.setPropertyResolved(bl);
            }
        }
        if (object == null || "".equals(object)) {
            return Character.valueOf('\u0000');
        }
        if (object instanceof String) {
            return Character.valueOf(((String)object).charAt(0));
        }
        if (ELArithmetic.isNumber(object)) {
            return Character.valueOf((char)((Number)object).shortValue());
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Character) {
            return (Character)object;
        }
        throw new ELException(MessageFactory.get("error.convert", object, clazz, Character.class));
    }

    protected static Number coerceToNumber(Number number, Class<?> clazz) throws ELException {
        if (Long.TYPE == clazz || Long.class.equals(clazz)) {
            return number.longValue();
        }
        if (Double.TYPE == clazz || Double.class.equals(clazz)) {
            return number.doubleValue();
        }
        if (Integer.TYPE == clazz || Integer.class.equals(clazz)) {
            return number.intValue();
        }
        if (BigInteger.class.equals(clazz)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            if (number instanceof BigInteger) {
                return number;
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (BigDecimal.class.equals(clazz)) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (Byte.TYPE == clazz || Byte.class.equals(clazz)) {
            return number.byteValue();
        }
        if (Short.TYPE == clazz || Short.class.equals(clazz)) {
            return number.shortValue();
        }
        if (Float.TYPE == clazz || Float.class.equals(clazz)) {
            return Float.valueOf(number.floatValue());
        }
        if (Number.class.equals(clazz)) {
            return number;
        }
        throw new ELException(MessageFactory.get("error.convert", number, number.getClass(), clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number coerceToNumber(ELContext eLContext, Object object, Class<?> clazz) throws ELException {
        if (eLContext != null) {
            boolean bl = eLContext.isPropertyResolved();
            try {
                Object object2 = eLContext.getELResolver().convertToType(eLContext, object, clazz);
                if (eLContext.isPropertyResolved()) {
                    Number number = (Number)object2;
                    return number;
                }
            }
            finally {
                eLContext.setPropertyResolved(bl);
            }
        }
        if (!COERCE_TO_ZERO && object == null && !clazz.isPrimitive()) {
            return null;
        }
        if (object == null || "".equals(object)) {
            return ELSupport.coerceToNumber(ZERO, clazz);
        }
        if (object instanceof String) {
            return ELSupport.coerceToNumber((String)object, clazz);
        }
        if (ELArithmetic.isNumber(object)) {
            return ELSupport.coerceToNumber((Number)object, clazz);
        }
        if (object instanceof Character) {
            return ELSupport.coerceToNumber((short)((Character)object).charValue(), clazz);
        }
        throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
    }

    protected static Number coerceToNumber(String string, Class<?> clazz) throws ELException {
        if (Long.TYPE == clazz || Long.class.equals(clazz)) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (Integer.TYPE == clazz || Integer.class.equals(clazz)) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (Double.TYPE == clazz || Double.class.equals(clazz)) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (BigInteger.class.equals(clazz)) {
            try {
                return new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (BigDecimal.class.equals(clazz)) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (Byte.TYPE == clazz || Byte.class.equals(clazz)) {
            try {
                return Byte.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (Short.TYPE == clazz || Short.class.equals(clazz)) {
            try {
                return Short.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        if (Float.TYPE == clazz || Float.class.equals(clazz)) {
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
            }
        }
        throw new ELException(MessageFactory.get("error.convert", string, String.class, clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String coerceToString(ELContext eLContext, Object object) {
        if (eLContext != null) {
            boolean bl = eLContext.isPropertyResolved();
            try {
                String string = (String)eLContext.getELResolver().convertToType(eLContext, object, String.class);
                if (eLContext.isPropertyResolved()) {
                    String string2 = string;
                    return string2;
                }
            }
            finally {
                eLContext.setPropertyResolved(bl);
            }
        }
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        try {
            return object.toString();
        }
        catch (ELException eLException) {
            throw eLException;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            throw new ELException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T coerceToType(ELContext eLContext, Object object, Class<T> clazz) throws ELException {
        Object object2;
        if (eLContext != null) {
            boolean bl = eLContext.isPropertyResolved();
            try {
                object2 = eLContext.getELResolver().convertToType(eLContext, object, clazz);
                if (eLContext.isPropertyResolved()) {
                    Object object3 = object2;
                    return (T)object3;
                }
            }
            finally {
                eLContext.setPropertyResolved(bl);
            }
        }
        if (clazz == null || Object.class.equals(clazz) || object != null && clazz.isAssignableFrom(object.getClass())) {
            Object object4 = object;
            return (T)object4;
        }
        if (!(COERCE_TO_ZERO || object != null || clazz.isPrimitive() || String.class.isAssignableFrom(clazz))) {
            return null;
        }
        if (String.class.equals(clazz)) {
            String string = ELSupport.coerceToString(eLContext, object);
            return (T)string;
        }
        if (ELArithmetic.isNumberType(clazz)) {
            Number number = ELSupport.coerceToNumber(eLContext, object, clazz);
            return (T)number;
        }
        if (Character.class.equals(clazz) || Character.TYPE == clazz) {
            Character c = ELSupport.coerceToCharacter(eLContext, object);
            return (T)c;
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE == clazz) {
            Boolean bl = ELSupport.coerceToBoolean(eLContext, object, Boolean.TYPE == clazz);
            return (T)bl;
        }
        if (clazz.isEnum()) {
            Enum<?> enum_ = ELSupport.coerceToEnum(eLContext, object, clazz);
            return (T)enum_;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            object2 = PropertyEditorManager.findEditor(clazz);
            if (object2 == null) {
                if (string.isEmpty()) {
                    return null;
                }
                throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
            }
            try {
                object2.setAsText(string);
                Object object5 = object2.getValue();
                return (T)object5;
            }
            catch (RuntimeException runtimeException) {
                if (string.isEmpty()) {
                    return null;
                }
                throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), clazz), (Throwable)runtimeException);
            }
        }
        if (object instanceof Set && clazz == Map.class && ((Set)object).isEmpty()) {
            Map map = Collections.EMPTY_MAP;
            return (T)map;
        }
        if (clazz.isArray() && object.getClass().isArray()) {
            Object object6 = ELSupport.coerceToArray(eLContext, object, clazz);
            return (T)object6;
        }
        if (object instanceof LambdaExpression && ELSupport.isFunctionalInterface(clazz)) {
            return ELSupport.coerceToFunctionalInterface(eLContext, (LambdaExpression)object, clazz);
        }
        throw new ELException(MessageFactory.get("error.convert", object, object.getClass(), clazz));
    }

    private static Object coerceToArray(ELContext eLContext, Object object, Class<?> clazz) {
        int n = Array.getLength(object);
        Class<?> clazz2 = clazz.getComponentType();
        Object object2 = Array.newInstance(clazz2, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object2, i, ELSupport.coerceToType(eLContext, Array.get(object, i), clazz2));
        }
        return object2;
    }

    private static <T> T coerceToFunctionalInterface(ELContext eLContext, LambdaExpression lambdaExpression, Class<T> clazz) {
        Supplier<Object> supplier = () -> {
            Object object2 = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (object, method, objectArray) -> {
                if (!Modifier.isAbstract(method.getModifiers())) {
                    throw new ELException(MessageFactory.get("elSupport.coerce.nonAbstract", clazz, method));
                }
                if (eLContext == null) {
                    return lambdaExpression.invoke(objectArray);
                }
                return lambdaExpression.invoke(eLContext, objectArray);
            });
            return object2;
        };
        if (System.getSecurityManager() != null) {
            return (T)AccessController.doPrivileged(supplier::get);
        }
        return (T)supplier.get();
    }

    public static boolean isBigDecimalOp(Object object, Object object2) {
        return object instanceof BigDecimal || object2 instanceof BigDecimal;
    }

    public static boolean isBigIntegerOp(Object object, Object object2) {
        return object instanceof BigInteger || object2 instanceof BigInteger;
    }

    public static boolean isDoubleOp(Object object, Object object2) {
        return object instanceof Double || object2 instanceof Double || object instanceof Float || object2 instanceof Float;
    }

    public static boolean isLongOp(Object object, Object object2) {
        return object instanceof Long || object2 instanceof Long || object instanceof Integer || object2 instanceof Integer || object instanceof Character || object2 instanceof Character || object instanceof Short || object2 instanceof Short || object instanceof Byte || object2 instanceof Byte;
    }

    public static boolean isStringFloat(String string) {
        int n = string.length();
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                switch (string.charAt(i)) {
                    case 'E': {
                        return true;
                    }
                    case 'e': {
                        return true;
                    }
                    case '.': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static boolean isFunctionalInterface(Class<?> clazz) {
        Method[] methodArray;
        if (!clazz.isInterface()) {
            return false;
        }
        boolean bl = false;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) || ELSupport.overridesObjectMethod(method)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean overridesObjectMethod(Method method) {
        if ("equals".equals(method.getName())) {
            if (method.getReturnType().equals(Boolean.TYPE) && method.getParameterCount() == 1) {
                return method.getParameterTypes()[0].equals(Object.class);
            }
        } else if ("hashCode".equals(method.getName()) ? method.getReturnType().equals(Integer.TYPE) : "toString".equals(method.getName()) && method.getReturnType().equals(String.class)) {
            return method.getParameterCount() == 0;
        }
        return false;
    }

    private ELSupport() {
    }

    static {
        String string = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "false")) : System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "false");
        COERCE_TO_ZERO = Boolean.parseBoolean(string);
    }
}

