/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import org.apache.catalina.ant.jmx.JMXAccessorConditionBase;
import org.apache.tools.ant.BuildException;

public class JMXAccessorCondition
extends JMXAccessorConditionBase {
    private String operation = "==";
    private String type = "long";
    private String unlessCondition;
    private String ifCondition;

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String string) {
        this.operation = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getIf() {
        return this.ifCondition;
    }

    public void setIf(String string) {
        this.ifCondition = string;
    }

    public String getUnless() {
        return this.unlessCondition;
    }

    public void setUnless(String string) {
        this.unlessCondition = string;
    }

    protected boolean testIfCondition() {
        if (this.ifCondition == null || this.ifCondition.isEmpty()) {
            return true;
        }
        return this.getProject().getProperty(this.ifCondition) != null;
    }

    protected boolean testUnlessCondition() {
        if (this.unlessCondition == null || this.unlessCondition.isEmpty()) {
            return true;
        }
        return this.getProject().getProperty(this.unlessCondition) == null;
    }

    public boolean eval() {
        String string = this.getValue();
        if (this.operation == null) {
            throw new BuildException("operation attribute is not set");
        }
        if (string == null) {
            throw new BuildException("value attribute is not set");
        }
        if (this.getName() == null || this.getAttribute() == null) {
            throw new BuildException("Must specify an MBean name and attribute for condition");
        }
        if (this.testIfCondition() && this.testUnlessCondition()) {
            String string2 = this.accessJMXValue();
            if (string2 != null) {
                String string3 = this.getOperation();
                if ("==".equals(string3)) {
                    return string2.equals(string);
                }
                if ("!=".equals(string3)) {
                    return !string2.equals(string);
                }
                if ("long".equals(this.type)) {
                    long l = Long.parseLong(string2);
                    long l2 = Long.parseLong(string);
                    if (">".equals(string3)) {
                        return l > l2;
                    }
                    if (">=".equals(string3)) {
                        return l >= l2;
                    }
                    if ("<".equals(string3)) {
                        return l < l2;
                    }
                    if ("<=".equals(string3)) {
                        return l <= l2;
                    }
                } else if ("double".equals(this.type)) {
                    double d = Double.parseDouble(string2);
                    double d2 = Double.parseDouble(string);
                    if (">".equals(string3)) {
                        return d > d2;
                    }
                    if (">=".equals(string3)) {
                        return d >= d2;
                    }
                    if ("<".equals(string3)) {
                        return d < d2;
                    }
                    if ("<=".equals(string3)) {
                        return d <= d2;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

