/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import org.apache.coyote.http2.HpackException;
import org.apache.tomcat.util.res.StringManager;

final class Hpack {
    private static final StringManager sm = StringManager.getManager(Hpack.class);
    private static final byte LOWER_DIFF = 32;
    static final int DEFAULT_TABLE_SIZE = 4096;
    private static final int MAX_INTEGER_OCTETS = 5;
    private static final int[] PREFIX_TABLE = new int[32];
    static final HeaderField[] STATIC_TABLE;
    static final int STATIC_TABLE_LENGTH;

    static int decodeInteger(ByteBuffer byteBuffer, int n) throws HpackException {
        byte by;
        if (byteBuffer.remaining() == 0) {
            return -1;
        }
        int n2 = 1;
        int n3 = byteBuffer.position();
        int n4 = PREFIX_TABLE[n];
        long l = n4 & byteBuffer.get();
        if (l < (long)PREFIX_TABLE[n]) {
            return (int)l;
        }
        int n5 = 0;
        do {
            if (n2++ > 5) {
                throw new HpackException(sm.getString("hpack.integerEncodedOverTooManyOctets", new Object[]{5}));
            }
            if (byteBuffer.remaining() == 0) {
                byteBuffer.position(n3);
                return -1;
            }
            by = byteBuffer.get();
            if ((l += (long)(by & 0x7F) * ((long)PREFIX_TABLE[n5] + 1L)) > Integer.MAX_VALUE) {
                throw new HpackException(sm.getString("hpack.integerEncodedTooBig"));
            }
            n5 += 7;
        } while ((by & 0x80) == 128);
        return (int)l;
    }

    static void encodeInteger(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = PREFIX_TABLE[n2];
        int n4 = byteBuffer.position() - 1;
        if (n < n3) {
            byteBuffer.put(n4, (byte)(byteBuffer.get(n4) | n));
        } else {
            byteBuffer.put(n4, (byte)(byteBuffer.get(n4) | n3));
            n -= n3;
            while (n >= 128) {
                byteBuffer.put((byte)(n % 128 + 128));
                n /= 128;
            }
            byteBuffer.put((byte)n);
        }
    }

    static char toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private Hpack() {
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int n = 0;
            for (int j = 0; j < i; ++j) {
                n <<= 1;
                n |= 1;
            }
            Hpack.PREFIX_TABLE[i] = n;
        }
        HeaderField[] headerFieldArray = new HeaderField[62];
        headerFieldArray[1] = new HeaderField(":authority", null);
        headerFieldArray[2] = new HeaderField(":method", "GET");
        headerFieldArray[3] = new HeaderField(":method", "POST");
        headerFieldArray[4] = new HeaderField(":path", "/");
        headerFieldArray[5] = new HeaderField(":path", "/index.html");
        headerFieldArray[6] = new HeaderField(":scheme", "http");
        headerFieldArray[7] = new HeaderField(":scheme", "https");
        headerFieldArray[8] = new HeaderField(":status", "200");
        headerFieldArray[9] = new HeaderField(":status", "204");
        headerFieldArray[10] = new HeaderField(":status", "206");
        headerFieldArray[11] = new HeaderField(":status", "304");
        headerFieldArray[12] = new HeaderField(":status", "400");
        headerFieldArray[13] = new HeaderField(":status", "404");
        headerFieldArray[14] = new HeaderField(":status", "500");
        headerFieldArray[15] = new HeaderField("accept-charset", null);
        headerFieldArray[16] = new HeaderField("accept-encoding", "gzip, deflate");
        headerFieldArray[17] = new HeaderField("accept-language", null);
        headerFieldArray[18] = new HeaderField("accept-ranges", null);
        headerFieldArray[19] = new HeaderField("accept", null);
        headerFieldArray[20] = new HeaderField("access-control-allow-origin", null);
        headerFieldArray[21] = new HeaderField("age", null);
        headerFieldArray[22] = new HeaderField("allow", null);
        headerFieldArray[23] = new HeaderField("authorization", null);
        headerFieldArray[24] = new HeaderField("cache-control", null);
        headerFieldArray[25] = new HeaderField("content-disposition", null);
        headerFieldArray[26] = new HeaderField("content-encoding", null);
        headerFieldArray[27] = new HeaderField("content-language", null);
        headerFieldArray[28] = new HeaderField("content-length", null);
        headerFieldArray[29] = new HeaderField("content-location", null);
        headerFieldArray[30] = new HeaderField("content-range", null);
        headerFieldArray[31] = new HeaderField("content-type", null);
        headerFieldArray[32] = new HeaderField("cookie", null);
        headerFieldArray[33] = new HeaderField("date", null);
        headerFieldArray[34] = new HeaderField("etag", null);
        headerFieldArray[35] = new HeaderField("expect", null);
        headerFieldArray[36] = new HeaderField("expires", null);
        headerFieldArray[37] = new HeaderField("from", null);
        headerFieldArray[38] = new HeaderField("host", null);
        headerFieldArray[39] = new HeaderField("if-match", null);
        headerFieldArray[40] = new HeaderField("if-modified-since", null);
        headerFieldArray[41] = new HeaderField("if-none-match", null);
        headerFieldArray[42] = new HeaderField("if-range", null);
        headerFieldArray[43] = new HeaderField("if-unmodified-since", null);
        headerFieldArray[44] = new HeaderField("last-modified", null);
        headerFieldArray[45] = new HeaderField("link", null);
        headerFieldArray[46] = new HeaderField("location", null);
        headerFieldArray[47] = new HeaderField("max-forwards", null);
        headerFieldArray[48] = new HeaderField("proxy-authenticate", null);
        headerFieldArray[49] = new HeaderField("proxy-authorization", null);
        headerFieldArray[50] = new HeaderField("range", null);
        headerFieldArray[51] = new HeaderField("referer", null);
        headerFieldArray[52] = new HeaderField("refresh", null);
        headerFieldArray[53] = new HeaderField("retry-after", null);
        headerFieldArray[54] = new HeaderField("server", null);
        headerFieldArray[55] = new HeaderField("set-cookie", null);
        headerFieldArray[56] = new HeaderField("strict-transport-security", null);
        headerFieldArray[57] = new HeaderField("transfer-encoding", null);
        headerFieldArray[58] = new HeaderField("user-agent", null);
        headerFieldArray[59] = new HeaderField("vary", null);
        headerFieldArray[60] = new HeaderField("via", null);
        headerFieldArray[61] = new HeaderField("www-authenticate", null);
        STATIC_TABLE = headerFieldArray;
        STATIC_TABLE_LENGTH = STATIC_TABLE.length - 1;
    }

    static class HeaderField {
        final String name;
        final String value;
        final int size;

        HeaderField(String string, String string2) {
            this.name = string;
            this.value = string2;
            this.size = string2 != null ? 32 + string.length() + string2.length() : -1;
        }
    }
}

