/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search.importer;

import java.util.Set;
import org.protege.editor.owl.model.search.OntologyBasedSearchMDImporter;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchMetadata;
import org.protege.editor.owl.model.search.SearchMetadataDB;
import org.protege.editor.owl.model.search.SearchMetadataImportContext;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntologyAnnotationSearchMetadataImporter
extends OntologyBasedSearchMDImporter {
    @Override
    public boolean isImporterFor(Set<SearchCategory> categories) {
        return categories.contains((Object)SearchCategory.ANNOTATION_VALUE);
    }

    @Override
    public void generateSearchMetadata(OWLOntology ontology, SearchMetadataImportContext context, SearchMetadataDB db) {
        for (OWLAnnotation annotation : ontology.getAnnotations()) {
            this.generateSearchMetadataForAnnotation(annotation, ontology, context, db);
        }
    }

    private void generateSearchMetadataForAnnotation(final OWLAnnotation annotation, OWLOntology ontology, final SearchMetadataImportContext context, SearchMetadataDB db) {
        String groupDescription = context.getRendering((OWLObject)annotation.getProperty());
        StyledString rendering = context.getStyledStringRendering((OWLObject)annotation);
        SearchMetadata md = new SearchMetadata(SearchCategory.ANNOTATION_VALUE, groupDescription, (OWLObject)ontology, context.getRendering((OWLObject)ontology), rendering.getString()){

            @Override
            public StyledString getStyledSearchSearchString() {
                return context.getStyledStringRendering((OWLObject)annotation);
            }
        };
        db.addResult(md);
        for (OWLAnnotation anno : annotation.getAnnotations()) {
            this.generateSearchMetadataForAnnotation(anno, ontology, context, db);
        }
    }
}

