/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchResult;
import org.protege.editor.owl.model.search.SearchResultMatch;

public class SearchResultComparator
implements Comparator<SearchResult> {
    public SearchResultComparator(OWLEditorKit editorKit) {
    }

    @Override
    public int compare(SearchResult result1, SearchResult result2) {
        int catDiff = result1.getCategory().ordinal() - result2.getCategory().ordinal();
        if (catDiff != 0) {
            return catDiff;
        }
        int typeDiff = result1.getGroupDescription().compareTo(result2.getGroupDescription());
        if (typeDiff != 0) {
            return typeDiff;
        }
        if (this.isStartOfRenderingMatch(result1)) {
            if (this.isStartOfRenderingMatch(result2)) {
                return this.compareOWLEntities(result1, result2);
            }
            return -1;
        }
        if (this.isStartOfRenderingMatch(result2)) {
            return 1;
        }
        return this.compareOWLEntities(result1, result2);
    }

    private int compareOWLEntities(SearchResult result1, SearchResult result2) {
        int diff = result1.compareTo(result2);
        if (diff != 0) {
            return diff;
        }
        String subjectRendering1 = result1.getSubjectRendering();
        String subjectRendering2 = result2.getSubjectRendering();
        String strippedRendering1 = subjectRendering1.startsWith("'") ? subjectRendering1.substring(1) : subjectRendering1;
        String strippedRendering2 = subjectRendering2.startsWith("'") ? subjectRendering2.substring(1) : subjectRendering2;
        return strippedRendering1.compareToIgnoreCase(strippedRendering2);
    }

    private boolean isStartOfRenderingMatch(SearchResult searchResult) {
        if (searchResult.getCategory() != SearchCategory.DISPLAY_NAME) {
            return false;
        }
        String rendering = searchResult.getSearchString();
        ImmutableList<SearchResultMatch> matches = searchResult.getMatches();
        if (matches.isEmpty()) {
            return false;
        }
        SearchResultMatch firstMatch = (SearchResultMatch)matches.get(0);
        if (rendering.startsWith("'")) {
            return firstMatch.getStart() == 1;
        }
        return firstMatch.getStart() == 0;
    }
}

