<?php

namespace Faker\Provider\is_IS;

use Faker\Provider\DateTime;

class Person extends \Faker\Provider\Person
{
    /**
     * @var array Icelandic name formats for men.
     */
    protected static $maleNameFormats = [
        '{{firstNameMale}} {{lastNameMale}}',
        '{{firstNameMale}} {{lastNameMale}}',
        '{{firstNameMale}} {{middleName}} {{lastNameMale}}',
        '{{firstNameMale}} {{middleName}} {{lastNameMale}}',
    ];

    /**
     * @var array Icelandic name formats for women.
     */
    protected static $femaleNameFormats = [
        '{{firstNameFemale}} {{lastNameFemale}}',
        '{{firstNameFemale}} {{lastNameFemale}}',
        '{{firstNameFemale}} {{middleName}} {{lastNameFemale}}',
        '{{firstNameFemale}} {{middleName}} {{lastNameFemale}}',
    ];

    /**
     * @var array<string> Icelandic names for women.
     */
    protected static $firstNameFemale = ['Aagot', 'Abela', 'Abigael', 'Ada', 'Adda', 'Addý', 'Adela', 'Adelía', 'Adríana', 'Aðalbjörg', 'Aðalbjört', 'Aðalborg', 'Aðaldís', 'Aðalfríður', 'Aðalheiður', 'Aðalrós', 'Aðalsteina', 'Aðalsteinunn', 'Aðalveig', 'Agata', 'Agatha', 'Agða', 'Agla', 'Agnea', 'Agnes', 'Agneta', 'Alanta', 'Alba', 'Alberta', 'Albína', 'Alda', 'Aldís', 'Aldný', 'Aleta', 'Aletta', 'Alexa', 'Alexandra', 'Alexandría', 'Alexis', 'Alexía', 'Alfa', 'Alfífa', 'Alice', 'Alida', 'Alída', 'Alína', 'Alís', 'Alísa', 'Alla', 'Allý', 'Alma', 'Alrún', 'Alva', 'Alvilda', 'Amadea', 'Amal', 'Amalía', 'Amanda', 'Amelía', 'Amilía', 'Amíra', 'Amy', 'Amý', 'Analía', 'Anastasía', 'Andra', 'Andrá', 'Andrea', 'Anetta', 'Angela', 'Angelíka', 'Anika', 'Anita', 'Aníka', 'Anína', 'Aníta', 'Anja', 'Ann', 'Anna', 'Annabella', 'Annalísa', 'Anne', 'Annelí', 'Annetta', 'Anney', 'Annika', 'Annía', 'Anný', 'Antonía', 'Apríl', 'Ardís', 'Arey', 'Arinbjörg', 'Aris', 'Arisa', 'Aría', 'Aríanna', 'Aríella', 'Arín', 'Arína', 'Arís', 'Armenía', 'Arna', 'Arnbjörg', 'Arnborg', 'Arndís', 'Arney', 'Arnfinna', 'Arnfríður', 'Arngerður', 'Arngunnur', 'Arnheiður', 'Arnhildur', 'Arnika', 'Arnkatla', 'Arnlaug', 'Arnleif', 'Arnlín', 'Arnljót', 'Arnóra', 'Arnrós', 'Arnrún', 'Arnþóra', 'Arnþrúður', 'Asírí', 'Askja', 'Assa', 'Astrid', 'Atalía', 'Atena', 'Athena', 'Atla', 'Atlanta', 'Auðbjörg', 'Auðbjört', 'Auðdís', 'Auðlín', 'Auðna', 'Auðný', 'Auðrún', 'Auður', 'Aurora', 'Axelía', 'Axelma', 'Aþena', 'Ágústa', 'Ágústína', 'Álfdís', 'Álfey', 'Álfgerður', 'Álfheiður', 'Álfhildur', 'Álfrós', 'Álfrún', 'Álfsól', 'Árbjörg', 'Árbjört', 'Árdís', 'Árelía', 'Árlaug', 'Ármey', 'Árna', 'Árndís', 'Árney', 'Árnheiður', 'Árnína', 'Árný', 'Áróra', 'Ársól', 'Ársæl', 'Árún', 'Árveig', 'Árvök', 'Árþóra', 'Ása', 'Ásbjörg', 'Ásborg', 'Ásdís', 'Ásfríður', 'Ásgerður', 'Áshildur', 'Áskatla', 'Ásla', 'Áslaug', 'Ásleif', 'Ásný', 'Ásrós', 'Ásrún', 'Ást', 'Ásta', 'Ástbjörg', 'Ástbjört', 'Ástdís', 'Ástfríður', 'Ástgerður', 'Ástheiður', 'Ásthildur', 'Ástríður', 'Ástrós', 'Ástrún', 'Ástveig', 'Ástþóra', 'Ástþrúður', 'Ásvör', 'Baldey', 'Baldrún', 'Baldvina', 'Barbara', 'Barbára', 'Bassí', 'Bára', 'Bebba', 'Begga', 'Belinda', 'Bella', 'Benedikta', 'Bengta', 'Benidikta', 'Benía', 'Beníta', 'Benna', 'Benney', 'Benný', 'Benta', 'Bentey', 'Bentína', 'Bera', 'Bergdís', 'Bergey', 'Bergfríður', 'Bergheiður', 'Berghildur', 'Berglaug', 'Berglind', 'Berglín', 'Bergljót', 'Bergmannía', 'Bergný', 'Bergrán', 'Bergrín', 'Bergrós', 'Bergrún', 'Bergþóra', 'Berit', 'Bernódía', 'Berta', 'Bertha', 'Bessí', 'Bestla', 'Beta', 'Betanía', 'Betsý', 'Bettý', 'Bil', 'Birgit', 'Birgitta', 'Birna', 'Birta', 'Birtna', 'Bíbí', 'Bína', 'Bjargdís', 'Bjargey', 'Bjargheiður', 'Bjarghildur', 'Bjarglind', 'Bjarkey', 'Bjarklind', 'Bjarma', 'Bjarndís', 'Bjarney', 'Bjarnfríður', 'Bjarngerður', 'Bjarnheiður', 'Bjarnhildur', 'Bjarnlaug', 'Bjarnrún', 'Bjarnveig', 'Bjarný', 'Bjarnþóra', 'Bjarnþrúður', 'Bjartey', 'Bjartmey', 'Björg', 'Björgey', 'Björgheiður', 'Björghildur', 'Björk', 'Björney', 'Björnfríður', 'Björt', 'Bláey', 'Blíða', 'Blín', 'Blómey', 'Blædís', 'Blær', 'Bobba', 'Boga', 'Bogdís', 'Bogey', 'Bogga', 'Boghildur', 'Borg', 'Borgdís', 'Borghildur', 'Borgný', 'Borgrún', 'Borgþóra', 'Botnía', 'Bóel', 'Bót', 'Bóthildur', 'Braga', 'Braghildur', 'Branddís', 'Brá', 'Brák', 'Brigitta', 'Brimdís', 'Brimhildur', 'Brimrún', 'Brit', 'Britt', 'Britta', 'Bríana', 'Bríanna', 'Bríet', 'Bryndís', 'Brynfríður', 'Bryngerður', 'Brynheiður', 'Brynhildur', 'Brynja', 'Brynný', 'Burkney', 'Bylgja', 'Camilla', 'Carla', 'Carmen', 'Cecilia', 'Cecilía', 'Charlotta', 'Charlotte', 'Christina', 'Christine', 'Clara', 'Daðey', 'Daðína', 'Dagbjörg', 'Dagbjört', 'Dagfríður', 'Daggrós', 'Dagheiður', 'Dagmar', 'Dagmey', 'Dagný', 'Dagrún', 'Daldís', 'Daley', 'Dalía', 'Dalla', 'Dallilja', 'Dalrós', 'Dana', 'Daney', 'Danfríður', 'Danheiður', 'Danhildur', 'Danía', 'Daníela', 'Daníella', 'Dara', 'Debora', 'Debóra', 'Dendý', 'Didda', 'Dilja', 'Diljá', 'Dimmblá', 'Dimmey', 'Día', 'Díana', 'Díanna', 'Díma', 'Dís', 'Dísa', 'Dísella', 'Donna', 'Doris', 'Dorothea', 'Dóa', 'Dómhildur', 'Dóra', 'Dórey', 'Dóris', 'Dórothea', 'Dórótea', 'Dóróthea', 'Drauma', 'Draumey', 'Drífa', 'Droplaug', 'Drótt', 'Dröfn', 'Dúa', 'Dúfa', 'Dúna', 'Dýrborg', 'Dýrfinna', 'Dýrleif', 'Dýrley', 'Dýrunn', 'Dæja', 'Dögg', 'Dögun', 'Ebba', 'Ebonney', 'Edda', 'Edel', 'Edil', 'Edit', 'Edith', 'Eðna', 'Efemía', 'Egedía', 'Eggrún', 'Egla', 'Eiðný', 'Eiðunn', 'Eik', 'Einbjörg', 'Eindís', 'Einey', 'Einfríður', 'Einhildur', 'Einína', 'Einrún', 'Eir', 'Eirdís', 'Eirfinna', 'Eiríka', 'Eirný', 'Eirún', 'Elba', 'Eldbjörg', 'Eldey', 'Eldlilja', 'Eldrún', 'Eleina', 'Elektra', 'Elena', 'Elenborg', 'Elfa', 'Elfur', 'Elina', 'Elinborg', 'Elisabeth', 'Elía', 'Elíana', 'Elín', 'Elína', 'Elíná', 'Elínbet', 'Elínbjörg', 'Elínbjört', 'Elínborg', 'Elíndís', 'Elíngunnur', 'Elínheiður', 'Elínrós', 'Elírós', 'Elísa', 'Elísabet', 'Elísabeth', 'Elka', 'Ella', 'Ellen', 'Elley', 'Ellisif', 'Ellín', 'Elly', 'Ellý', 'Elma', 'Elna', 'Elsa', 'Elsabet', 'Elsie', 'Elsí', 'Elsý', 'Elva', 'Elvi', 'Elvíra', 'Elvý', 'Embla', 'Emelía', 'Emelíana', 'Emelína', 'Emeralda', 'Emilía', 'Emilíana', 'Emilíanna', 'Emilý', 'Emma', 'Emmý', 'Emý', 'Enea', 'Eneka', 'Engilbjört', 'Engilráð', 'Engilrós', 'Engla', 'Enika', 'Enja', 'Enóla', 'Eres', 'Erika', 'Erin', 'Erla', 'Erlen', 'Erlín', 'Erna', 'Esja', 'Esmeralda', 'Ester', 'Esther', 'Estiva', 'Ethel', 'Etna', 'Eufemía', 'Eva', 'Evelyn', 'Evey', 'Evfemía', 'Evgenía', 'Evíta', 'Evlalía', 'Ey', 'Eybjörg', 'Eybjört', 'Eydís', 'Eyfríður', 'Eygerður', 'Eygló', 'Eyhildur', 'Eyja', 'Eyjalín', 'Eyleif', 'Eylín', 'Eyrós', 'Eyrún', 'Eyveig', 'Eyvör', 'Eyþóra', 'Eyþrúður', 'Fanndís', 'Fanney', 'Fannlaug', 'Fanny', 'Fanný', 'Febrún', 'Fema', 'Filipía', 'Filippa', 'Filippía', 'Finna', 'Finnbjörg', 'Finnbjörk', 'Finnboga', 'Finnborg', 'Finndís', 'Finney', 'Finnfríður', 'Finnlaug', 'Finnrós', 'Fía', 'Fídes', 'Fífa', 'Fjalldís', 'Fjóla', 'Flóra', 'Folda', 'Fransiska', 'Franziska', 'Frán', 'Fregn', 'Freydís', 'Freygerður', 'Freyja', 'Freylaug', 'Freyleif', 'Friðbjörg', 'Friðbjört', 'Friðborg', 'Friðdís', 'Friðdóra', 'Friðey', 'Friðfinna', 'Friðgerður', 'Friðjóna', 'Friðlaug', 'Friðleif', 'Friðlín', 'Friðmey', 'Friðný', 'Friðrika', 'Friðrikka', 'Friðrós', 'Friðrún', 'Friðsemd', 'Friðveig', 'Friðþóra', 'Frigg', 'Fríða', 'Fríður', 'Frostrós', 'Fróðný', 'Fura', 'Fönn', 'Gabríela', 'Gabríella', 'Gauja', 'Gauthildur', 'Gefjun', 'Gefn', 'Geira', 'Geirbjörg', 'Geirdís', 'Geirfinna', 'Geirfríður', 'Geirhildur', 'Geirlaug', 'Geirlöð', 'Geirný', 'Geirríður', 'Geirrún', 'Geirþrúður', 'Georgía', 'Gerða', 'Gerður', 'Gestheiður', 'Gestný', 'Gestrún', 'Gillý', 'Gilslaug', 'Gissunn', 'Gía', 'Gígja', 'Gísela', 'Gísla', 'Gísley', 'Gíslína', 'Gíslný', 'Gíslrún', 'Gíslunn', 'Gíta', 'Gjaflaug', 'Gloría', 'Gló', 'Glóa', 'Glóbjört', 'Glódís', 'Glóð', 'Glóey', 'Gná', 'Góa', 'Gógó', 'Grein', 'Gret', 'Greta', 'Grélöð', 'Grét', 'Gréta', 'Gríma', 'Grímey', 'Grímheiður', 'Grímhildur', 'Gróa', 'Guðbjörg', 'Guðbjört', 'Guðborg', 'Guðdís', 'Guðfinna', 'Guðfríður', 'Guðjóna', 'Guðlaug', 'Guðleif', 'Guðlín', 'Guðmey', 'Guðmunda', 'Guðmundína', 'Guðný', 'Guðríður', 'Guðrún', 'Guðsteina', 'Guðveig', 'Gullbrá', 'Gullveig', 'Gullý', 'Gumma', 'Gunnbjörg', 'Gunnbjört', 'Gunnborg', 'Gunndís', 'Gunndóra', 'Gunnella', 'Gunnfinna', 'Gunnfríður', 'Gunnharða', 'Gunnheiður', 'Gunnhildur', 'Gunnjóna', 'Gunnlaug', 'Gunnleif', 'Gunnlöð', 'Gunnrún', 'Gunnur', 'Gunnveig', 'Gunnvör', 'Gunný', 'Gunnþóra', 'Gunnþórunn', 'Gurrý', 'Gúa', 'Gyða', 'Gyðja', 'Gyðríður', 'Gytta', 'Gæfa', 'Gæflaug', 'Hadda', 'Haddý', 'Hafbjörg', 'Hafborg', 'Hafdís', 'Hafey', 'Hafliða', 'Haflína', 'Hafný', 'Hafrós', 'Hafrún', 'Hafsteina', 'Hafþóra', 'Halla', 'Hallbera', 'Hallbjörg', 'Hallborg', 'Halldís', 'Halldóra', 'Halley', 'Hallfríður', 'Hallgerður', 'Hallgunnur', 'Hallkatla', 'Hallný', 'Hallrún', 'Hallveig', 'Hallvör', 'Hanna', 'Hanney', 'Hansa', 'Hansína', 'Harpa', 'Hauður', 'Hákonía', 'Heba', 'Hedda', 'Hedí', 'Heiða', 'Heiðbjörg', 'Heiðbjörk', 'Heiðbjört', 'Heiðbrá', 'Heiðdís', 'Heiðlaug', 'Heiðlóa', 'Heiðný', 'Heiðrós', 'Heiðrún', 'Heiður', 'Heiðveig', 'Hekla', 'Helen', 'Helena', 'Helga', 'Hella', 'Helma', 'Hendrikka', 'Henný', 'Henrietta', 'Henrika', 'Henríetta', 'Hera', 'Herbjörg', 'Herbjört', 'Herborg', 'Herdís', 'Herfríður', 'Hergerður', 'Herlaug', 'Hermína', 'Hersilía', 'Herta', 'Hertha', 'Hervör', 'Herþrúður', 'Hilda', 'Hildegard', 'Hildibjörg', 'Hildigerður', 'Hildigunnur', 'Hildiríður', 'Hildisif', 'Hildur', 'Hilma', 'Himinbjörg', 'Hind', 'Hinrika', 'Hinrikka', 'Hjalta', 'Hjaltey', 'Hjálmdís', 'Hjálmey', 'Hjálmfríður', 'Hjálmgerður', 'Hjálmrós', 'Hjálmrún', 'Hjálmveig', 'Hjördís', 'Hjörfríður', 'Hjörleif', 'Hjörný', 'Hjörtfríður', 'Hlaðgerður', 'Hlédís', 'Hlíf', 'Hlín', 'Hlökk', 'Hólmbjörg', 'Hólmdís', 'Hólmfríður', 'Hrafna', 'Hrafnborg', 'Hrafndís', 'Hrafney', 'Hrafngerður', 'Hrafnheiður', 'Hrafnhildur', 'Hrafnkatla', 'Hrafnlaug', 'Hrafntinna', 'Hraundís', 'Hrefna', 'Hreindís', 'Hróðný', 'Hrólfdís', 'Hrund', 'Hrönn', 'Hugbjörg', 'Hugbjört', 'Hugborg', 'Hugdís', 'Hugljúf', 'Hugrún', 'Huld', 'Hulda', 'Huldís', 'Huldrún', 'Húnbjörg', 'Húndís', 'Húngerður', 'Hvönn', 'Hödd', 'Högna', 'Hörn', 'Ida', 'Idda', 'Iða', 'Iðunn', 'Ilmur', 'Immý', 'Ina', 'Inda', 'India', 'Indiana', 'Indía', 'Indíana', 'Indíra', 'Indra', 'Inga', 'Ingdís', 'Ingeborg', 'Inger', 'Ingey', 'Ingheiður', 'Inghildur', 'Ingibjörg', 'Ingibjört', 'Ingiborg', 'Ingifinna', 'Ingifríður', 'Ingigerður', 'Ingilaug', 'Ingileif', 'Ingilín', 'Ingimaría', 'Ingimunda', 'Ingiríður', 'Ingirós', 'Ingisól', 'Ingiveig', 'Ingrid', 'Ingrún', 'Ingunn', 'Ingveldur', 'Inna', 'Irena', 'Irene', 'Irja', 'Irma', 'Irmý', 'Irpa', 'Isabel', 'Isabella', 'Ída', 'Íma', 'Ína', 'Ír', 'Íren', 'Írena', 'Íris', 'Írunn', 'Ísabel', 'Ísabella', 'Ísadóra', 'Ísafold', 'Ísalind', 'Ísbjörg', 'Ísdís', 'Ísey', 'Ísfold', 'Ísgerður', 'Íshildur', 'Ísis', 'Íslaug', 'Ísleif', 'Ísmey', 'Ísold', 'Ísól', 'Ísrún', 'Íssól', 'Ísveig', 'Íunn', 'Íva', 'Jakobína', 'Jana', 'Jane', 'Janetta', 'Jannika', 'Jara', 'Jarún', 'Jarþrúður', 'Jasmín', 'Járnbrá', 'Járngerður', 'Jenetta', 'Jenna', 'Jenný', 'Jensína', 'Jessý', 'Jovina', 'Jóa', 'Jóanna', 'Jódís', 'Jófríður', 'Jóhanna', 'Jólín', 'Jóna', 'Jónanna', 'Jónasína', 'Jónbjörg', 'Jónbjört', 'Jóndís', 'Jóndóra', 'Jóney', 'Jónfríður', 'Jóngerð', 'Jónheiður', 'Jónhildur', 'Jóninna', 'Jónída', 'Jónína', 'Jónný', 'Jóný', 'Jóra', 'Jóríður', 'Jórlaug', 'Jórunn', 'Jósebína', 'Jósefín', 'Jósefína', 'Judith', 'Júdea', 'Júdit', 'Júlía', 'Júlíana', 'Júlíanna', 'Júlíetta', 'Júlírós', 'Júnía', 'Júníana', 'Jökla', 'Jökulrós', 'Jörgína', 'Kaðlín', 'Kaja', 'Kalla', 'Kamilla', 'Kamí', 'Kamma', 'Kapitola', 'Kapítóla', 'Kara', 'Karen', 'Karin', 'Karitas', 'Karí', 'Karín', 'Karína', 'Karítas', 'Karla', 'Karlinna', 'Karlína', 'Karlotta', 'Karolína', 'Karó', 'Karólín', 'Karólína', 'Kassandra', 'Kata', 'Katarína', 'Katerína', 'Katharina', 'Kathinka', 'Katinka', 'Katla', 'Katrín', 'Katrína', 'Katý', 'Kára', 'Kellý', 'Kendra', 'Ketilbjörg', 'Ketilfríður', 'Ketilríður', 'Kiddý', 'Kira', 'Kirsten', 'Kirstín', 'Kittý', 'Kjalvör', 'Klara', 'Kládía', 'Klementína', 'Kleópatra', 'Kolbjörg', 'Kolbrá', 'Kolbrún', 'Koldís', 'Kolfinna', 'Kolfreyja', 'Kolgríma', 'Kolka', 'Konkordía', 'Konný', 'Korka', 'Kormlöð', 'Kornelía', 'Kókó', 'Krista', 'Kristbjörg', 'Kristborg', 'Kristel', 'Kristensa', 'Kristey', 'Kristfríður', 'Kristgerður', 'Kristin', 'Kristine', 'Kristíana', 'Kristíanna', 'Kristín', 'Kristína', 'Kristjana', 'Kristjóna', 'Kristlaug', 'Kristlind', 'Kristlín', 'Kristný', 'Kristólína', 'Kristrós', 'Kristrún', 'Kristveig', 'Kristvina', 'Kristþóra', 'Kría', 'Kæja', 'Laila', 'Laíla', 'Lana', 'Lara', 'Laufey', 'Laufheiður', 'Laufhildur', 'Lauga', 'Laugey', 'Laugheiður', 'Lára', 'Lárensína', 'Láretta', 'Lárey', 'Lea', 'Leikný', 'Leila', 'Lena', 'Leonóra', 'Leóna', 'Leónóra', 'Lilja', 'Liljá', 'Liljurós', 'Lill', 'Lilla', 'Lillian', 'Lillý', 'Lily', 'Lilý', 'Lind', 'Linda', 'Linddís', 'Lingný', 'Lisbeth', 'Listalín', 'Liv', 'Líba', 'Líf', 'Lífdís', 'Lín', 'Lína', 'Línbjörg', 'Líndís', 'Líneik', 'Líney', 'Línhildur', 'Lísa', 'Lísabet', 'Lísandra', 'Lísbet', 'Lísebet', 'Lív', 'Ljósbjörg', 'Ljósbrá', 'Ljótunn', 'Lofn', 'Loftveig', 'Logey', 'Lokbrá', 'Lotta', 'Louisa', 'Lousie', 'Lovísa', 'Lóa', 'Lóreley', 'Lukka', 'Lúcía', 'Lúðvíka', 'Lúísa', 'Lúna', 'Lúsinda', 'Lúsía', 'Lúvísa', 'Lydia', 'Lydía', 'Lyngheiður', 'Lýdía', 'Læla', 'Maddý', 'Magda', 'Magdalena', 'Magðalena', 'Magga', 'Maggey', 'Maggý', 'Magna', 'Magndís', 'Magnea', 'Magnes', 'Magney', 'Magnfríður', 'Magnheiður', 'Magnhildur', 'Magnúsína', 'Magný', 'Magnþóra', 'Maía', 'Maídís', 'Maísól', 'Maj', 'Maja', 'Malen', 'Malena', 'Malía', 'Malín', 'Malla', 'Manda', 'Manúela', 'Mara', 'Mardís', 'Marela', 'Marella', 'Maren', 'Marey', 'Marfríður', 'Margit', 'Margot', 'Margret', 'Margrét', 'Margrjet', 'Margunnur', 'Marheiður', 'Maria', 'Marie', 'Marikó', 'Marinella', 'Marit', 'Marí', 'María', 'Maríam', 'Marían', 'Maríana', 'Maríanna', 'Marín', 'Marína', 'Marínella', 'Maríon', 'Marísa', 'Marísól', 'Marít', 'Maríuerla', 'Marja', 'Markrún', 'Marlaug', 'Marlena', 'Marlín', 'Marlís', 'Marólína', 'Marsa', 'Marselía', 'Marselína', 'Marsibil', 'Marsilía', 'Marsý', 'Marta', 'Martha', 'Martína', 'Mary', 'Marý', 'Matta', 'Mattea', 'Matthea', 'Matthilda', 'Matthildur', 'Matthía', 'Mattíana', 'Mattína', 'Mattý', 'Maxima', 'Mábil', 'Málfríður', 'Málhildur', 'Málmfríður', 'Mánadís', 'Máney', 'Mára', 'Meda', 'Mekkin', 'Mekkín', 'Melinda', 'Melissa', 'Melkorka', 'Melrós', 'Messíana', 'Metta', 'Mey', 'Mikaela', 'Mikaelína', 'Mikkalína', 'Milda', 'Mildríður', 'Milla', 'Millý', 'Minerva', 'Minna', 'Minney', 'Minný', 'Miriam', 'Mirja', 'Mirjam', 'Mirra', 'Mist', 'Mía', 'Mínerva', 'Míra', 'Míranda', 'Mítra', 'Mjaðveig', 'Mjalldís', 'Mjallhvít', 'Mjöll', 'Mona', 'Monika', 'Módís', 'Móeiður', 'Móey', 'Móheiður', 'Móna', 'Mónika', 'Móníka', 'Munda', 'Mundheiður', 'Mundhildur', 'Mundína', 'Myrra', 'Mýr', 'Mýra', 'Mýrún', 'Mörk', 'Nadia', 'Nadía', 'Nadja', 'Nana', 'Nanna', 'Nanný', 'Nansý', 'Naomí', 'Naómí', 'Natalie', 'Natalía', 'Náttsól', 'Nella', 'Nellý', 'Nenna', 'Nicole', 'Niðbjörg', 'Nikíta', 'Nikoletta', 'Nikólína', 'Ninja', 'Ninna', 'Nína', 'Níní', 'Njála', 'Njóla', 'Norma', 'Nóa', 'Nóra', 'Nótt', 'Nýbjörg', 'Odda', 'Oddbjörg', 'Oddfreyja', 'Oddfríður', 'Oddgerður', 'Oddhildur', 'Oddlaug', 'Oddleif', 'Oddný', 'Oddrún', 'Oddveig', 'Oddvör', 'Oktavía', 'Októvía', 'Olga', 'Ollý', 'Ora', 'Orka', 'Ormheiður', 'Ormhildur', 'Otkatla', 'Otta', 'Óda', 'Ófelía', 'Óla', 'Ólafía', 'Ólafína', 'Ólavía', 'Ólivía', 'Ólína', 'Ólöf', 'Ósa', 'Ósk', 'Ótta', 'Pamela', 'París', 'Patricia', 'Patrisía', 'Pála', 'Páldís', 'Páley', 'Pálfríður', 'Pálhanna', 'Pálheiður', 'Pálhildur', 'Pálín', 'Pálína', 'Pálmey', 'Pálmfríður', 'Pálrún', 'Perla', 'Peta', 'Petra', 'Petrea', 'Petrína', 'Petronella', 'Petrónella', 'Petrós', 'Petrún', 'Petrúnella', 'Pétrína', 'Pétrún', 'Pía', 'Polly', 'Pollý', 'Pría', 'Rafney', 'Rafnhildur', 'Ragna', 'Ragnbjörg', 'Ragney', 'Ragnfríður', 'Ragnheiður', 'Ragnhildur', 'Rakel', 'Ramóna', 'Randalín', 'Randíður', 'Randý', 'Ranka', 'Rannva', 'Rannveig', 'Ráðhildur', 'Rán', 'Rebekka', 'Reginbjörg', 'Regína', 'Rein', 'Renata', 'Reyn', 'Reyndís', 'Reynheiður', 'Reynhildur', 'Rikka', 'Ripley', 'Rita', 'Ríkey', 'Rín', 'Ríta', 'Ronja', 'Rorí', 'Roxanna', 'Róberta', 'Róbjörg', 'Rós', 'Rósa', 'Rósalind', 'Rósanna', 'Rósbjörg', 'Rósborg', 'Róselía', 'Rósey', 'Rósfríður', 'Róshildur', 'Rósinkara', 'Rósinkransa', 'Róska', 'Róslaug', 'Róslind', 'Róslinda', 'Róslín', 'Rósmary', 'Rósmarý', 'Rósmunda', 'Rósný', 'Runný', 'Rut', 'Ruth', 'Rúbý', 'Rún', 'Rúna', 'Rúndís', 'Rúnhildur', 'Rúrí', 'Röfn', 'Rögn', 'Röskva', 'Sabína', 'Sabrína', 'Saga', 'Salbjörg', 'Saldís', 'Salgerður', 'Salín', 'Salína', 'Salka', 'Salma', 'Salný', 'Salome', 'Salóme', 'Salvör', 'Sandra', 'Sanna', 'Santía', 'Sara', 'Sarína', 'Sefanía', 'Selja', 'Selka', 'Selma', 'Senía', 'Septíma', 'Sera', 'Serena', 'Seselía', 'Sesilía', 'Sesselía', 'Sesselja', 'Sessilía', 'Sif', 'Sigdís', 'Sigdóra', 'Sigfríð', 'Sigfríður', 'Sigga', 'Siggerður', 'Sigmunda', 'Signa', 'Signhildur', 'Signý', 'Sigríður', 'Sigrún', 'Sigurást', 'Sigurásta', 'Sigurbára', 'Sigurbirna', 'Sigurbjörg', 'Sigurbjört', 'Sigurborg', 'Sigurdís', 'Sigurdóra', 'Sigurdríf', 'Sigurdrífa', 'Sigurða', 'Sigurey', 'Sigurfinna', 'Sigurfljóð', 'Sigurgeira', 'Sigurhanna', 'Sigurhelga', 'Sigurhildur', 'Sigurjóna', 'Sigurlaug', 'Sigurleif', 'Sigurlilja', 'Sigurlinn', 'Sigurlín', 'Sigurlína', 'Sigurmunda', 'Sigurnanna', 'Sigurósk', 'Sigurrós', 'Sigursteina', 'Sigurunn', 'Sigurveig', 'Sigurvina', 'Sigurþóra', 'Sigyn', 'Sigþóra', 'Sigþrúður', 'Silfa', 'Silfá', 'Silfrún', 'Silja', 'Silka', 'Silla', 'Silva', 'Silvana', 'Silvía', 'Sirra', 'Sirrý', 'Siv', 'Sía', 'Símonía', 'Sísí', 'Síta', 'Sjöfn', 'Skarpheiður', 'Skugga', 'Skuld', 'Skúla', 'Skúlína', 'Snjáfríður', 'Snjáka', 'Snjófríður', 'Snjólaug', 'Snorra', 'Snót', 'Snæbjörg', 'Snæbjört', 'Snæborg', 'Snæbrá', 'Snædís', 'Snæfríður', 'Snælaug', 'Snærós', 'Snærún', 'Soffía', 'Sofie', 'Sofía', 'Solveig', 'Sonja', 'Sonný', 'Sophia', 'Sophie', 'Sól', 'Sóla', 'Sólbjörg', 'Sólbjört', 'Sólborg', 'Sólbrá', 'Sólbrún', 'Sóldís', 'Sóldögg', 'Sóley', 'Sólfríður', 'Sólgerður', 'Sólhildur', 'Sólín', 'Sólkatla', 'Sóllilja', 'Sólný', 'Sólrós', 'Sólrún', 'Sólveig', 'Sólvör', 'Sónata', 'Stefana', 'Stefanía', 'Stefánný', 'Steina', 'Steinbjörg', 'Steinborg', 'Steindís', 'Steindóra', 'Steiney', 'Steinfríður', 'Steingerður', 'Steinhildur', 'Steinlaug', 'Steinrós', 'Steinrún', 'Steinunn', 'Steinvör', 'Steinþóra', 'Stella', 'Stígheiður', 'Stígrún', 'Stína', 'Stjarna', 'Styrgerður', 'Sumarlína', 'Sumarrós', 'Sunna', 'Sunnefa', 'Sunneva', 'Sunniva', 'Sunníva', 'Susan', 'Súla', 'Súsan', 'Súsanna', 'Svafa', 'Svala', 'Svalrún', 'Svana', 'Svanbjörg', 'Svanbjört', 'Svanborg', 'Svandís', 'Svaney', 'Svanfríður', 'Svanheiður', 'Svanhildur', 'Svanhvít', 'Svanlaug', 'Svanrós', 'Svanþrúður', 'Svava', 'Svea', 'Sveina', 'Sveinbjörg', 'Sveinborg', 'Sveindís', 'Sveiney', 'Sveinfríður', 'Sveingerður', 'Sveinhildur', 'Sveinlaug', 'Sveinrós', 'Sveinrún', 'Sveinsína', 'Sveinveig', 'Sylgja', 'Sylva', 'Sylvía', 'Sæbjörg', 'Sæbjört', 'Sæborg', 'Sædís', 'Sæfinna', 'Sæfríður', 'Sæhildur', 'Sælaug', 'Sæmunda', 'Sæný', 'Særós', 'Særún', 'Sæsól', 'Sæunn', 'Sævör', 'Sölva', 'Sölvey', 'Sölvína', 'Tala', 'Talía', 'Tamar', 'Tamara', 'Tanía', 'Tanja', 'Tanya', 'Tanya', 'Tara', 'Tea', 'Teitný', 'Tekla', 'Telma', 'Tera', 'Teresa', 'Teresía', 'Thea', 'Thelma', 'Theodóra', 'Theódóra', 'Theresa', 'Tindra', 'Tinna', 'Tirsa', 'Tía', 'Tíbrá', 'Tína', 'Todda', 'Torbjörg', 'Torfey', 'Torfheiður', 'Torfhildur', 'Tóbý', 'Tóka', 'Tóta', 'Tristana', 'Trú', 'Tryggva', 'Tryggvína', 'Týra', 'Ugla', 'Una', 'Undína', 'Unna', 'Unnbjörg', 'Unndís', 'Unnur', 'Urður', 'Úa', 'Úlfa', 'Úlfdís', 'Úlfey', 'Úlfheiður', 'Úlfhildur', 'Úlfrún', 'Úlla', 'Úna', 'Úndína', 'Úranía', 'Úrsúla', 'Vagna', 'Vagnbjörg', 'Vagnfríður', 'Vaka', 'Vala', 'Valbjörg', 'Valbjörk', 'Valbjört', 'Valborg', 'Valdheiður', 'Valdís', 'Valentína', 'Valería', 'Valey', 'Valfríður', 'Valgerða', 'Valgerður', 'Valhildur', 'Valka', 'Vallý', 'Valný', 'Valrós', 'Valrún', 'Valva', 'Valý', 'Valþrúður', 'Vanda', 'Vár', 'Veig', 'Veiga', 'Venus', 'Vera', 'Veronika', 'Verónika', 'Veróníka', 'Vetrarrós', 'Vébjörg', 'Védís', 'Végerður', 'Vélaug', 'Véný', 'Vibeka', 'Victoría', 'Viðja', 'Vigdís', 'Vigný', 'Viktoria', 'Viktoría', 'Vilborg', 'Vildís', 'Vilfríður', 'Vilgerður', 'Vilhelmína', 'Villa', 'Villimey', 'Vilma', 'Vilný', 'Vinbjörg', 'Vinný', 'Vinsý', 'Virginía', 'Víbekka', 'Víf', 'Vígdögg', 'Víggunnur', 'Víóla', 'Víóletta', 'Vísa', 'Von', 'Von', 'Voney', 'Vordís', 'Ylfa', 'Ylfur', 'Ylja', 'Ylva', 'Ynja', 'Yrja', 'Yrsa', 'Ýja', 'Ýma', 'Ýr', 'Ýrr', 'Þalía', 'Þeba', 'Þeódís', 'Þeódóra', 'Þjóðbjörg', 'Þjóðhildur', 'Þoka', 'Þorbjörg', 'Þorfinna', 'Þorgerður', 'Þorgríma', 'Þorkatla', 'Þorlaug', 'Þorleif', 'Þorsteina', 'Þorstína', 'Þóra', 'Þóranna', 'Þórarna', 'Þórbjörg', 'Þórdís', 'Þórða', 'Þórelfa', 'Þórelfur', 'Þórey', 'Þórfríður', 'Þórgunna', 'Þórgunnur', 'Þórhalla', 'Þórhanna', 'Þórheiður', 'Þórhildur', 'Þórkatla', 'Þórlaug', 'Þórleif', 'Þórný', 'Þórodda', 'Þórsteina', 'Þórsteinunn', 'Þórstína', 'Þórunn', 'Þórveig', 'Þórvör', 'Þrá', 'Þrúða', 'Þrúður', 'Þula', 'Þura', 'Þurí', 'Þuríður', 'Þurý', 'Þúfa', 'Þyri', 'Þyrí', 'Þöll', 'Ægileif', 'Æsa', 'Æsgerður', 'Ögmunda', 'Ögn', 'Ölrún', 'Ölveig', 'Örbrún', 'Örk', 'Ösp'];

    /**
     * @var array<string> Icelandic names for men.
     */
    protected static $firstNameMale = ['Aage', 'Abel', 'Abraham', 'Adam', 'Addi', 'Adel', 'Adíel', 'Adólf', 'Adrían', 'Adríel', 'Aðalberg', 'Aðalbergur', 'Aðalbert', 'Aðalbjörn', 'Aðalborgar', 'Aðalgeir', 'Aðalmundur', 'Aðalráður', 'Aðalsteinn', 'Aðólf', 'Agnar', 'Agni', 'Albert', 'Aldar', 'Alex', 'Alexander', 'Alexíus', 'Alfons', 'Alfred', 'Alfreð', 'Ali', 'Allan', 'Alli', 'Almar', 'Alrekur', 'Alvar', 'Alvin', 'Amír', 'Amos', 'Anders', 'Andreas', 'André', 'Andrés', 'Andri', 'Anes', 'Anfinn', 'Angantýr', 'Angi', 'Annar', 'Annarr', 'Annas', 'Annel', 'Annes', 'Anthony', 'Anton', 'Antoníus', 'Aran', 'Arent', 'Ares', 'Ari', 'Arilíus', 'Arinbjörn', 'Aríel', 'Aríus', 'Arnald', 'Arnaldur', 'Arnar', 'Arnberg', 'Arnbergur', 'Arnbjörn', 'Arndór', 'Arnes', 'Arnfinnur', 'Arnfreyr', 'Arngeir', 'Arngils', 'Arngrímur', 'Arnkell', 'Arnlaugur', 'Arnleifur', 'Arnljótur', 'Arnmóður', 'Arnmundur', 'Arnoddur', 'Arnold', 'Arnór', 'Arnsteinn', 'Arnúlfur', 'Arnviður', 'Arnþór', 'Aron', 'Arthur', 'Arthúr', 'Artúr', 'Asael', 'Askur', 'Aspar', 'Atlas', 'Atli', 'Auðbergur', 'Auðbert', 'Auðbjörn', 'Auðgeir', 'Auðkell', 'Auðmundur', 'Auðólfur', 'Auðun', 'Auðunn', 'Austar', 'Austmann', 'Austmar', 'Austri', 'Axel', 'Ágúst', 'Áki', 'Álfar', 'Álfgeir', 'Álfgrímur', 'Álfur', 'Álfþór', 'Ámundi', 'Árbjartur', 'Árbjörn', 'Árelíus', 'Árgeir', 'Árgils', 'Ármann', 'Árni', 'Ársæll', 'Ás', 'Ásberg', 'Ásbergur', 'Ásbjörn', 'Ásgautur', 'Ásgeir', 'Ásgils', 'Ásgrímur', 'Ási', 'Áskell', 'Áslaugur', 'Áslákur', 'Ásmar', 'Ásmundur', 'Ásólfur', 'Ásröður', 'Ástbjörn', 'Ástgeir', 'Ástmar', 'Ástmundur', 'Ástráður', 'Ástríkur', 'Ástvald', 'Ástvaldur', 'Ástvar', 'Ástvin', 'Ástþór', 'Ásvaldur', 'Ásvarður', 'Ásþór', 'Baldur', 'Baldvin', 'Baldwin', 'Baltasar', 'Bambi', 'Barði', 'Barri', 'Bassi', 'Bastían', 'Baugur', 'Bárður', 'Beinir', 'Beinteinn', 'Beitir', 'Bekan', 'Benedikt', 'Benidikt', 'Benjamín', 'Benoný', 'Benóní', 'Benóný', 'Bent', 'Berent', 'Berg', 'Bergfinnur', 'Berghreinn', 'Bergjón', 'Bergmann', 'Bergmar', 'Bergmundur', 'Bergsteinn', 'Bergsveinn', 'Bergur', 'Bergvin', 'Bergþór', 'Bernhard', 'Bernharð', 'Bernharður', 'Berni', 'Bernódus', 'Bersi', 'Bertel', 'Bertram', 'Bessi', 'Betúel', 'Bill', 'Birgir', 'Birkir', 'Birnir', 'Birtingur', 'Birtir', 'Bjargar', 'Bjargmundur', 'Bjargþór', 'Bjarkan', 'Bjarkar', 'Bjarki', 'Bjarmar', 'Bjarmi', 'Bjarnar', 'Bjarnfinnur', 'Bjarnfreður', 'Bjarnharður', 'Bjarnhéðinn', 'Bjarni', 'Bjarnlaugur', 'Bjarnleifur', 'Bjarnólfur', 'Bjarnsteinn', 'Bjarnþór', 'Bjartmann', 'Bjartmar', 'Bjartur', 'Bjartþór', 'Bjólan', 'Bjólfur', 'Björgmundur', 'Björgólfur', 'Björgúlfur', 'Björgvin', 'Björn', 'Björnólfur', 'Blængur', 'Blær', 'Blævar', 'Boði', 'Bogi', 'Bolli', 'Borgar', 'Borgúlfur', 'Borgþór', 'Bóas', 'Bói', 'Bótólfur', 'Bragi', 'Brandur', 'Breki', 'Bresi', 'Brestir', 'Brimar', 'Brimi', 'Brimir', 'Brími', 'Brjánn', 'Broddi', 'Bruno', 'Bryngeir', 'Brynjar', 'Brynjólfur', 'Brynjúlfur', 'Brynleifur', 'Brynsteinn', 'Bryntýr', 'Brynþór', 'Burkni', 'Búi', 'Búri', 'Bæring', 'Bæringur', 'Bæron', 'Böðvar', 'Börkur', 'Carl', 'Cecil', 'Christian', 'Christopher', 'Cýrus', 'Daði', 'Dagbjartur', 'Dagfari', 'Dagfinnur', 'Daggeir', 'Dagmann', 'Dagnýr', 'Dagur', 'Dagþór', 'Dalbert', 'Dalli', 'Dalmann', 'Dalmar', 'Dalvin', 'Damjan', 'Dan', 'Danelíus', 'Daniel', 'Danival', 'Daníel', 'Daníval', 'Dante', 'Daríus', 'Darri', 'Davíð', 'Demus', 'Deníel', 'Dennis', 'Diðrik', 'Díómedes', 'Dofri', 'Dolli', 'Dominik', 'Dómald', 'Dómaldi', 'Dómaldur', 'Dónald', 'Dónaldur', 'Dór', 'Dóri', 'Dósóþeus', 'Draupnir', 'Dreki', 'Drengur', 'Dufgus', 'Dufþakur', 'Dugfús', 'Dúi', 'Dúnn', 'Dvalinn', 'Dýri', 'Dýrmundur', 'Ebbi', 'Ebeneser', 'Ebenezer', 'Eberg', 'Edgar', 'Edilon', 'Edílon', 'Edvard', 'Edvin', 'Edward', 'Eðvald', 'Eðvar', 'Eðvarð', 'Efraím', 'Eggert', 'Eggþór', 'Egill', 'Eiðar', 'Eiður', 'Eikar', 'Eilífur', 'Einar', 'Einir', 'Einvarður', 'Einþór', 'Eiríkur', 'Eivin', 'Elberg', 'Elbert', 'Eldar', 'Eldgrímur', 'Eldjárn', 'Eldmar', 'Eldon', 'Eldór', 'Eldur', 'Elentínus', 'Elfar', 'Elfráður', 'Elimar', 'Elinór', 'Elis', 'Elí', 'Elías', 'Elíeser', 'Elímar', 'Elínbergur', 'Elínmundur', 'Elínór', 'Elís', 'Ellert', 'Elli', 'Elliði', 'Ellís', 'Elmar', 'Elvar', 'Elvin', 'Elvis', 'Emanúel', 'Embrek', 'Emerald', 'Emil', 'Emmanúel', 'Engilbert', 'Engilbjartur', 'Engiljón', 'Engill', 'Enok', 'Eric', 'Erik', 'Erlar', 'Erlendur', 'Erling', 'Erlingur', 'Ernestó', 'Ernir', 'Ernst', 'Eron', 'Erpur', 'Esekíel', 'Esjar', 'Esra', 'Estefan', 'Evald', 'Evan', 'Evert', 'Eyberg', 'Eyjólfur', 'Eylaugur', 'Eyleifur', 'Eymar', 'Eymundur', 'Eyríkur', 'Eysteinn', 'Eyvar', 'Eyvindur', 'Eyþór', 'Fabrisíus', 'Falgeir', 'Falur', 'Fannar', 'Fannberg', 'Fanngeir', 'Fáfnir', 'Fálki', 'Felix', 'Fengur', 'Fenrir', 'Ferdinand', 'Ferdínand', 'Fertram', 'Feykir', 'Filip', 'Filippus', 'Finn', 'Finnbjörn', 'Finnbogi', 'Finngeir', 'Finnjón', 'Finnlaugur', 'Finnur', 'Finnvarður', 'Fífill', 'Fjalar', 'Fjarki', 'Fjólar', 'Fjólmundur', 'Fjölnir', 'Fjölvar', 'Fjörnir', 'Flemming', 'Flosi', 'Flóki', 'Flórent', 'Flóvent', 'Forni', 'Fossmar', 'Fólki', 'Francis', 'Frank', 'Franklín', 'Frans', 'Franz', 'Fránn', 'Frár', 'Freybjörn', 'Freygarður', 'Freymar', 'Freymóður', 'Freymundur', 'Freyr', 'Freysteinn', 'Freyviður', 'Freyþór', 'Friðberg', 'Friðbergur', 'Friðbert', 'Friðbjörn', 'Friðfinnur', 'Friðgeir', 'Friðjón', 'Friðlaugur', 'Friðleifur', 'Friðmann', 'Friðmar', 'Friðmundur', 'Friðrik', 'Friðsteinn', 'Friður', 'Friðvin', 'Friðþjófur', 'Friðþór', 'Friedrich', 'Fritz', 'Frímann', 'Frosti', 'Fróði', 'Fróðmar', 'Funi', 'Fúsi', 'Fylkir', 'Gabriel', 'Gabríel', 'Gael', 'Galdur', 'Gamalíel', 'Garðar', 'Garibaldi', 'Garpur', 'Garri', 'Gaui', 'Gaukur', 'Gauti', 'Gautrekur', 'Gautur', 'Gautviður', 'Geir', 'Geirarður', 'Geirfinnur', 'Geirharður', 'Geirhjörtur', 'Geirhvatur', 'Geiri', 'Geirlaugur', 'Geirleifur', 'Geirmundur', 'Geirólfur', 'Geirröður', 'Geirtryggur', 'Geirvaldur', 'Geirþjófur', 'Geisli', 'Gellir', 'Georg', 'Gerald', 'Gerðar', 'Geri', 'Gestur', 'Gilbert', 'Gilmar', 'Gils', 'Gissur', 'Gizur', 'Gídeon', 'Gígjar', 'Gísli', 'Gjúki', 'Glói', 'Glúmur', 'Gneisti', 'Gnúpur', 'Gnýr', 'Goði', 'Goðmundur', 'Gottskálk', 'Gottsveinn', 'Gói', 'Grani', 'Grankell', 'Gregor', 'Greipur', 'Greppur', 'Gretar', 'Grettir', 'Grétar', 'Grímar', 'Grímkell', 'Grímlaugur', 'Grímnir', 'Grímólfur', 'Grímur', 'Grímúlfur', 'Guðberg', 'Guðbergur', 'Guðbjarni', 'Guðbjartur', 'Guðbjörn', 'Guðbrandur', 'Guðfinnur', 'Guðfreður', 'Guðgeir', 'Guðjón', 'Guðlaugur', 'Guðleifur', 'Guðleikur', 'Guðmann', 'Guðmar', 'Guðmon', 'Guðmundur', 'Guðni', 'Guðráður', 'Guðröður', 'Guðsteinn', 'Guðvarður', 'Guðveigur', 'Guðvin', 'Guðþór', 'Gumi', 'Gunnar', 'Gunnberg', 'Gunnbjörn', 'Gunndór', 'Gunngeir', 'Gunnhallur', 'Gunnlaugur', 'Gunnleifur', 'Gunnólfur', 'Gunnóli', 'Gunnröður', 'Gunnsteinn', 'Gunnvaldur', 'Gunnþór', 'Gustav', 'Gutti', 'Guttormur', 'Gústaf', 'Gústav', 'Gylfi', 'Gyrðir', 'Gýgjar', 'Gýmir', 'Haddi', 'Haddur', 'Hafberg', 'Hafgrímur', 'Hafliði', 'Hafnar', 'Hafni', 'Hafsteinn', 'Hafþór', 'Hagalín', 'Hagbarður', 'Hagbert', 'Haki', 'Hallberg', 'Hallbjörn', 'Halldór', 'Hallfreður', 'Hallgarður', 'Hallgeir', 'Hallgils', 'Hallgrímur', 'Hallkell', 'Hallmann', 'Hallmar', 'Hallmundur', 'Hallsteinn', 'Hallur', 'Hallvarður', 'Hallþór', 'Hamar', 'Hannes', 'Hannibal', 'Hans', 'Harald', 'Haraldur', 'Harri', 'Harry', 'Harrý', 'Hartmann', 'Hartvig', 'Hauksteinn', 'Haukur', 'Haukvaldur', 'Hákon', 'Háleygur', 'Hálfdan', 'Hálfdán', 'Hámundur', 'Hárekur', 'Hárlaugur', 'Hásteinn', 'Hávar', 'Hávarður', 'Hávarr', 'Hávarr', 'Heiðar', 'Heiðarr', 'Heiðberg', 'Heiðbert', 'Heiðlindur', 'Heiðmann', 'Heiðmar', 'Heiðmundur', 'Heiðrekur', 'Heikir', 'Heilmóður', 'Heimir', 'Heinrekur', 'Heisi', 'Hektor', 'Helgi', 'Helmút', 'Hemmert', 'Hendrik', 'Henning', 'Henrik', 'Henry', 'Henrý', 'Herbert', 'Herbjörn', 'Herfinnur', 'Hergeir', 'Hergill', 'Hergils', 'Herjólfur', 'Herlaugur', 'Herleifur', 'Herluf', 'Hermann', 'Hermóður', 'Hermundur', 'Hersir', 'Hersteinn', 'Hersveinn', 'Hervar', 'Hervarður', 'Hervin', 'Héðinn', 'Hilaríus', 'Hilbert', 'Hildar', 'Hildibergur', 'Hildibrandur', 'Hildigeir', 'Hildiglúmur', 'Hildimar', 'Hildimundur', 'Hildingur', 'Hildir', 'Hildiþór', 'Hilmar', 'Hilmir', 'Himri', 'Hinrik', 'Híram', 'Hjallkár', 'Hjalti', 'Hjarnar', 'Hjálmar', 'Hjálmgeir', 'Hjálmtýr', 'Hjálmur', 'Hjálmþór', 'Hjörleifur', 'Hjörtur', 'Hjörtþór', 'Hjörvar', 'Hleiðar', 'Hlégestur', 'Hlér', 'Hlini', 'Hlíðar', 'Hlíðberg', 'Hlífar', 'Hljómur', 'Hlynur', 'Hlöðmundur', 'Hlöður', 'Hlöðvarður', 'Hlöðver', 'Hnefill', 'Hnikar', 'Hnikarr', 'Holgeir', 'Holger', 'Holti', 'Hólm', 'Hólmar', 'Hólmbert', 'Hólmfastur', 'Hólmgeir', 'Hólmgrímur', 'Hólmkell', 'Hólmsteinn', 'Hólmþór', 'Hóseas', 'Hrafn', 'Hrafnar', 'Hrafnbergur', 'Hrafnkell', 'Hrafntýr', 'Hrannar', 'Hrappur', 'Hraunar', 'Hreggviður', 'Hreiðar', 'Hreiðmar', 'Hreimur', 'Hreinn', 'Hringur', 'Hrímnir', 'Hrollaugur', 'Hrolleifur', 'Hróaldur', 'Hróar', 'Hróbjartur', 'Hróðgeir', 'Hróðmar', 'Hróðólfur', 'Hróðvar', 'Hrói', 'Hrólfur', 'Hrómundur', 'Hrútur', 'Hrærekur', 'Hugberg', 'Hugi', 'Huginn', 'Hugleikur', 'Hugo', 'Hugó', 'Huldar', 'Huxley', 'Húbert', 'Húgó', 'Húmi', 'Húnbogi', 'Húni', 'Húnn', 'Húnröður', 'Hvannar', 'Hyltir', 'Hylur', 'Hængur', 'Hænir', 'Höður', 'Högni', 'Hörður', 'Höskuldur', 'Illugi', 'Immanúel', 'Indriði', 'Ingberg', 'Ingi', 'Ingiberg', 'Ingibergur', 'Ingibert', 'Ingibjartur', 'Ingibjörn', 'Ingileifur', 'Ingimagn', 'Ingimar', 'Ingimundur', 'Ingivaldur', 'Ingiþór', 'Ingjaldur', 'Ingmar', 'Ingólfur', 'Ingvaldur', 'Ingvar', 'Ingvi', 'Ingþór', 'Ismael', 'Issi', 'Ían', 'Ígor', 'Ími', 'Ísak', 'Ísar', 'Ísarr', 'Ísbjörn', 'Íseldur', 'Ísgeir', 'Ísidór', 'Ísleifur', 'Ísmael', 'Ísmar', 'Ísólfur', 'Ísrael', 'Ívan', 'Ívar', 'Jack', 'Jafet', 'Jaki', 'Jakob', 'Jakop', 'Jamil', 'Jan', 'Janus', 'Jarl', 'Jason', 'Járngrímur', 'Játgeir', 'Játmundur', 'Játvarður', 'Jenni', 'Jens', 'Jeremías', 'Jes', 'Jesper', 'Jochum', 'Johan', 'John', 'Joshua', 'Jóakim', 'Jóann', 'Jóel', 'Jóhann', 'Jóhannes', 'Jói', 'Jómar', 'Jómundur', 'Jón', 'Jónar', 'Jónas', 'Jónatan', 'Jónbjörn', 'Jóndór', 'Jóngeir', 'Jónmundur', 'Jónsteinn', 'Jónþór', 'Jósafat', 'Jósavin', 'Jósef', 'Jósep', 'Jósteinn', 'Jósúa', 'Jóvin', 'Julian', 'Júlí', 'Júlían', 'Júlíus', 'Júní', 'Júníus', 'Júrek', 'Jökull', 'Jörfi', 'Jörgen', 'Jörmundur', 'Jörri', 'Jörundur', 'Jörvar', 'Jörvi', 'Kaj', 'Kakali', 'Kaktus', 'Kaldi', 'Kaleb', 'Kali', 'Kalman', 'Kalmann', 'Kalmar', 'Kaprasíus', 'Karel', 'Karim', 'Karkur', 'Karl', 'Karles', 'Karli', 'Karvel', 'Kaspar', 'Kasper', 'Kastíel', 'Katarínus', 'Kató', 'Kár', 'Kári', 'Keran', 'Ketilbjörn', 'Ketill', 'Kilían', 'Kiljan', 'Kjalar', 'Kjallakur', 'Kjaran', 'Kjartan', 'Kjarval', 'Kjárr', 'Kjói', 'Klemens', 'Klemenz', 'Klængur', 'Knútur', 'Knörr', 'Koðrán', 'Koggi', 'Kolbeinn', 'Kolbjörn', 'Kolfinnur', 'Kolgrímur', 'Kolmar', 'Kolskeggur', 'Kolur', 'Kolviður', 'Konráð', 'Konstantínus', 'Kormákur', 'Kornelíus', 'Kort', 'Kópur', 'Kraki', 'Kris', 'Kristall', 'Kristberg', 'Kristbergur', 'Kristbjörn', 'Kristdór', 'Kristens', 'Krister', 'Kristfinnur', 'Kristgeir', 'Kristian', 'Kristinn', 'Kristján', 'Kristjón', 'Kristlaugur', 'Kristleifur', 'Kristmann', 'Kristmar', 'Kristmundur', 'Kristofer', 'Kristófer', 'Kristvaldur', 'Kristvarður', 'Kristvin', 'Kristþór', 'Krummi', 'Kveldúlfur', 'Lambert', 'Lars', 'Laufar', 'Laugi', 'Lauritz', 'Lár', 'Lárent', 'Lárentíus', 'Lárus', 'Leiðólfur', 'Leif', 'Leifur', 'Leiknir', 'Leo', 'Leon', 'Leonard', 'Leonhard', 'Leó', 'Leópold', 'Leví', 'Lér', 'Liljar', 'Lindar', 'Lindberg', 'Línberg', 'Líni', 'Ljósálfur', 'Ljótur', 'Ljúfur', 'Loðmundur', 'Loftur', 'Logi', 'Loki', 'Lórens', 'Lórenz', 'Ludvig', 'Lundi', 'Lúðvíg', 'Lúðvík', 'Lúkas', 'Lúter', 'Lúther', 'Lyngar', 'Lýður', 'Lýtingur', 'Maggi', 'Magngeir', 'Magni', 'Magnús', 'Magnþór', 'Makan', 'Manfred', 'Manfreð', 'Manúel', 'Mar', 'Marbjörn', 'Marel', 'Margeir', 'Margrímur', 'Mari', 'Marijón', 'Marinó', 'Marías', 'Marínó', 'Marís', 'Maríus', 'Marjón', 'Markó', 'Markús', 'Markþór', 'Maron', 'Marri', 'Mars', 'Marsellíus', 'Marteinn', 'Marten', 'Marthen', 'Martin', 'Marvin', 'Mathías', 'Matthías', 'Matti', 'Mattías', 'Max', 'Maximus', 'Máni', 'Már', 'Márus', 'Mekkinó', 'Melkíor', 'Melkólmur', 'Melrakki', 'Mensalder', 'Merkúr', 'Methúsalem', 'Metúsalem', 'Meyvant', 'Michael', 'Mikael', 'Mikjáll', 'Mikkael', 'Mikkel', 'Mildinberg', 'Mías', 'Mímir', 'Míó', 'Mír', 'Mjöllnir', 'Mjölnir', 'Moli', 'Morgan', 'Moritz', 'Mosi', 'Móði', 'Móri', 'Mórits', 'Móses', 'Muggur', 'Muni', 'Muninn', 'Múli', 'Myrkvi', 'Mýrkjartan', 'Mörður', 'Narfi', 'Natan', 'Natanael', 'Nataníel', 'Náttmörður', 'Náttúlfur', 'Neisti', 'Nenni', 'Neptúnus', 'Nicolas', 'Nikanor', 'Nikolai', 'Nikolas', 'Nikulás', 'Nils', 'Níels', 'Níls', 'Njáll', 'Njörður', 'Nonni', 'Norbert', 'Norðmann', 'Normann', 'Nóam', 'Nóel', 'Nói', 'Nóni', 'Nóri', 'Nóvember', 'Númi', 'Nývarð', 'Nökkvi', 'Oddbergur', 'Oddbjörn', 'Oddfreyr', 'Oddgeir', 'Oddi', 'Oddkell', 'Oddleifur', 'Oddmar', 'Oddsteinn', 'Oddur', 'Oddvar', 'Oddþór', 'Oktavíus', 'Októ', 'Októvíus', 'Olaf', 'Olav', 'Olgeir', 'Oliver', 'Olivert', 'Orfeus', 'Ormar', 'Ormur', 'Orri', 'Orvar', 'Otkell', 'Otri', 'Otti', 'Ottó', 'Otur', 'Óðinn', 'Ófeigur', 'Ólafur', 'Óli', 'Óliver', 'Ólíver', 'Ómar', 'Ómi', 'Óskar', 'Ósvald', 'Ósvaldur', 'Ósvífur', 'Óttar', 'Óttarr', 'Parmes', 'Patrek', 'Patrekur', 'Patrick', 'Patrik', 'Páll', 'Pálmar', 'Pálmi', 'Pedró', 'Per', 'Peter', 'Pétur', 'Pjetur', 'Príor', 'Rafael', 'Rafn', 'Rafnar', 'Rafnkell', 'Ragnar', 'Ragúel', 'Randver', 'Rannver', 'Rasmus', 'Ráðgeir', 'Ráðvarður', 'Refur', 'Reginbaldur', 'Reginn', 'Reidar', 'Reifnir', 'Reimar', 'Reinar', 'Reinhart', 'Reinhold', 'Reynald', 'Reynar', 'Reynir', 'Reyr', 'Richard', 'Rikharð', 'Rikharður', 'Ríkarður', 'Ríkharð', 'Ríkharður', 'Ríó', 'Robert', 'Rolf', 'Ronald', 'Róbert', 'Rólant', 'Róman', 'Rómeó', 'Rósant', 'Rósar', 'Rósberg', 'Rósenberg', 'Rósi', 'Rósinberg', 'Rósinkar', 'Rósinkrans', 'Rósmann', 'Rósmundur', 'Rudolf', 'Runi', 'Runólfur', 'Rúbar', 'Rúben', 'Rúdólf', 'Rúnar', 'Rúrik', 'Rútur', 'Röðull', 'Rögnvald', 'Rögnvaldur', 'Rögnvar', 'Rökkvi', 'Safír', 'Sakarías', 'Salmann', 'Salmar', 'Salómon', 'Salvar', 'Samson', 'Samúel', 'Sandel', 'Sandri', 'Sandur', 'Saxi', 'Sebastian', 'Sebastían', 'Seifur', 'Seimur', 'Sesar', 'Sesil', 'Sigbergur', 'Sigbert', 'Sigbjartur', 'Sigbjörn', 'Sigdór', 'Sigfastur', 'Sigfinnur', 'Sigfreður', 'Sigfús', 'Siggeir', 'Sighvatur', 'Sigjón', 'Siglaugur', 'Sigmann', 'Sigmar', 'Sigmundur', 'Signar', 'Sigri', 'Sigríkur', 'Sigsteinn', 'Sigtryggur', 'Sigtýr', 'Sigur', 'Sigurbaldur', 'Sigurberg', 'Sigurbergur', 'Sigurbjarni', 'Sigurbjartur', 'Sigurbjörn', 'Sigurbrandur', 'Sigurdór', 'Sigurður', 'Sigurfinnur', 'Sigurgeir', 'Sigurgestur', 'Sigurgísli', 'Sigurgrímur', 'Sigurhans', 'Sigurhjörtur', 'Sigurjón', 'Sigurkarl', 'Sigurlaugur', 'Sigurlás', 'Sigurleifur', 'Sigurliði', 'Sigurlinni', 'Sigurmann', 'Sigurmar', 'Sigurmon', 'Sigurmundur', 'Sigurnýas', 'Sigurnýjas', 'Siguroddur', 'Siguróli', 'Sigurpáll', 'Sigursteinn', 'Sigursveinn', 'Sigurvaldi', 'Sigurvin', 'Sigurþór', 'Sigvaldi', 'Sigvarður', 'Sigþór', 'Silli', 'Sindri', 'Símon', 'Sírnir', 'Sírus', 'Sívar', 'Sjafnar', 'Skafti', 'Skapti', 'Skarphéðinn', 'Skefill', 'Skeggi', 'Skíði', 'Skírnir', 'Skjöldur', 'Skorri', 'Skuggi', 'Skúli', 'Skúta', 'Skær', 'Skæringur', 'Smári', 'Smiður', 'Smyrill', 'Snjóki', 'Snjólaugur', 'Snjólfur', 'Snorri', 'Snæbjartur', 'Snæbjörn', 'Snæhólm', 'Snælaugur', 'Snær', 'Snæringur', 'Snævar', 'Snævarr', 'Snæþór', 'Soffanías', 'Sophanías', 'Sophus', 'Sófónías', 'Sófus', 'Sókrates', 'Sólberg', 'Sólbergur', 'Sólbjartur', 'Sólbjörn', 'Sólimann', 'Sólmar', 'Sólmundur', 'Sólon', 'Sólver', 'Sólvin', 'Spartakus', 'Sporði', 'Spói', 'Stanley', 'Stapi', 'Starkaður', 'Starri', 'Stefan', 'Stefán', 'Stefnir', 'Steinar', 'Steinarr', 'Steinberg', 'Steinbergur', 'Steinbjörn', 'Steindór', 'Steinfinnur', 'Steingrímur', 'Steini', 'Steinkell', 'Steinmann', 'Steinmar', 'Steinmóður', 'Steinn', 'Steinólfur', 'Steinröður', 'Steinvarður', 'Steinþór', 'Stirnir', 'Stígur', 'Stormur', 'Stórólfur', 'Sturla', 'Sturlaugur', 'Sturri', 'Styr', 'Styrbjörn', 'Styrkár', 'Styrmir', 'Styrr', 'Sumarliði', 'Svafar', 'Svali', 'Svan', 'Svanberg', 'Svanbergur', 'Svanbjörn', 'Svangeir', 'Svanhólm', 'Svani', 'Svanlaugur', 'Svanmundur', 'Svanur', 'Svanþór', 'Svavar', 'Sváfnir', 'Sveinar', 'Sveinberg', 'Sveinbjartur', 'Sveinbjörn', 'Sveinjón', 'Sveinlaugur', 'Sveinmar', 'Sveinn', 'Sveinungi', 'Sveinþór', 'Svend', 'Sverre', 'Sverrir', 'Svölnir', 'Svörfuður', 'Sýrus', 'Sæberg', 'Sæbergur', 'Sæbjörn', 'Sæi', 'Sælaugur', 'Sæmann', 'Sæmundur', 'Sær', 'Sævald', 'Sævaldur', 'Sævar', 'Sævarr', 'Sævin', 'Sæþór', 'Sölmundur', 'Sölvar', 'Sölvi', 'Sören', 'Sörli', 'Tandri', 'Tarfur', 'Teitur', 'Theodór', 'Theódór', 'Thomas', 'Thor', 'Thorberg', 'Thór', 'Tindar', 'Tindri', 'Tindur', 'Tinni', 'Tími', 'Tímon', 'Tímoteus', 'Tímóteus', 'Tístran', 'Tjaldur', 'Tjörfi', 'Tjörvi', 'Tobías', 'Tolli', 'Tonni', 'Torfi', 'Tóbías', 'Tói', 'Tóki', 'Tómas', 'Tór', 'Trausti', 'Tristan', 'Trostan', 'Trúmann', 'Tryggvi', 'Tumas', 'Tumi', 'Tyrfingur', 'Týr', 'Ubbi', 'Uggi', 'Ulrich', 'Uni', 'Unnar', 'Unnbjörn', 'Unndór', 'Unnsteinn', 'Unnþór', 'Urðar', 'Uxi', 'Úddi', 'Úlfar', 'Úlfgeir', 'Úlfhéðinn', 'Úlfkell', 'Úlfljótur', 'Úlftýr', 'Úlfur', 'Úlrik', 'Úranus', 'Vagn', 'Vakur', 'Valberg', 'Valbergur', 'Valbjörn', 'Valbrandur', 'Valdemar', 'Valdi', 'Valdimar', 'Valdór', 'Valentín', 'Valentínus', 'Valgarð', 'Valgarður', 'Valgeir', 'Valíant', 'Vallaður', 'Valmar', 'Valmundur', 'Valsteinn', 'Valter', 'Valtýr', 'Valur', 'Valves', 'Valþór', 'Varmar', 'Vatnar', 'Váli', 'Vápni', 'Veigar', 'Veigur', 'Ver', 'Vermundur', 'Vernharð', 'Vernharður', 'Vestar', 'Vestmar', 'Veturliði', 'Vébjörn', 'Végeir', 'Vékell', 'Vélaugur', 'Vémundur', 'Vésteinn', 'Victor', 'Viðar', 'Vigfús', 'Viggó', 'Vignir', 'Vigri', 'Vigtýr', 'Vigur', 'Vikar', 'Viktor', 'Vilberg', 'Vilbergur', 'Vilbert', 'Vilbjörn', 'Vilbogi', 'Vilbrandur', 'Vilgeir', 'Vilhelm', 'Vilhjálmur', 'Vili', 'Viljar', 'Vilji', 'Villi', 'Vilmar', 'Vilmundur', 'Vincent', 'Vinjar', 'Virgill', 'Víðar', 'Víðir', 'Vífill', 'Víglundur', 'Vígmar', 'Vígmundur', 'Vígsteinn', 'Vígþór', 'Víkingur', 'Vopni', 'Vorm', 'Vöggur', 'Völundur', 'Vörður', 'Vöttur', 'Walter', 'Werner', 'Wilhelm', 'Willard', 'William', 'Willum', 'Ylur', 'Ymir', 'Yngvar', 'Yngvi', 'Yrkill', 'Ýmir', 'Ýrar', 'Zakaría', 'Zakarías', 'Zophanías', 'Zophonías', 'Zóphanías', 'Zóphonías', 'Þangbrandur', 'Þengill', 'Þeyr', 'Þiðrandi', 'Þiðrik', 'Þinur', 'Þjálfi', 'Þjóðann', 'Þjóðbjörn', 'Þjóðgeir', 'Þjóðleifur', 'Þjóðmar', 'Þjóðólfur', 'Þjóðrekur', 'Þjóðvarður', 'Þjóstar', 'Þjóstólfur', 'Þorberg', 'Þorbergur', 'Þorbjörn', 'Þorbrandur', 'Þorfinnur', 'Þorgarður', 'Þorgautur', 'Þorgeir', 'Þorgestur', 'Þorgils', 'Þorgísl', 'Þorgnýr', 'Þorgrímur', 'Þorkell', 'Þorlaugur', 'Þorlákur', 'Þorleifur', 'Þorleikur', 'Þormar', 'Þormóður', 'Þormundur', 'Þorri', 'Þorsteinn', 'Þorvaldur', 'Þorvar', 'Þorvarður', 'Þór', 'Þórar', 'Þórarinn', 'Þórbergur', 'Þórbjörn', 'Þórður', 'Þórgnýr', 'Þórgrímur', 'Þórhaddur', 'Þórhalli', 'Þórhallur', 'Þórir', 'Þórlaugur', 'Þórleifur', 'Þórlindur', 'Þórmar', 'Þórmundur', 'Þóroddur', 'Þórormur', 'Þórólfur', 'Þórsteinn', 'Þórörn', 'Þrastar', 'Þráinn', 'Þrándur', 'Þróttur', 'Þrúðmar', 'Þrymur', 'Þröstur', 'Þyrnir', 'Ægir', 'Æsir', 'Ævar', 'Ævarr', 'Ögmundur', 'Ögri', 'Ölnir', 'Ölver', 'Ölvir', 'Öndólfur', 'Önundur', 'Örlaugur', 'Örlygur', 'Örn', 'Örnólfur', 'Örvar', 'Össur', 'Öxar'];

    /**
     * @var array<string> Icelandic middle names.
     */
    protected static $middleName = [
        'Aðaldal', 'Aldan', 'Arnberg', 'Arnfjörð', 'Austan', 'Austdal', 'Austfjörð', 'Áss', 'Bakkdal', 'Bakkmann', 'Bald', 'Ben', 'Bergholt', 'Bergland', 'Bíldsfells', 'Bjarg', 'Bjarndal', 'Bjarnfjörð', 'Bláfeld', 'Blómkvist', 'Borgdal', 'Brekkmann', 'Brim', 'Brúnsteð', 'Dalhoff', 'Dan', 'Diljan', 'Ektavon', 'Eldberg', 'Elísberg', 'Elvan', 'Espólín', 'Eyhlíð', 'Eyvík', 'Falk', 'Finndal', 'Fossberg', 'Freydal', 'Friðhólm', 'Giljan', 'Gilsfjörð', 'Gnarr', 'Gnurr', 'Grendal', 'Grindvík', 'Gull', 'Haffjörð', 'Hafnes', 'Hafnfjörð', 'Har', 'Heimdal', 'Heimsberg', 'Helgfell', 'Herberg', 'Hildiberg', 'Hjaltdal', 'Hlíðkvist', 'Hnappdal', 'Hnífsdal', 'Hofland', 'Hofteig', 'Hornfjörð', 'Hólmberg', 'Hrafnan', 'Hrafndal', 'Hraunberg', 'Hreinberg', 'Hreindal', 'Hrútfjörð', 'Hvammdal', 'Hvítfeld', 'Höfðdal', 'Hörðdal', 'Íshólm', 'Júl', 'Kjarrval', 'Knaran', 'Knarran', 'Krossdal', 'Laufkvist', 'Laufland', 'Laugdal', 'Laxfoss', 'Liljan', 'Linddal', 'Línberg', 'Ljós', 'Loðmfjörð', 'Lyngberg', 'Magdal', 'Magg', 'Matt', 'Miðdal', 'Miðvík', 'Mjófjörð', 'Móberg', 'Mýrmann', 'Nesmann', 'Norðland', 'Núpdal', 'Ólfjörð', 'Ósland', 'Ósmann', 'Reginbald', 'Reykfell', 'Reykfjörð', 'Reynholt', 'Salberg', 'Sandhólm', 'Seljan', 'Sigurhólm', 'Skagalín', 'Skíðdal', 'Snæberg', 'Snædahl', 'Sólan', 'Stardal', 'Stein', 'Steinbekk', 'Steinberg', 'Storm', 'Straumberg', 'Svanhild', 'Svarfdal', 'Sædal', 'Val', 'Valagils', 'Vald', 'Varmdal', 'Vatnsfjörð', 'Vattar', 'Vattnes', 'Viðfjörð', 'Vídalín', 'Víking', 'Vopnfjörð', 'Yngling', 'Þor', 'Önfjörð', 'Örbekk', 'Öxdal', 'Öxndal',
    ];

    /**
     * Randomly return an Icelandic middle name.
     *
     * @return string
     */
    public static function middleName()
    {
        return static::randomElement(static::$middleName);
    }

    /**
     * Generate prepared last name for further processing.
     *
     * @return string
     */
    public function lastName()
    {
        $name = static::firstNameMale();

        if (substr($name, -2) === 'ur') {
            $name = substr($name, 0, strlen($name) - 2);
        }

        if (substr($name, -1) !== 's') {
            $name .= 's';
        }

        return $name;
    }

    /**
     * Randomly return an Icelandic last name for a woman.
     *
     * @return string
     */
    public function lastNameMale()
    {
        return $this->lastName() . 'son';
    }

    /**
     * Randomly return an Icelandic last name for a man.
     *
     * @return string
     */
    public function lastNameFemale()
    {
        return $this->lastName() . 'dóttir';
    }

    /**
     * Return a random Icelandic Kennitala (Social Security number).
     *
     * @see http://en.wikipedia.org/wiki/Kennitala
     *
     * @return string
     */
    public static function ssn()
    {
        // random birth date
        $birthdate = DateTime::dateTimeThisCentury();

        // last four buffer
        $lastFour = null;

        // security variable reference
        $ref = '32765432';

        // valid flag
        $valid = false;

        while (!$valid) {
            // make two random numbers
            $rand = static::randomDigit() . static::randomDigit();

            // 8 char string with birth date and two random numbers
            $tmp = $birthdate->format('dmy') . $rand;

            // loop through temp string
            for ($i = 7, $sum = 0; $i >= 0; --$i) {
                // calculate security variable
                $sum += ($tmp[$i] * $ref[$i]);
            }

            // subtract 11 if not 11
            $chk = ($sum % 11 === 0) ? 0 : (11 - ($sum % 11));

            if ($chk < 10) {
                $lastFour = $rand . $chk . substr($birthdate->format('Y'), 1, 1);

                $valid = true;
            }
        }

        return sprintf('%s-%s', $birthdate->format('dmy'), $lastFour);
    }
}
