"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridStyleSelector = exports.startingStyles = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _i18n = require("../i18n");

var _popover = require("../popover");

var _button = require("../button");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var startingStyles = {
  cellPadding: 'm',
  fontSize: 'm',
  border: 'all',
  stripes: false,
  rowHover: 'highlight',
  header: 'shade',
  footer: 'overline',
  stickyFooter: true
};
exports.startingStyles = startingStyles;
var densityStyles = {
  expanded: {
    fontSize: 'l',
    cellPadding: 'l'
  },
  normal: {
    fontSize: 'm',
    cellPadding: 'm'
  },
  compact: {
    fontSize: 's',
    cellPadding: 's'
  }
};

var useDataGridStyleSelector = function useDataGridStyleSelector(initialStyles) {
  // track styles specified by the user at run time
  var _useState = (0, _react.useState)({}),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      userGridStyles = _useState2[0],
      setUserGridStyles = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1]; // These are the available options. They power the gridDensity hook and also the options in the render


  var densityOptions = ['expanded', 'normal', 'compact']; // Normal is the default density

  var _useState5 = (0, _react.useState)(densityOptions[1]),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      gridDensity = _useState6[0],
      _setGridDensity = _useState6[1];

  var setGridDensity = function setGridDensity(density) {
    _setGridDensity(density);

    setUserGridStyles(densityStyles[density]);
  }; // merge the developer-specified styles with any user overrides


  var gridStyles = _objectSpread(_objectSpread({}, initialStyles), userGridStyles);

  var styleSelector = /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, {
    "data-test-subj": "dataGridStyleSelectorPopover",
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    anchorPosition: "downCenter",
    panelPaddingSize: "s",
    panelClassName: "ouiDataGridColumnSelectorPopover",
    button: /*#__PURE__*/_react.default.createElement(_button.OuiButtonEmpty, {
      size: "xs",
      iconType: "tableDensityExpanded",
      className: "ouiDataGrid__controlBtn",
      color: "text",
      "data-test-subj": "dataGridStyleSelectorButton",
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiStyleSelector.buttonText",
      default: "Density"
    }))
  }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    tokens: ['ouiStyleSelector.buttonLegend', 'ouiStyleSelector.labelExpanded', 'ouiStyleSelector.labelNormal', 'ouiStyleSelector.labelCompact'],
    defaults: ['Select the display density for the data grid', 'Expanded density', 'Normal density', 'Compact density']
  }, function (_ref) {
    var _ref2 = (0, _slicedToArray2.default)(_ref, 4),
        buttonLegend = _ref2[0],
        labelExpanded = _ref2[1],
        labelNormal = _ref2[2],
        labelCompact = _ref2[3];

    return /*#__PURE__*/_react.default.createElement(_button.OuiButtonGroup, {
      legend: buttonLegend,
      name: "density",
      className: "oui-displayInlineBlock",
      buttonSize: "compressed",
      options: [{
        id: densityOptions[0],
        label: labelExpanded,
        iconType: 'tableDensityExpanded'
      }, {
        id: densityOptions[1],
        label: labelNormal,
        iconType: 'tableDensityNormal'
      }, {
        id: densityOptions[2],
        label: labelCompact,
        iconType: 'tableDensityCompact'
      }],
      onChange: setGridDensity,
      idSelected: gridDensity,
      isIconOnly: true
    });
  }));

  return [styleSelector, gridStyles];
};

exports.useDataGridStyleSelector = useDataGridStyleSelector;