/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.plexus.CompositeBeanHelper;

public class ObjectWithFieldsConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return !Map.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type) && !Dictionary.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type, false);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
            if (null == value && implType.isInterface() && configuration.getChildCount() == 0) {
                return null;
            }
            Object bean = null;
            try {
                bean = this.instantiateObject(implType);
                if (null == value) {
                    this.processConfiguration(lookup, bean, loader, configuration, evaluator, listener);
                } else {
                    new CompositeBeanHelper(lookup, loader, evaluator, listener).setDefault(bean, value, configuration);
                }
            }
            catch (ComponentConfigurationException e) {
                if (configuration.getChildCount() == 0 && value instanceof String) {
                    bean = this.fromConstructorTakingString(type, (String)value, e);
                }
                throw e;
            }
            return bean;
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Object fromConstructorTakingString(Class<?> type, String value, ComponentConfigurationException precedingException) throws ComponentConfigurationException {
        try {
            try {
                Constructor<?> constructor = type.getConstructor(String.class);
                return constructor.newInstance(value);
            }
            catch (NoSuchMethodException e) {
                if (precedingException != null) {
                    throw precedingException;
                }
                throw e;
            }
        }
        catch (ReflectiveOperationException e) {
            ComponentConfigurationException cce = new ComponentConfigurationException("Cannot create instance of " + type + " with public constructor having a single String argument", (Throwable)e);
            if (precedingException != null) {
                cce.addSuppressed(precedingException);
            }
            throw cce;
        }
    }

    public void processConfiguration(ConverterLookup lookup, Object bean, ClassLoader loader, PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        this.processConfiguration(lookup, bean, loader, configuration, evaluator, null);
    }

    public void processConfiguration(ConverterLookup lookup, Object bean, ClassLoader loader, PlexusConfiguration configuration, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        CompositeBeanHelper helper = new CompositeBeanHelper(lookup, loader, evaluator, listener);
        int size = configuration.getChildCount();
        for (int i = 0; i < size; ++i) {
            Class<?> valueType;
            PlexusConfiguration element = configuration.getChild(i);
            String propertyName = this.fromXML(element.getName());
            try {
                valueType = this.getClassForImplementationHint(null, element, loader);
            }
            catch (ComponentConfigurationException e) {
                valueType = null;
            }
            helper.setProperty(bean, propertyName, valueType, element);
        }
    }
}

