/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"create", "Lorg/jetbrains/kotlin/constant/KClassValue;", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fir-serialization"})
public final class ConstantValueUtilsKt {
    @Nullable
    public static final KClassValue create(@NotNull ConeKotlinType argumentType) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        if (argumentType instanceof ConeErrorType) {
            return null;
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        ConeKotlinType type = argumentType;
        int arrayDimensions = 0;
        while (!ConeBuiltinTypeUtilsKt.isPrimitiveArray(type) && FirTypeUtilsKt.arrayElementType$default(type, false, 1, null) != null) {
            ++arrayDimensions;
        }
        ClassId classId = ConeTypeUtilsKt.getClassId(type);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return new KClassValue(classId2, arrayDimensions);
    }
}

