/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedSupertypeExtendedByOtherSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirQualifiedSupertypeExtendedByOtherSupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirQualifiedSupertypeExtendedByOtherSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedSupertypeExtendedByOtherSupertypeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class FirQualifiedSupertypeExtendedByOtherSupertypeChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirQualifiedSupertypeExtendedByOtherSupertypeChecker INSTANCE = new FirQualifiedSupertypeExtendedByOtherSupertypeChecker();

    private FirQualifiedSupertypeExtendedByOtherSupertypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Object it;
        FirSuperReference firSuperReference;
        FirReference firReference;
        block10: {
            block9: {
                FirSuperReference firSuperReference2;
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                Intrinsics.checkNotNullParameter(expression2, "expression");
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.QualifiedSupertypeMayBeExtendedByOtherSupertype)) {
                    return;
                }
                firReference = expression2.getCalleeReference();
                FirSuperReference firSuperReference3 = firSuperReference2 = firReference instanceof FirSuperReference ? (FirSuperReference)firReference : null;
                if (firSuperReference2 == null) break block9;
                firSuperReference = firSuperReference2;
                it = firSuperReference;
                boolean bl = false;
                FirReference firReference2 = firReference = ReferenceUtilsKt.hadExplicitTypeInSource((FirSuperReference)it) ? firSuperReference : null;
                if (firReference != null) break block10;
            }
            return;
        }
        FirReference superReference = firReference;
        it = FirHelpersKt.toClassLikeSymbol(((FirSuperReference)superReference).getSuperTypeRef(), context2.getSession());
        firSuperReference = it != null ? DeclarationUtilsKt.fullyExpandedClass(it, context2.getSession()) : null;
        FirClassSymbol firClassSymbol = firSuperReference instanceof FirClassSymbol ? (FirClassSymbol)((Object)firSuperReference) : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol explicitType = firClassSymbol;
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return;
        }
        FirClass surroundingType = firClass;
        int count = 0;
        FirClassSymbol candidate2 = null;
        for (FirTypeRef it2 : surroundingType.getSuperTypeRefs()) {
            FirClassSymbol that;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(it2, context2.getSession());
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, context2.getSession()) : null;
            if ((firRegularClassSymbol instanceof FirClassSymbol ? (FirClassSymbol)firRegularClassSymbol : null) == null) continue;
            that = that;
            boolean isSupertype = FirHelpersKt.isSupertypeOf(explicitType, that, context2.getSession());
            if (!Intrinsics.areEqual(explicitType, that) && !isSupertype) continue;
            if (isSupertype) {
                candidate2 = that;
            }
            if (++count < 2) continue;
        }
        if (count >= 2 && candidate2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirSuperReference)superReference).getSuperTypeRef().getSource(), FirErrors.INSTANCE.getQUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE(), candidate2, null, 16, null);
        }
    }
}

