/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;

public class CollectionConverter
extends AbstractCollectionConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = CollectionConverter.findElementType(typeArguments);
            if (value == null) {
                elements = this.fromChildren(lookup, configuration, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof String) {
                PlexusConfiguration xml = CollectionConverter.csvToXml(configuration, (String)value);
                elements = this.fromChildren(lookup, xml, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof Object[]) {
                elements = this.instantiateCollection(configuration, type, loader);
                Collections.addAll(elements, (Object[])value);
            } else {
                this.failIfNotTypeCompatible(value, type, configuration);
                elements = Collections.emptyList();
            }
            return elements;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into collection", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            if (Set.class.isAssignableFrom(type)) {
                if (SortedSet.class.isAssignableFrom(type)) {
                    return new TreeSet<Object>();
                }
                return new HashSet<Object>();
            }
            return new ArrayList<Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Collection)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments) {
        if (typeArguments != null && typeArguments.length > 0 && typeArguments[0] instanceof Class) {
            return (Class)typeArguments[0];
        }
        return Object.class;
    }
}

