/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IDeref;
import clojure.lang.IDrop;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Sequential;

public class Repeat
extends ASeq
implements IReduce,
IDrop {
    private static final long serialVersionUID = -5140377547192202551L;
    private static final long INFINITE = -1L;
    private final long count;
    private final Object val;
    private volatile ISeq _next;

    private Repeat(long count2, Object val2) {
        this.count = count2;
        this.val = val2;
    }

    private Repeat(IPersistentMap meta, long count2, Object val2) {
        super(meta);
        this.count = count2;
        this.val = val2;
    }

    public static Repeat create(Object val2) {
        return new Repeat(-1L, val2);
    }

    public static ISeq create(long count2, Object val2) {
        if (count2 <= 0L) {
            return PersistentList.EMPTY;
        }
        return new Repeat(count2, val2);
    }

    @Override
    public Object first() {
        return this.val;
    }

    @Override
    public ISeq next() {
        if (this._next == null) {
            if (this.count > 1L) {
                this._next = new Repeat(this.count - 1L, this.val);
            } else if (this.count == -1L) {
                this._next = this;
            }
        }
        return this._next;
    }

    @Override
    public Repeat withMeta(IPersistentMap meta) {
        if (this.meta() == meta) {
            return this;
        }
        return new Repeat(meta, this.count, this.val);
    }

    @Override
    public Object reduce(IFn f) {
        Object ret = this.val;
        if (this.count == -1L) {
            while (!RT.isReduced(ret = f.invoke(ret, this.val))) {
            }
            return ((IDeref)ret).deref();
        }
        for (long i = 1L; i < this.count; ++i) {
            if (!RT.isReduced(ret = f.invoke(ret, this.val))) continue;
            return ((IDeref)ret).deref();
        }
        return ret;
    }

    @Override
    public Object reduce(IFn f, Object start2) {
        Object ret = start2;
        if (this.count == -1L) {
            while (!RT.isReduced(ret = f.invoke(ret, this.val))) {
            }
            return ((IDeref)ret).deref();
        }
        for (long i = 0L; i < this.count; ++i) {
            if (!RT.isReduced(ret = f.invoke(ret, this.val))) continue;
            return ((IDeref)ret).deref();
        }
        return ret;
    }

    @Override
    public Sequential drop(int n) {
        if (this.count == -1L) {
            return this;
        }
        long droppedCount = this.count - (long)n;
        if (droppedCount > 0L) {
            return new Repeat(droppedCount, this.val);
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (this.count <= 0L) {
            throw new UnsupportedOperationException();
        }
        return super.hashCode();
    }

    @Override
    public int hasheq() {
        if (this.count <= 0L) {
            throw new UnsupportedOperationException();
        }
        return super.hasheq();
    }
}

