/***************************************************************************
                          setiloc.h  -  description
                             -------------------
    begin                : Wed Oct 27 1999
    copyright            : (C) 1999-2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETILOC_H
#define SETILOC_H

#include <kprocess.h>

#include <qstring.h>
#include <qcolor.h>
#include <qpixmap.h>

#include "seticontainer.h"

class KIconLoader;
class QListView;
class QListViewItem;

struct LocSettings {
                   QString description;
                   QString directory;
                   QColor  color;
                   QString arguments;
                   bool    startSeti;
                   bool    stopSeti;
                   bool    log;
                   bool    redirectLog;
                   QString logDirectory;
                   bool    stopAfterProcess;
                   bool    stopAfterSend;
                   bool    email;
                   bool    graphics;
                   };

class SetiLoc : public SetiContainer
{
Q_OBJECT

public:
	enum LocListView {AnalysisList, DataInfoList, UserInfoList};
	/** the constructor */
	SetiLoc(const QString& dir, const QString& loc = "", QColor col = QColor::QColor());
	/** the destructor */
	~SetiLoc();
	/** Sets all the options in the location settings structure.*/
	void setOptions(const LocSettings& ls);
	/** Returns the options. */
	LocSettings options() const {return(sets);}
  /** Does a refresh of all list view items. */
  void updateListViews();
  /**
   * Adds a QListView item to the list specified by list and lv.
   * @param list an integer defining the list to which the item shall be added.
   * Can be AnalysisList, DataInfoList, or UserInfoList
   * @param lv pointer to the QListView widget
   * @return a pointer to new ListView item
   */
  QListViewItem* addItem(int list, QListView *lv);
  /** Removes the QListView item from the list specified by list.
	 * @param list Can be AnalysisList, DataInfoList, or UserInfoList.
	 */
  void removeItem(int list);
	/**
	 * Removes all ListView items from the analysis list, data info list and
	 * user info list. Items are deleted.
	 */
	void removeAllItems();
	/** Returns the list view item of @e list. */
  QListViewItem* item(int list) const {return listitem[list];}
  /** Returns the location identifier string. */
  QString description() const {return sets.description;}
  /** Returns the location's color. */
  QColor color() const {return sets.color;}
  /** Returns the location's start-up flag. */
  bool optionStartSeti() const {return sets.startSeti;}
  /** Returns the location's start-up flag. */
  bool optionStopSeti() const {return sets.stopSeti;}
  /** Sets the timestamp of the last logged WU. */
  void setTimestamp(const QString& ts) {sresult_timestamp = ts;}
  /** Returns the timestamp of the last logged WU. */
  QString timestamp() const {return sresult_timestamp;}
  /** Sets a flag whether the Gaussian window is visible. */
  enum GraphIds {GaussianGraph, PulseGraph, TripletGraph};
  void setGraphVisible(int id, bool visible, QWidget* wid=0)
  	{
  	graphvsbl[id] = visible;
  	graphwidget[id] = (QWidget*)wid;
  	}
  /** Tells you whether the Gaussian window is visible. */
  bool isGraphVisible(int id) const {return graphvsbl[id];}
  /** Returns a pointer to the Gaussian widget. */
  QWidget* graphWidget(int id) const {return graphwidget[id];}
  /**
   * Starts the SETI@home client.
   * @return true if started successfully, otherwise false
   */
  bool startClient();
  /**
   * Stops the SETI@home client.
   * @return 0 if stopped successfully, otherwise -1
   */
  int stopClient();
  /** Returns the log directory in a string. */
  QString logDirectory();

protected: //methods
  void checkWUStatus();
  /** Writes all important work unit results to a file named SETILog.csv */
  void logWorkUnit();
  /** constructs a string from readEntry  */
  QString constructEntry(const QString& entry, int type);
  /** Logs the signals found in the result file. */
  void logResults();

protected slots:
  /** Refreshes the timing entries in the Analysis list */
  void slotUpdateAnalysisTimeData();
  /** Refreshes the spike entry in the Analysis list and displays
    * a record message if necessary.
    *
    * @param newspike A SpikeScore structure with the new spike data.
    */
  void slotUpdateAnalysisSpikeData(SpikeScore newspike);
  /** Refreshes the gaussian entry in the Analysis list and displays
    * a record message if necessary.
    *
    * @param newgaussian A GaussianScore structure with the new gaussian data.
    */
  void slotUpdateAnalysisGaussianData(GaussianScore newgaussian);
  /** Refreshes the pulse entry in the Analysis list and displays
    * a record message if necessary.
    *
    * @param newpulse A PulseScore structure with the new pulse data.
    */
  void slotUpdateAnalysisPulseData(PulseScore newpulse);
  /** Refreshes the triplet entry in the Analysis list and displays
    * a record message if necessary.
    *
    * @param newtriplet A TripletScore structure with the new triplet data.
    */
  void slotUpdateAnalysisTripletData(TripletScore newtriplet);
  /** Refreshes the wu entries in the Data Info list.
    */
  void slotUpdateWorkUnitData();
  /** Refreshes the user entries in the User Info list.
    */
  void slotUpdateUserInfoData();
  /** Displays the status icon in the Analysis list. */
  void slotShowNewState(int state, int loadsize);
  /** Initializes the WUScore structure holding the maximum signals of the
    * work unit. */
  void slotInitMaxScore(WorkUnitData wud);
	
private:
  /** The settings for this location */
  LocSettings sets;
	/** Time stamp of result file; prevents multiple logging. */
 	QString        sresult_timestamp;
	QListViewItem* listitem[3];
	KIconLoader*   statusIcons;
	QPixmap        status_icon[4];
	/** Controls the SETI@home client */
	KProcess       client;
	// for analysis list
	WUScore        mymax;
	bool           graphvsbl[3];
	QWidget*       graphwidget[3];

signals:
  /** Just the same as SetiContainer's newWorkUnit signal, but with
    * extended parameters. */
  void newWorkUnit(WorkUnitData wud, const QString& locname,
                   const QColor& col);
  /** This signal is emitted when a work unit has been logged. */
  void workUnitLogged(SetiLoc* loc);
};

#endif
