/***************************************************************************
                          poplistview.cpp  -  description
                             -------------------
    begin                : Thu Oct 28 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qpainter.h>
#include <qframe.h>
#include <qpoint.h>

#include "poplistview.h"

/*------------------------------------------------------------------------ */
popListView::popListView(QWidget *parent, const char *name)
            :QListView(parent,name)
{
setAllColumnsShowFocus(TRUE);
popup = new KPopupMenu(this);
triggerUpdate();

lastRootItem = 0;
lastChildItem = 0;

setFrameStyle( QFrame::Box | QFrame::Sunken );
setLineWidth( 1 );
setMidLineWidth( 0 );

connect(this, SIGNAL(mouseButtonClicked(int, QListViewItem*,
                                        const QPoint&, int)),
              SLOT(slotMouseButtonClicked(int, QListViewItem*,
                                          const QPoint&, int)));

}

/*------------------------------------------------------------------------ */
popListView::~popListView()
{
}

/*------------------------------------------------------------------------ */
QListViewItem *popListView::insertRootItem(const QString& aName, QPixmap* icon)
{
QListViewItem *item;

// Make sure the entry gets added AFTER the last entry.
if( lastRootItem != 0 )
  {
  item =  new QListViewItem( this, lastRootItem );
  item->setText( 0, aName );
  }
else
  item = new QListViewItem( this, aName );

if(icon != 0) item->setPixmap(0, *icon );

// Save this as the last entry.
lastRootItem = item;

return item;
}

/*------------------------------------------------------------------------ */
QListViewItem *popListView::insertChildItem(const QString& aName,
                                            QPixmap* icon,
                                            QListViewItem *parent)
{
QListViewItem *item;
	
if(parent != 0)
  item = new QListViewItem( parent, lastChildItem, aName );
else
  item = new QListViewItem( lastRootItem, lastChildItem, aName );
if(icon != 0) item->setPixmap( 0, *icon );

// Save this as the last entry.
lastChildItem = item;

return item;
}

/*------------------------------------------------------------------------ */
void popListView::clear()
{
lastRootItem = 0;
lastChildItem = 0;
QListView::clear();
}
	
/*------------------------------------------------------------------------ */
int popListView::insertPopupItem(const QString& name, int id, int index)
{
return(popup->insertItem(name, id, index));
}

/*------------------------------------------------------------------------ */
int popListView::insertPopupItem(const QString& name, QPopupMenu* pop,
                                 int id, int index)
{
return(popup->insertItem(name, pop, id, index));
}
	
/*------------------------------------------------------------------------ */
void popListView::slotMouseButtonClicked(int but, QListViewItem* it,
                                         const QPoint& pos, int col)
{
if(it)
  {
  setSelected(it, true);
  }
else
  {
  if(pstyle == ShowAnywhere)
    {
    setSelected(currentItem(), false);
    emit selectionChanged(0);
    }
  }
if(but == Qt::RightButton && popup->count() > 0)
  {
  if(pstyle == ShowAnywhere || (it && pstyle == OverItem))
    popup->popup(QCursor::pos());
  }
}
		
/*------------------------------------------------------------------------ */
KPopupMenu *popListView::popupMenu()
{
return(popup);
}	

/*------------------------------------------------------------------------ */
void popListView::setPopupStyle(PopupStyle p)
{
pstyle = p;
}

/*------------------------------------------------------------------------ */
popListView::PopupStyle popListView::popupStyle()
{
return pstyle;
}

#include "poplistview.moc"

