/***************************************************************************
                          gaussianplot.h  -  description
                             -------------------
    begin                : Tue Mar 28 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAUSSIANPLOT_H
#define GAUSSIANPLOT_H

#include "setigraph.h"

/**
  *@author Gordon Machel
  */

class GaussianPlot : public SetiGraph
{
   Q_OBJECT

public:
	GaussianPlot(SetiLoc* loc, QWidget* parent=0, const char* name=0);
	~GaussianPlot();

protected: // Protected attributes
  /** Stores the S@h location. */
  SetiLoc* location;
  /** This array stores the fitted gaussian data. */
  QArray<double> fitData;
  /** A pointer to a structure containing the top gaussian. */
  GaussianScore gaussian;

protected: // Protected methods
  /** Calculates Gaussian data according to fit parameters stored in top.*/
  void calculateFitData();
  /** Repaints this widget. */
  virtual void paintEvent(QPaintEvent* e);

protected slots: // Protected slots
  /** Updates the widget with new Gaussian data. */
  void showNewGaussianData(GaussianScore score);
};

#endif
