/***************************************************************************
                          analysis.h  -  description
                             -------------------
    begin                : Tue Oct 26 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ANALYSIS_H
#define ANALYSIS_H

#include <qwidget.h>
#include <poplistview.h>

class QPushButton;
class QPopupMenu;
class QComboBox;
class QLabel;
class KIconLoader;
class SetiLoc;

/**
  *@author Gordon Machel
  */
class AnalysisListViewItem : public QListViewItem
{
public:
	AnalysisListViewItem(QListView* parent);
	~AnalysisListViewItem();
  /**  */
  virtual QString key(int column, bool ascending) const;

protected:
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);
};

class Analysis : public QWidget
{
Q_OBJECT

struct TableColumn	{
										QString text;
										int     width;
										int     alignment;
										};

public:
	Analysis(QWidget *parent=0, const char *name=0);
	~Analysis();
  /** Adds or removes list view items depending on their state. */
  void updateAnalysisList();
  /**
   * Returns the currently selected entry of the Analysis list.
   * @return The selected entry or zero.
   */
  QListViewItem* selectedItem();

public slots:	
	void refreshList();

protected: 
	void resizeEvent(QResizeEvent* e);
	void timerEvent(QTimerEvent* e);
	popListView* QListView_1;
	QPushButton* QPushButton_1;
	QPushButton* Homepage;
	QPushButton* Help;
	QLabel *ComboLabel;
	QComboBox *StatusFilter;
  /**  */
  bool sortingorder;
  KIconLoader* icons;
  enum soIds {soGaussian, soPulse, soTriplet};
  QPopupMenu* showOptions;

protected slots: // Protected slots
  /**  */
  void openBrowser();
  /** Changes the StatusFilterValue to the selected one. */
  void modifyStatusFilter(int sel);
  /** Invokes the Help window. */
  void slotShowHelp();
  void toggleSorting(int column);
  void handleNewSelection(QListViewItem* it);
  /**  */
  void handleShowPopupCommand(int id);
  /** No descriptions */
  void slotAskForLocation();

private:
	enum popupIds {PopupAdd, PopupEdit, PopupDelete, PopupStart, PopupStop, PopupShow};
	  	
private slots:
	void handlePopupCommand(int id);
	void checkPopupStatus();

signals:
	void listModified();
	void selectionChanged(SetiLoc*);

};

#endif




















