/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGIMPORTEXPORTPLUGIN_H
#define SKGIMPORTEXPORTPLUGIN_H
/** @file
 * This file is Skrooge plugin for import and export operation.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skginterfaceplugin.h"
#include "skgimportexportmanager.h"
#include "ui_skgimportexportpluginwidget_pref.h"

class QAction;
class SKGDocumentBank;

/**
 * This file is Skrooge plugin for import and export operation
 */
class SKGImportExportPlugin : public SKGInterfacePlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGInterfacePlugin)

public:
    /**
     * Default Constructor
     */
    explicit SKGImportExportPlugin(QWidget* iWidget, QObject* iParent, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGImportExportPlugin();

    /**
     * Called to initialise the plugin
     * @param iDocument the main document
     * @param iArgument the arguments
     * @return true if the plugin is compatible with the document
     */
    virtual bool setupActions(SKGDocument* iDocument, const QStringList& iArgument) override;

    /**
     * This function is called when the application is launched again with new arguments
     * @param iArgument the arguments
     * @return true if the arguments have been processed
     */
    virtual bool processArguments(const QStringList& iArgument) override;

    /**
     * Must be modified to refresh widgets after a modification.
     */
    virtual void refresh() override;

    /**
     * The preference widget of the plugin.
     * @return The preference widget of the plugin
     */
    virtual QWidget* getPreferenceWidget() override;

    /**
     * The preference skeleton of the plugin.
     * @return The preference skeleton of the plugin
     */
    virtual KConfigSkeleton* getPreferenceSkeleton() override;

    /**
     * The title of the plugin.
     * @return The title of the plugin
     */
    virtual QString title() const override;

    /**
     * The icon of the plugin.
     * @return The icon of the plugin
     */
    virtual QString icon() const override;

    /**
     * The toolTip of the plugin.
     * @return The toolTip of the plugin
     */
    virtual QString toolTip() const override;

    /**
     * Must be implemented to set the position of the plugin.
     * @return integer value between 0 and 999 (default = 999)
     */
    virtual int getOrder() const override;

    /**
     * The tips list of the plugin.
     * @return The tips list of the plugin
     */
    virtual QStringList tips() const override;


    /**
     * The sub plugins services types list of the plugin.
     * This will be used to display authors in the "About" of the application
     * @return The sub plugins list of the plugin
     */
    virtual QStringList subPlugins() const override;

    /**
     * The advice list of the plugin.
     * @return The advice list of the plugin
     */
    virtual SKGAdviceList advice(const QStringList& iIgnoredAdvice) override;

    /**
     * Must be implemented to execute the automatic correction for the advice.
     * @param iAdviceIdentifier the identifier of the advice
     * @param iSolution the identifier of the possible solution
     * @return an object managing the error. MUST return ERR_NOTIMPL if iAdviceIdentifier is not known
     *   @see SKGError
     */
    virtual SKGError executeAdviceCorrection(const QString& iAdviceIdentifier, int iSolution) override;

Q_SIGNALS:
    /**
     * Request to import a file
     * @param iFile the file
     */
    void importFileName(const QString& iFile);

private Q_SLOTS:
    void import(const QString& iFile);
    void import(const QList<QUrl>& iFiles = QList<QUrl>(), int mode = 1);  // 1=operations, 2=unit, 3=rules
    SKGError importbackends();
    void exportFile();
    void findTransfers();
    void anonymize();
    void cleanBanks();
    void swithvalidationImportedOperations();
    void validateAllOperations();
    void mergeImportedOperation();
    void onInstall();
private:
    Q_DISABLE_COPY(SKGImportExportPlugin)
    void openLastModifiedIfSetting();

    SKGDocumentBank* m_currentBankDocument;

    QString m_docUniqueIdentifier;

    Ui::skgimportexportplugin_pref ui;
    bool m_install;
};

#endif  // SKGDEBUGPLUGIN_H
