/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGTABPAGE_H
#define SKGTABPAGE_H
/** @file
 * This file is a class managing widget.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbasegui_export.h"
#include "skgwidget.h"

#include <QWidget>
#include <QList>

#include <kglobal.h>

class SKGMainPanel;
class SKGTreeView;

/**
 * This file is a tab widget used by plugins
 */
class SKGBASEGUI_EXPORT SKGTabPage : public SKGWidget
{
    Q_OBJECT

public:
    /**
     * Describe a history item
     */
    struct SKGPageHistoryItem {
        QString plugin;     /**< The plugin name */
        QString name;       /**< The name */
        QString state;      /**< The state */
        QString icon;       /**< The icon */
        QString bookmarkID;     /**< The bookmarkID */
    } ;

    /**
     * Default Constructor
     */
    explicit SKGTabPage(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGTabPage();

    /**
     * Set the bookmark id
     * @param iId bookmark id
     */
    virtual void setBookmarkID(const QString& iId);

    /**
     * Get the bookmark id
     * @return bookmark id
     */
    virtual QString getBookmarkID();

    /**
     * To know if an overwrite is needed
     */
    virtual bool isOverwriteNeeded();

    /**
     * Overwrite bookmark if page is opened from a bookmark
     * Overwrite context if page is opened from a context
     * @param iNeedUserConfirmation to display a confirmation panel
     */
    virtual void overwrite(bool iNeedUserConfirmation = true);

    /**
     * Get previous pages
     * @return the list
     */
    virtual QList<SKGTabPage::SKGPageHistoryItem> getPreviousPages();

    /**
     * Set previous pages
     * @param iPages the list
     */
    virtual void setPreviousPages(const QList<SKGTabPage::SKGPageHistoryItem>& iPages);

    /**
     * Get next pages
     * @return the list
     */
    virtual QList<SKGTabPage::SKGPageHistoryItem> getNextPages();

    /**
     * Set next pages
     * @param iPages the list
     */
    virtual void setNextPages(const QList<SKGTabPage::SKGPageHistoryItem>& iPages);

    /**
     * To know if this page contains an editor. MUST BE OVERWRITTEN
     * @return the editor state
     */
    virtual bool isEditor();

    /**
     * To activate the editor by setting focus on right widget. MUST BE OVERWRITTEN
     */
    virtual void activateEditor();

    /**
     * Get the zoomable widget.
     * The default implementation returns the main widget.
     * @return the zoomable widget.
     */
    virtual QWidget* zoomableWidget() const;

    /**
     * Get the printable widgets.
     * The default implementation returns the main widget.
     * @return the printable widgets.
     */
    virtual QList<QWidget*> printableWidgets() const;

    /**
     * To know if this page is zoomable. MUST BE OVERWRITTEN
     * @return true or false
     */
    virtual bool isZoomable() const;

    /**
     * Get the zoom position. MUST BE OVERWRITTEN
     * @return the position (-10<=value<=10)
     */
    virtual int zoomPosition() const;

    /**
     * Set the zoom position. MUST BE OVERWRITTEN
     * @param iValue the position (-10<=value<=10)
     */
    virtual void setZoomPosition(int iValue);

    /**
     * Get the tab page of a widget
     * @param iWidget the widget
     * @return the parent tab page or NULL
     */
    static SKGTabPage* parentTabPage(QWidget* iWidget);

    /**
     * Get the pin status
     * @return the pin status
     */
    virtual bool isPin() const;

    /**
     * Set the pin status
     * @param iPin the pin status
     */
    virtual void setPin(bool iPin);

Q_SIGNALS:
    /**
     * This signal must be launched when the selection is modified
     */
    void selectionChanged();

public Q_SLOTS:
    /**
     * Closes this widget
     * @param iForce to close pinned pages too
     * @return true if the widget was closed; otherwise returns false.
     */
    virtual bool close(bool iForce = false);

private:
    Q_DISABLE_COPY(SKGTabPage)

    QString       m_bookmarkID;
    QList<SKGTabPage::SKGPageHistoryItem> m_previousPages;
    QList<SKGTabPage::SKGPageHistoryItem> m_nextPages;
    int m_fontOriginalPointSize;
    bool m_pin;
};
/**
 * Declare the class
 */
Q_DECLARE_TYPEINFO(SKGTabPage::SKGPageHistoryItem, Q_PRIMITIVE_TYPE);

#endif // SKGTABPAGE_H
