/* This file is part of the KDE project
    SPDX-FileCopyrightText: 2001 Carsten Pfeiffer <pfeiffer@kde.org>

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef SETTINGS_PLUGIN
#define SETTINGS_PLUGIN

#include <kparts_version.h>
#include <kparts/plugin.h>

class KConfig;

class SettingsPlugin : public KParts::Plugin
{
    Q_OBJECT
public:
    SettingsPlugin(QObject *parent,
#if KPARTS_VERSION >= QT_VERSION_CHECK(5, 77, 0)
                   const KPluginMetaData& metaData,
#endif
                   const QVariantList &);
    ~SettingsPlugin() override;

private:
    bool cookiesEnabled(const QString &url);
    void updateIOSlaves();

private slots:
    void toggleJavascript(bool checked);
    void toggleJava(bool checked);
    void toggleCookies(bool checked);
    void togglePlugins(bool checked);
    void toggleImageLoading(bool checked);
    void toggleProxy(bool checked);
    void toggleCache(bool checked);
    void cachePolicyChanged(int p);

    void showPopup();

private:
    KConfig *mConfig;
};

#endif // SETTINGS_PLUGIN
