// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: kwatchconf.h,v 1.4 2001/09/12 15:56:51 mj Exp $
 *
 * Configuration parameters of the application
 *
 *****************************************************************************
 * Copyright (C) 2000
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#ifndef KWATCHCONF_H
#define KWATCHCONF_H

#include <qrect.h>
#include <qstringlist.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstring.h>

#include <kconfig.h>



/*
 * Configuration class
 */
class kwatchConf 
{
public:
    // slightly violating the KDE coding rules, but I don't want duplicated m_
    QRect       geometry;
    QStringList logfiles;
    QFont       font;
    QColor      fg;
    QColor      bg;
    QString     logdir;
    int         maxlines;
    int         bufsize;
    bool        showmenu;
    bool	enableCall;
    bool	enableLog;
    QString	soundCall;
    QString	soundLog;
    
public:
    // read/save config
    void read(KConfig *);
    void save(KConfig *);
    
};



/*
 * Defaults
 */
#define DEFAULT_GEOMETRY	QRect(0, 0, 300, 100)
#undef  DEFAULT_LOGFILES
#define DEFAULT_FONT		QFont("Helvetica", 12)
#define DEFAULT_FG		QColor("black")
#define DEFAULT_BG		QColor("white")
#define DEFAULT_LOGDIR		"/var/log"
#define DEFAULT_MAXLINES	500
#define DEFAULT_BUFSIZE		1024
#define DEFAULT_SHOWMENU	true
#define DEFAULT_ENABLECALL	true
#define DEFAULT_ENABLELOG	true


#endif /**KWATCHCONF_H**/
