/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sam Okt 20 14:11:56 CEST 2001
    copyright            : (C) 2001 by Jens Schulz
    email                : jschulz-lcs@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwappen.h"

Kwappen* topW;
Highscore *highS;
HighscoreEdit *highE;
Heraldry *herald;

QString data_path;
QString home_path;

static const char *description =
	I18N_NOOP("Kwappen is a high addictive board game");

int main(int argc, char *argv[])
{
  KAboutData about("kwappen", "KWappen",
  VERSION, description, KAboutData::License_GPL,
                   "Copyright 2002 Jens Schulz",
                   "http://www.lcs-chemie.de",
                   "jschulz-lcs@t-online.de",
                   "Jens Schulz");
   about.addAuthor("Jens Schulz",
                  "Idea and Programming",
                  "jschulz-lcs@t-online.de",
                  "http://www.lcs-chemie.de");
  about.addCredit("Linux User Group Computer Club Elmshorn e.V.","for beta testing",
                  "cce@gmx.de",
                  "http://www.cceev.de");
  KCmdLineArgs::init(argc, argv, &about);

  KApplication app;
  KStandardDirs kdehome;

  KGlobal::dirs()->addResourceType("pictures", KStandardDirs::kde_default("data") + "kwappen/pictures/");
  data_path = KGlobal::dirs()->findResourceDir("pictures", "wappen.png");
  home_path = kdehome.localkdedir()+"share/apps/";

  KAction * quitAction;

  topW = new Kwappen();
  app.setMainWidget(topW);
  topW->topWA(&app);  topW->show();
  topW->set_random();
  highS = new Highscore(topW);
  highE = new HighscoreEdit(topW);
  herald = new Heraldry(topW);
  quitAction = KStdAction::quit(&app, SLOT(quit()));
  return app.exec();
}
