#include <kiconloader.h>
#include <qobjectlist.h>
#include <qstylesheet.h>
#include <qwhatsthis.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <klocale.h>
#include <kcursor.h>
#include <stdio.h>
#include <kapp.h>
#include "rogue/rogue.h"
#include "rogue/dun.h"
#include "krogueqh.h"
#include "roguec.h"
#include "barids.h"

#define ITEM(x) (tl->getWidget(x))

//KRQHEvFilter evfilter;

void krwtSetToolBar(KToolBar *tl)
{
  QStyleSheetItem *ssi=new QStyleSheetItem(QStyleSheet::defaultSheet(), "m");
  ssi->setMargin(QStyleSheetItem::MarginLeft, 15);
  ssi->setDisplayMode(QStyleSheetItem::DisplayBlock);
  QWhatsThis::add(ITEM(BARID_FILE_OPEN), i18n("<b>Restore</b><br><br>\n"
      "Restore a games previously saved to disk.\n"
      "The savegame file will be deleted afterward.\n"
      "You cannot modify it, copy or try to restore\n"
      "someone else's file."));
  QWhatsThis::add(ITEM(BARID_FILE_SAVE), i18n("<b>Save</b><br><br>\n"
      "Save the game to disk. To restore it use the\n"
      "restore button (on the left). You will be able\n"
      "to restore it only once. You cannot modify it\n"
      "or copy."));
  QWhatsThis::add(ITEM(BARID_INVENTORY), i18n("<b>Inventory</b><br><br>\n"
      "Shows your inventory (i.e. all the objects that\n"
      "you have). You can click on an item with the right\n"
      "mouse button to obtain a popup menu."));
  QWhatsThis::add(ITEM(BARID_EAT), i18n("<b>Eat</b><br><br>\n"
      "Eat some food. You will know when you become\n"
      "hungry, weak or fainting of hunger - a message\n"
      "will appear and a note will be visible on the\n"
      "status bar (<a href=food.html>more...</a>)"));
  QWhatsThis::add(ITEM(BARID_QUAFF), i18n("<b>Quaff</b><br><br>"
      "Quaff a magic potion found in the Dungeons"
      " (<a href=potion.html>more...</a>)"));
  QWhatsThis::add(ITEM(BARID_READ), i18n("<b>Read</b><br><br>\n"
      "Read a magic scroll found in the Dungeons"
      " (<a href=scroll.html>more...</a>)"));
  QWhatsThis::add(ITEM(BARID_ZAP), i18n("<b>Zap</b><br><br>\n"
      "Zap a wand or staff (i.e. use its magic power\n"
      "against a monster). To zap it you should be\n"
      "on the same line as the monster. Each wand\n"
      "and staff have a limited number of bolts"
      " (<a href=wand.html>more...</a>)"));
  QWhatsThis::add(ITEM(BARID_WIELD), i18n("<b>Wield</b><br><br>\n"
      "Wield a weapon (i.e. have it ready to use in\n"
      "hand). Usually you should wield a mace,\n"
      "long sword or two-handed sword. If you throw\n"
      "arrows you can wield a short bow before. If you\n"
      "throw darts, daggers or shurikens you can wield\n"
      "them to cause more damage"
      " (<a href=weapon.html>more...</a>)"));
  QWhatsThis::add(ITEM(BARID_THROW), i18n("<b>Throw</b><br><br>\n"
      "Throw a weapon on a monster. That can allow\n"
      "you to kill a monster without being involved\n"
      "in hand-to-hand combat. To cause more damage\n"
      "while throwing darts, daggers and shurikens\n"
      "you can wield them. If you throw arrows you\n"
      "can wield a bow"
      " (<a href=weapon.html>more...</a>)"));
  QWhatsThis::add(ITEM(BARID_DROP), i18n("<b>Drop</b><br><br>\n"
      "Drop an item on the floor. You cannot do it\n"
      "if an item is already on the floor at that\n"
      "place. You should drop useless things as\n"
      "your pack has a limited capacity"));
  QWhatsThis::add(ITEM(BARID_DOWNSTAIR), i18n("<b>Downstair</b><br><br>\n"
      "Go to the next level. This button is enabled if\n"
      "you are on the stairs. On the next level you will\n"
      "find new items, more gold but also more dangerous\n"
      "monsters"));
  QWhatsThis::add(ITEM(BARID_UPSTAIR), i18n("<b>Upstair</b><br><br>\n"
      "Go to the previous level. You can do that only if\n"
      "you have the Amulet of Yendor (which is hidden on\n"
      "the 26th level or below)"));
  QWhatsThis::add(ITEM(BARID_REST), i18n("<b>Rest</b><br><br>\n"
      "Skip a move. You can hold it if you want to rest\n"
      "for some time or push it once if you want to rest\n"
      "for one move"));
  QWhatsThis::add(ITEM(BARID_SEARCH), i18n("<b>Search</b><br><br>\n"
      "Look for a secret passage or trap. To search\n"
      "you should press this button and hold it for\n"
      "some time. Use it near the walls and on corridors\n"
      "ends. It's equivalent to the 's' key "
      " (<a href=hidden.html>more...</a>)"));
  krwtSetTlTakeOff(tl);
  krwtSetTlLPutOn(tl);
  krwtSetTlRPutOn(tl);
  QWhatsThis::add(tl, i18n("<b>Toolbar</b><br><br>\n"
      "Select a button to get help on it"));
}

void krwtSetTlTakeOff(KToolBar *tl)
{
  QWhatsThis::add(ITEM(BARID_ARMOR), i18n("<b>Take off</b><br><br>\n"
      "Take off your current armor. You won't\n"
      "be able to do that if your armor is cursed.\n"
      "You should do this first if you want to\n"
      "wear a new armor"
      " (<a href=armor.html>more...</a>)"));
}

void krwtSetTlWear(KToolBar *tl)
{
  QWhatsThis::add(ITEM(BARID_ARMOR), i18n("<b>Wear</b><br><br>\n"
      "You can use this button to wear a\n"
      "new armor"
      " (<a href=armor.html>more...</a>)"));
}

void krwtSetTlLPutOn(KToolBar *tl)
{
  QWhatsThis::add(ITEM(BARID_LEFTRING), i18n("<b>Put on a ring</b><br><br>\n"
      "Put on a magic ring on the left hand"
      " (<a href=ring.html>more...</a>)"));
}

void krwtSetTlRPutOn(KToolBar *tl)
{
  QWhatsThis::add(ITEM(BARID_RIGHTRING), i18n("<b>Put on a ring</b><br><br>\n"
      "Put on a magic ring on the right hand"
      " (<a href=ring.html>more...</a>)"));
}

void krwtSetTlLRemove(KToolBar *tl)
{
  QWhatsThis::add(ITEM(BARID_LEFTRING), i18n("<b>Remove the ring</b><br><br>\n"
      "Remove the ring from the left hand"
      " (<a href=ring.html>more...</a>)"));
}

void krwtSetTlRRemove(KToolBar *tl)
{
  QWhatsThis::add(ITEM(BARID_RIGHTRING), i18n("<b>Remove the ring</b><br><br>\n"
      "Remove the ring from the right hand"
      " (<a href=ring.html>more...</a>)"));
}

void krwtRemoveTl(KToolBar *tl, int item)
{
  QWhatsThis::remove(ITEM(item));
}

#undef ITEM

void krwtSetMoreButton(QWidget *more)
{
  QWhatsThis::add(more, i18n("<b>The more button</b><br><br>\n"
      "This button is displayed if more then\n"
      "one message has to be displayed in\n"
      "one move. To see the next message\n"
      "press Space or Return."));
}

void krwtSetMsgBar(QWidget *w)
{
  QWhatsThis::add(w, i18n("<b>The message bar</b><br><br>\n"
      "All the game messages are displayed here.\n"
      "If the message is in <b>bold</b> it is a current\n"
      "message. If it is normal it's an old message."));
}

class KHungryWhatsThis:public QWhatsThis
{
public:
  KHungryWhatsThis(QWidget *w):QWhatsThis(w) {}
  ~KHungryWhatsThis() {}
  QString text(const QPoint &) {return krwtGetHungryInfo();}
};

//#define ITEM(x) (st->item(x)->getItem())
#define FIRST_ITEM (QWidget *)(objl.toFirst())
#define NEXT_ITEM (QWidget *)(++objl)

void krwtSetStatusBar(KStatusBar *st)
{
  QListIterator<QObject> objl(*st->children());
  QWhatsThis::add(FIRST_ITEM, i18n("  <b>Level</b><br>\n"
    "The level of the Dungeons on which you\n"
    "are. To go to the next level find the\n"
    "stairs and use the downstair button \n"
    "(<a href=moving.html>more...</a>)"));
  QWhatsThis::add(NEXT_ITEM, i18n("  <b>Gold</b><br>\n"
    "The amount of gold that you have. Your\n"
    "place in the high scores list will depend\n"
    "on this "
    "(<a href=general.html>more...</a>)"));
  QWhatsThis::add(NEXT_ITEM, i18n("  <b>Hit points</b><br>\n"
    "Your hit points shows how healthy you\n"
    "are. If a monster hits you your hit points\n"
    "decrease. If they drop to 0 you die "
    "(<a href=hp.html>more...</a>)"));
  QWhatsThis::add(NEXT_ITEM, i18n("  <b>Strength</b><br>\n"
    "If your strength is high your hit force\n"
    "will be a bit higher. The strength can by\n"
    "increased by <a href=potion.html>magic potions</a> "
    "(<a href=str.html>more...</a>)"));
  QWhatsThis::add(NEXT_ITEM, i18n("  <b>Armor protection</b><br>\n"
    "Each point of your armor protection\n"
    "decreases a bit the monsters hit\n"
    "force <p>(<a href=armor.html>more...</a>)"));
  QWhatsThis::add(NEXT_ITEM, i18n("  <b>Experience</b><br>\n"
    "For killing each monster you gain some\n"
    "experience points. If you have more than\n"
    "10, 20, 40, 80, ... points you go to the next\n"
    "experience level. That increase your\n"
    "maximum of hit points the chance of hitting a\n"
    "monster etc. <p>"
    "(<a href=exp.html>more...</a>)"));
   new KHungryWhatsThis(NEXT_ITEM);
}

static void compDam(const char *d, int *min, int *max)
{
  int min2=0, max2=0;
  sscanf(d, "%dd%d/%dd%d", min, max, &min2, &max2);
  (*max)*=*min;
  max2*=min2;
  *min+=min2;
  *max+=max2;
}

extern "C"
{
extern char *m_names[];
extern short halluc;
extern object mon_tab[];
int trap_at(int row, int col);
}

QString krwtGetHungryInfo(void)
{
  if (!hunger_str[0]) return i18n("Status bar");
  if (hunger_str[0]=='h') return i18n("  <b>Hungry</b><br>\n"
    "You are hungry. You may want to <a href=food.html>eat</a> something");
  if (hunger_str[0]=='w') return i18n("  <b>Weak</b><br>\n"
    "You are weak because of hunger. You may want\n"
    "to <a href=food.html>eat</a> something");
  if (hunger_str[0]=='f') return i18n("  <b>Fainting</b><br>\n"
    "You are fainting because of hunger. If you\n"
    "won't <a href=food.html>eat</a> something you will die of starvation");
  return QString::null;
}

QString krwtGetMonsterInfo(int monid)
{
  QString str;
  object *mon=&mon_tab[monid];
  str="<b>";
  str+=i18n(m_names[monid]);
  str+="</b>";
  if (str[3].lower()!=QChar('a'+monid) && str[3].lower()!=m_names[monid][0])
  {
    str+=" (";
    str+=QString::fromLatin1(m_names[monid]);
    str+=")";
  }
  str+="<br><br>\n\n";
  if (halluc)
  {
    str+=i18n("You have quaffed a potion of hallucination\n"
              "so what you see is not what the monster really is");
    return str;
  }
  str+=i18n("Base hit points: ");
  str+=QString::number(mon->hp_to_kill);
  int maxd, mind;
  compDam(mon->damage, &mind, &maxd);
  if (!(mon->m_flags&STATIONARY))
  {
    str+=i18n("<br>\nHit force: ");
    str+=QString::number(mind)+"-";
    str+=QString::number(maxd);
  }
  str+=i18n("<br>\nExperience gain: ");
  str+=QString::number(mon_tab[monid].kill_exp);
  str+="<br>";
  if (mon->m_flags&FLIES)
    str+=i18n("<br>\n<b>flies</b>\n"
              "<m>can move faster</m>");
  if (mon->m_flags&ASLEEP && !(mon->m_flags&(WAKENS|WANDERS)))
    str+=i18n("<br>\n<b>sleeps</b>\n"
              "<m>sleeps all the time unless you\n"
              "   wake him</m>");
  if (mon->m_flags&FREEZES)
    str+=i18n("<br>\n<b>freezes</b>\n"
              "<m>can freeze the player or even\n"
              "   make him die of hypotermia</m>");
  if (mon->m_flags&STINGS)
    str+=i18n("<br>\n<b>bites</b>\n"
              "<m>can decrease the strength of the\n"
              "   player</m>");
  if (mon->m_flags&SEEKS_GOLD)
    str+=i18n("<br>\n<b>seeks gold</b>\n"
              "<m>if not attacked, seeks some gold\n"
              "   and sleeps on it</m>");
  if (mon->m_flags&STEALS_GOLD)
    str+=i18n("<br>\n<b>steals gold</b>\n"
              "<m>steals gold from the player</m>");
  if (mon->m_flags&STEALS_ITEM)
    str+=i18n("<br>\n<b>steals items</b>\n"
              "<m>steals items from the player</m>");
  if (mon->m_flags&RUSTS)
    str+=i18n("<br>\n<b>rusts armor</b>\n"
              "<m>rusts the armor of the player and\n"
              "   makes it weaker</m>");
  if (mon->m_flags&CONFUSES)
    str+=i18n("<br>\n<b>confusing gaze</b>\n"
              "<m>the gaze of that monster can confuse\n"
              "   the player</m>");
  if (mon->m_flags&INVISIBLE)
    str+=i18n("<br>\n<b>invisible</b>\n"
              "<m>it is not visible unless you quaffed a\n"
              "   potion of detect monster, see invisible\n"
              "   or put on a ring of see invisible</m>");
  if (mon->m_flags&IMITATES)
    str+=i18n("<br>\n<b>imitates</b>\n"
              "<m>can imitate an object on the floor</m>");
  if (mon->m_flags&DROPS_LEVEL)
    str+=i18n("<br>\n<b>drops levels</b>\n"
              "<m>can decrease the level of experience\n"
	      "   of the player</m>");
  if (mon->m_flags&DRAINS_LIFE)
    str+=i18n("<br>\n<b>drains life</b>\n"
              "<m>can decrease the strength or maximal\n"
              "   hit points of the player</m>");
  if (mon->m_flags&FLITS)
    str+=i18n("<br>\n<b>flits</b>\n"
              "<m>moves like a confused monster</m>");
  if (mon->m_flags&STATIONARY)
    str+=i18n("<br>\n<b>stationary</b>\n"
              "<m>it cannot move</m>");
  if (mon->m_flags&HOLDS)
    str+=i18n("<br>\n<b>holds</b>\n"
              "<m>the player cannot move if he is near it</m>");
  if (mon->m_flags&FLAMES)
    str+=i18n("<br>\n<b>breathes out fire</b>\n"
              "<m>can hit the player with a flame</m>");
  return str;
}

QString krwtGetTrapInfo(int trapid)
{
  QString str=QString::null;
  if (trapid==TRAP_DOOR)
    str=i18n("<b>trap door</b><br>\n<br>\n"
        "makes you fall to the level below");
  if (trapid==BEAR_TRAP)
    str=i18n("<b>bear trap</b><br>\n<br>\n"
        "holds you for a number of moves");
  if (trapid==TELE_TRAP)
    str=i18n("<b>teleport trap</b><br>\n<br>\n"
        "teleports you to another part of\n"
	"the level");
  if (trapid==DART_TRAP)
    str=i18n("<b>poison dart trap</b><br>\n<br>\n"
        "hits you with poison darts. They\n"
	"decrease your hit points and sometimes\n"
	"your strength");
  if (trapid==SLEEPING_GAS_TRAP)
    str=i18n("<b>sleeping gas trap</b><br>\n<br>\n"
        "makes you sleep for a number of moves");
  if (trapid==RUST_TRAP)
    str=i18n("<b>rust trap</b><br>\n<br>\n"
        "rusts your armor and makes it worse");
  if (str.isNull())
    str=i18n("<b>Error</b><br>\n<br>\n"
             "No help for this item");
  return str;
}

inline void itemstr(QString *str, const QString &tit, const char *name)
{
  *str=i18n("<b>%0</b><br>\n<br>\n"
       "To pick it up move on it (<a href=%1.html>more...</a>)")
       .arg(tit).arg(name);
}

QString krwtGetDItemInfo(int whatx, int whaty)
{
  int obj=vdungeon[whaty][whatx]&OBJMASK, fl;
  QString str;
  object *lobj;
  if (wizard && (lobj=object_at(&level_objects, whaty, whatx))!=NULL)
  {
    char ostr[MSGLEN];
    get_desc(lobj, ostr);
    return QString::fromUtf8(ostr);
  }
  switch (obj)
  {
    case V_ROGUE:
	str=i18n("<b>Rogue</b><br>\n<br>\n"
                 "It's you. You can move\n"
                 "using arrow keys");
	break;
    case V_ARMOR:
        itemstr(&str, i18n("Armor"), "armor");
	break;
    case V_WEAPON:
	itemstr(&str, i18n("Weapon"), "weapon");
	break;
    case V_SCROLL:
	itemstr(&str, i18n("Magic scroll"), "scroll");
	break;
    case V_POTION:
        itemstr(&str, i18n("Magic Potion"), "potion");
	break;
    case V_GOLD:
        itemstr(&str, i18n("Gold"), "general");
	break;
    case V_FOOD:
	itemstr(&str, i18n("Food"), "food");
	break;
    case V_WAND:
	itemstr(&str, i18n("Wand"), "wand");
	break;
    case V_RING:
        itemstr(&str, i18n("Magic Ring"), "ring");
	break;
    case V_AMULET:
        str=i18n("<b>Amulet of Yendor</b><br>\n<br>\n"
                 "This is what you are seeking in the dungeons\n"
                 "If you pick it up you will be able to go upstair\n"
                 "(<a href=general.html>more...</a>)");
	break;
    case V_FLAME:
        str=i18n("<b>Flame</b><br>\n<br>\n"
                 "A flame. Probably breathed out by a dragon");
	break;
    case V_NOTHING:
        switch(fl=(vdungeon[whaty][whatx]>>FLSH))
	{
	  case V_HORWALL:
	  case V_VERTWALL:
	      str=i18n("<b>Wall</b><br>\n<br>\n"
                       "A wall around the room. Sometimes there are\n"
                       "<a href=hidden.html>hidden doors</a> in walls");
	      break;
	  case V_FLOOR:
	  case V_DARK+V_FLOOR:
	      str=i18n("<b>Floor</b><br>\n<br>\n"
                       "The floor. There is nothing on it");
	      break;
	  case V_STAIRS:
	  case V_STAIRS+V_DARK:
	      str=i18n("<b>Stairs</b><br>\n<br>\n"
                       "The stairs. You can use them go to the\n"
                       "next level. Move on them and use the\n"
                       "downstair command");
	      break;
	  case V_TRAP:
	  case V_TRAP+V_DARK:
	      str=krwtGetTrapInfo(trap_at(whaty, whatx));
	      break;
	  case V_TUNNEL:
	      str=i18n("<b>Corridor</b><br>\n<br>\n"
                       "Probably a corridor from one room to another");
	      break;
	  case V_DOOR:
	      str=i18n("<b>Door</b><br>\n<br>\n"
                       "Probably an entrance to a corridor");
	      break;
	  case V_NOTHING:
	      str=i18n("<b>Nothing</b><br>\n<br>\n"
                       "You don't know what is here. Maybe nothing\n"
                       "or an unexplored room");
	      break;
	  default:
	      str=i18n("<b>Error</b><br>\n<br>\n"
                       "No help for this item");
	}
	break;
    default:
	if (obj>=V_MONSTER && obj<V_MONSTER+26)
	{
          str=krwtGetMonsterInfo(obj-V_MONSTER);
	  break;
	}
	str=i18n("<b>Error</b><br>\n<br>\n"
                 "No help for this item");
	break;
  }
  return str;
}
