#ifndef _KMSGBAR_H_
#define _KMSGBAR_H_

#include <qpushbutton.h>
#include <ktoolbar.h>

class KConfig;

class KMoreButton:public QPushButton
{
  Q_OBJECT
public:
  KMoreButton(const QString &text, QWidget *parent=0, const char *name=0);
  void keyPressEvent(QKeyEvent *);
};

class KMsgBar:public KToolBar
{
  Q_OBJECT
public:
  KMsgBar(QWidget *parent=NULL, char *name=NULL);
  void message(const QString &s);
  void setMessage(const QString &s);
  void removeMore(void);
  void invMsg();
  bool more();
  void saveProperties(KConfig *);
  void readProperties(KConfig *);
  QString getMessage(int i=0);
  int msgCount();
  int willQuit;
protected:
  QFont *normal, *bold;
  QComboBox *combo;
  KMoreButton *p;
  int pbid, fmore, loop;
  bool inv;  
public slots:
  void activ(int i);
  void moreClick(void);
signals:
  void moreShown();
  void moreRemoved();
};

extern KMsgBar *msg;
#endif
