/***************************************************************************
                          kmudping.cpp
                      -------------------
    description          : Class that provides interface for pinging host
    begin                : Mon Jul 31 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kmudping.h"
#include <kapp.h>
#include <qmessagebox.h>

KmudPing::KmudPing()
{
  executable = "";
  // connect to childprocess
  connect(&ping, SIGNAL(processExited(KProcess*)), this, SLOT(slotPingExited(KProcess*)));
  connect(&ping, SIGNAL(receivedStdout(KProcess*, char*, int)),
          this, SLOT(slotPingOutput(KProcess*, char*, int)));
  connect(&ping, SIGNAL(receivedStderr(KProcess*, char*, int)),
          this, SLOT(slotPingOutput(KProcess*, char*, int)));
}

KmudPing::~KmudPing()
{
}

bool KmudPing::setExecutable(QString program)
{
  if (program.length() > 0)
  {
    // Note: should check if the program exists and the user is allowed
    // to execute it
    executable = program;
    return true;
  }
  return false;
}

int KmudPing::execPingHostDlg(QWidget* parent, QString host, int ping_count=5)
{

  if (executable.length() == 0)
  {
    return PING_NO_EXECUTABLE;
  }
  QString count_param;
  int result;
  if (ping_count < 1) ping_count = 5;

  count_param.setNum(ping_count);
  count_param = "-c " + count_param;

  // create childprocess
  ping.clearArguments();
  ping.setExecutable(executable);
  ping << count_param;
  ping << host;

  //create the dialog
  dialog = new DlgPingProgress(parent, "Pinging host");
  host.prepend(" ");
  dialog->setCaption(i18n("Pinging host") +  host);
  // connect to dialog
  connect(this, SIGNAL(pingExited(int)), dialog, SLOT(slotPingStatus(int)));
  connect(dialog, SIGNAL(cancelPing()), this, SLOT(slotKillPing()));
  connect(this, SIGNAL(outputRecieved(QString)), dialog, SLOT(slotPingOutput(QString)));


  // start the ping
  ping.start(KProcess::NotifyOnExit, KProcess::AllOutput);
  // execute the dialog
  result = dialog->exec();
  if (ping.isRunning())
  {
    ping.kill();
  }

  // disconnect from dialog
  disconnect(dialog, SLOT(slotPingStatus(int)));
  disconnect(this, SLOT(slotKillPing()));
  disconnect(dialog, SLOT(slotPingOutput(QString)));

  if (result == PING_ERROR)
  {
    QString errorMsg(i18n("Execution of"));
    errorMsg.append(" '");
    errorMsg.append(executable);
    errorMsg.append("' ");
    errorMsg.append(i18n("failed."));
    errorMsg.append("\n");
    errorMsg.append(i18n("Maybe path or name of the executable is wrong."));
    QMessageBox::critical(parent, i18n("Error"), errorMsg);
  }

  return result;

}

void KmudPing::slotPingExited(KProcess* process)
{
  if (ping.normalExit())
  {
    emit pingExited(ping.exitStatus());
  }
}

void KmudPing::slotKillPing()
{
  if (ping.isRunning())
  {
    ping.kill();
  }
}

void KmudPing::slotPingOutput(KProcess* process, char* buffer, int buflen)
{
  QString output = QString(buffer).left(buflen);
  emit outputRecieved(output);
}

