/***************************************************************************
                          dlgoptionhistory.cpp
                          -------------------
    description          : History Options Dialog Class
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgoptionhistory.h"


DlgOptionHistory::DlgOptionHistory(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();

	connect( outputSize_Slider, SIGNAL(valueChanged(int)), outputSize_LCDNumber , SLOT(display(int)) );
	connect( inputSize_Slider, SIGNAL(valueChanged(int)), inputSize_LCDNumber , SLOT(display(int)) );
}

DlgOptionHistory::~DlgOptionHistory(){

	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()

}

int DlgOptionHistory::getOutputSize(){
	return outputSize_Slider->value();
}

int DlgOptionHistory::getInputSize(){
	return inputSize_Slider->value();
}

void DlgOptionHistory::setOutputSize(int i){
	outputSize_Slider->setValue(i);
}

void DlgOptionHistory::setInputSize(int i){
	inputSize_Slider->setValue(i);
}

bool DlgOptionHistory::getSharedInputHistory()
{
	return shareHistory_CheckBox->isChecked();
}

void DlgOptionHistory::setSharedInputHistory(bool b)
{
	shareHistory_CheckBox->setChecked(b);
}
