/***************************************************************************
                          dlgmapinfo.cpp  -  description
                             -------------------
    begin                : Fri Sep 22 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgmapinfo.h"

DlgMapInfo::DlgMapInfo(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	
	setCaption("Mapper Information");
	
	connect( cmdClose, SIGNAL(clicked()), SLOT(accept()) );

}

DlgMapInfo::~DlgMapInfo()
{
}

void DlgMapInfo::setStart(int x,int y, int lvl,int zone)
{
	QString xpos,ypos,lpos,zpos;
	
	xpos.setNum(x);
	ypos.setNum(y);
	lpos.setNum(lvl);
	zpos.setNum(zone);
	
	txtX->setText(xpos);
	txtY->setText(ypos);
	txtLvl->setText(lpos);
	txtZone->setText(zpos);
}

void DlgMapInfo::setGeneral(QString mud,QString chr)
{
	txtMud->setText(mud);
	txtChar->setText(chr);
}

void DlgMapInfo::setTotals(int level,int room,int text,int path,int zone)
{
	QString l,r,t,p,z;
	
	l.setNum(level);
	r.setNum(room);
	t.setNum(text);
	p.setNum(path);
	z.setNum(zone);
	txtLvls->setText(l);
	txtRooms->setText(r);
	txtText->setText(t);
	txtPaths->setText(p);
	txtZones->setText(z);
}


