/***************************************************************************
                          cmudprofile.h
                      -------------------
    description          : Mud Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMUDPROFILE_H
#define CMUDPROFILE_H

#include <qstring.h>
#include <qdir.h>
#include <ksimpleconfig.h>

struct directions
{
	QString north;
	QString northeast;
	QString east;
	QString southeast;
	QString south;
	QString southwest;
	QString west;
	QString northwest;
	QString up;
	QString down;
};

/**
  * Mud Profile Class
  *@author Stephan Uhlmann
  */

class CMudProfile {
public:
	/** constructor */
	CMudProfile();
	/** destructor */
	~CMudProfile();

	/** returns the filename where the data are stored */
	QString getFileName();
	/** sets the filename where the data are stored */
	void setFileName(QString);

	/** returns the title */
	QString getTitle();
	/** sets the title */
	void setTitle(QString);

	/** returns the hostname */
	QString getHostName();
	/** sets the hostname */
	void setHostName(QString);

	/** returns the port */
	unsigned int getPort();
	/** sets the port */
	void setPort(unsigned int p);
	
	/** returns the NamePrompt */
	QString getNamePrompt();
	/** sets the NamePrompt */
	void setNamePrompt(QString);
	
	/** returns the PasswordPrompt */
	QString getPasswordPrompt();
	/** sets the PasswordPrompt */
	void setPasswordPrompt(QString);

	/** returns the directions */
	directions *getDirections();		
	/** sets the directions */
	void setDirections(directions *d);

	/** reads the data of the class from its file */
	void readData();
	/** writes the data to the class to its file */
	void writeData();

	/** returns iType (the interpretation type) */
	int getInterpretationType();
	/** sets the interpretation type */
	void setInterpretationType(int i);
	/** Activate create mode for mapper */
	void setCreateMode(bool create);
	/** Activate follow mode for mapper */
	void setFollowMode(bool create);
	/** get create mode on/off state for the mapper */
	bool getCreateMode(void);
	/** get follow mode on/off state for the mapper */
	bool getFollowMode(void);

	/** check if valid move checking is enabled */
	bool getDoValidMoveChecking(void);
	/** set valid move checking */
	void setDoValidMoveChecking(bool b);
	/** get string sent by mud if move fails */
	QString getFailedMoveMsg1(void);
	/** set string sent by mud if move fails */
	void setFailedMoveMsg1(QString s);
	/** get string sent by mud if move fails */
	QString getFailedMoveMsg2(void);
	/** set string sent by mud if move fails */
	void setFailedMoveMsg2(QString s);
	/** get string sent by mud if move fails */
	QString getFailedMoveMsg3(void);
	/** set string sent by mud if move fails */
	void setFailedMoveMsg3(QString s);

private:
	QString filename;
	QString title;
	QString hostname;
	unsigned int port;
	QString nameprompt;
	QString passwordprompt;
	directions *map_directions;
	bool bFollowMode,bCreateMode;
	/** The interpretation type */
	int iType;

	/** valid move checking */
	bool doValidMoveChecking;
	QString failedMoveMsg1;
	QString failedMoveMsg2;
	QString failedMoveMsg3;


};

#endif
