/***************************************************************************
                          cmapelement.h
                      -------------------
    description          : Base class for map elements
    begin                : Fri Sep 8 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CMAPELEMENT_H
#define CMAPELEMENT_H

#include <qpainter.h>
#include <qcolor.h>
#include "kcmapfile.h"


#define ROOM_SIZE      20
#define HALF_ROOM_SIZE 10

class CMapZone;

enum dir { NORTH , SOUTH , WEST , EAST , NORTHWEST, NORTHEAST, SOUTHEAST , SOUTHWEST, UP, DOWN, SPECIAL };

typedef enum dir direction;

enum element_type { ROOM=0, PATH, TEXT, ZONE, OTHER };

typedef enum element_type elementTyp;

class CMapElement
{
public:
	CMapElement()              					{}
	virtual ~CMapElement()           				  {}
	
	void setSelected(bool sel);
	bool getSelected(void)     					{ return selected; }
	
	virtual void setEditMode(bool edit)         { editMode = edit; }
	virtual bool getEditMode()                  { return editMode; }
	
	void setCords(int lowx,int lowy,int hix,int hiy);
	
	int getLowX(void)                           { return startx; }
	int getLowY(void)                           { return starty; }
	int getHiX(void)                            { return endx; }
	int getHiY(void)                            { return endy; }
	virtual void moveBy(int x,int y);
	virtual elementTyp getElementType(void)     { return OTHER ; }
	
	void setLowHiX(int lowx,int hix);
	void setLowHiY(int lowy,int hiy);
	
	virtual bool mouseInElement(int x,int y,CMapZone *currentZone);
	virtual bool elementIn(int x1,int y1,int x2,int y2,CMapZone *currentZone);
	virtual bool mouseInResize(int x,int y,CMapZone *currentZone);
	
	virtual void paint(QPainter *p,CMapZone *currentZone)=0;
	virtual void dragPaint(QPainter *p,int offsetx,int offsety,CMapZone *currentZone) =0;
	virtual void lowerPaint(QPainter *p,CMapZone *currentZone)=0;
	virtual void higherPaint(QPainter *p,CMapZone *currentZone)=0;
	virtual CMapElement *copy(void) =0;

	void setLowerColour(QColor col)    { defaultCol = col; }
	void setHigherColour(QColor col)   { higherCol = col; }
	void setDefaultColour(QColor col)  { lowerCol = col; }
	void setSelectColour(QColor col)   { selectCol = col; }
	void setEditColour(QColor col)     { editCol = col; }

	QColor getLowerColour(void)    { return defaultCol; }
	QColor getHigherColour(void)   { return higherCol; }
	QColor getDefaultColour(void)  { return lowerCol; }
	QColor getSelectColour(void)   { return selectCol; }
	QColor getEditColour(void)     { return editCol; }

	virtual void read(KCMapFile* kcmfile) = 0;
	virtual void write(KCMapFile* kcmfile) = 0;
	
protected:
	int startx,starty,endx,endy;	
	bool editMode;
		
private:
	bool selected;
	
	QColor defaultCol,higherCol,lowerCol,selectCol,editCol;
	



};

#endif
