/***************************************************************************
                          cmapcreationundo.h
                      -------------------
    description          :
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPCREATIONUNDO_H
#define CMAPCREATIONUNDO_H

#include <qobject.h>
#include "cmapundoelement.h"
#include "cmapwidget.h"

/**
  *@author Kevin Krammer
  */

class CMapCreationUndo : public QObject  {
  Q_OBJECT
public: 
	CMapCreationUndo(CMapWidget* mapper, int maxUndoSteps=10);
	~CMapCreationUndo();

  /** clears the stack of undoable steps */
  void clear();

  /** if activate is false signals are ignored */
  void setActive(bool activate);
  bool isActive();



public slots: // Public slots
  /** to be called when a creational step should be undone */
  void slotUndo();

  /** slot to be called when elements are autmatically created by the mapper */
  void slotElementCreated(CMapUndoElement* element) ;

	
protected: // Protected attributes
  /** this contains the steps that can be undone. last element is the most recent */
  QList<CMapUndoElement> undoList;

  /** state of facility. false means we ignore calls to our slots */
  bool active;

  /** the mapper */
  CMapWidget* map;

  /** current number of steps in UndoList */
  int stepCount;
  /** maxium number of steps we keep */
  int maxSteps;
protected: // Protected methods
  /** removes an element and returns it */
  CMapUndoElement* pop();

  /** this pushes an element onto out limited stack of undoable steps */
  void push(CMapUndoElement* element);
};

#endif
