/***************************************************************************
                          custombarbutton.h
                    -------------------
    description          : This class was taken from the kdelibs (1.1.2) and
    			   altered so that buttons with no icons are shown as text
    			
 ***************************************************************************/

#ifndef CCUSTOMBARBUTTON_H
#define CCUSTOMBARBUTTON_H

#include <ktoolbar.h>

class CCustomBarButton : public QButton
 {
   Q_OBJECT

 public:
   CCustomBarButton(const QPixmap& pixmap, int id, QWidget *parent,
                  const char *name=0L, int item_size = 26, const char *txt=0,
                  bool _mb = false);
   CCustomBarButton(QWidget *parent=0L, const char *name=0L);
   ~CCustomBarButton() {  };
   void setEnabled(bool enable);

   virtual void setPixmap( const QPixmap & );
   virtual void setText ( const char *text);
   void on(bool flag);
   void toggle();
   void beToggle(bool);
   bool ImASeparator () {return sep;};
   void youreSeparator () {sep = true;};
   QPopupMenu *popup () {return myPopup;};
   void setPopup (QPopupMenu *p);
   void setDelayedPopup (QPopupMenu *p);
   void setRadio(bool f);

 public slots:
   void modeChange();

 protected:
   void paletteChange(const QPalette &);
   void leaveEvent(QEvent *e);
   void enterEvent(QEvent *e);
   void drawButton(QPainter *p);
   bool eventFilter (QObject *o, QEvent *e);
   void showMenu();
   //void setIconSet (const QPixmap &);
   void makeDisabledPixmap();

 private:
   bool toolBarButton;
   bool sep;
   QPixmap enabledPixmap;
   QPixmap disabledPixmap;
   int icontext;
   int highlight;
   bool raised;
   int id;
   int _size;
   KToolBar *parentWidget;
   QString btext;
   QFont buttonFont;
   QPopupMenu *myPopup;
   bool delayPopup;
   QTimer *delayTimer;
   bool radio;

 protected slots:
     void ButtonClicked();
     void ButtonPressed();
     void ButtonReleased();
     void ButtonToggled();
     void slotDelayTimeout();

 signals:
     void clicked(int);
     void doubleClicked(int);
     void pressed(int);
     void released(int);
     void toggled(int);
     void highlighted (int, bool);
 };

#endif
