/*
 * $Id: cpu.h,v 1.3.2.1 1996/12/19 19:23:42 alex Exp $
 *
 * $Log: cpu.h,v $
 * Revision 1.3.2.1  1996/12/19 19:23:42  alex
 * fist public release, 0.1.alpha
 *
 * Revision 1.3  1996/12/19 19:14:31  alex
 * first public release, version 0.1.alpha
 *
 */

#ifndef _CPUMON_H_
#define _CPUMON_H_

#include <sys/time.h>
#include <stdio.h>
#include <qbrush.h>

class CpuMon : public QWidget
{
  Q_OBJECT;
public:
  CpuMon (QWidget *parent = 0, const char *name = 0, WFlags f=0);
  ~CpuMon ();
  void updateValues();

protected:
  virtual void timerEvent(QTimerEvent *);
  virtual void paintEvent(QPaintEvent *);
  unsigned load_values;

  int tid;
  unsigned intervals, timer_interval;
  unsigned user_ticks, system_ticks, nice_ticks, idle_ticks,
    old_user_ticks, old_system_ticks, old_nice_ticks, old_idle_ticks;

  int old_y_scale;
  struct timeval oldtime;
  FILE *statfile;
  QBrush brush_0, brush_1;
};

#endif
