/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program :   kastrolog 5.4 beta 3
 * Authors : see the AUTHORS file
 * E-Mail  : Llyra@altavista.com
*****************************************************************************/ 


/**********************************************************************

	--- Qt Architect generated file ---

	File: AstroInfo.cpp
	Last generated: Tue Sep 28 14:38:42 1999

 *********************************************************************/

#include <kfiledialog.h>
#include "AstroInfo.h"

#define Inherited AstroInfoData

AstroInfo::AstroInfo(QWidget* parent, const char* name) : Inherited(parent, name)
{
}


AstroInfo::~AstroInfo()
{
  settz(NULL);
}

char* AstroInfo::SzLatLong(real angle, bool latitude)
{
  static char szLoc[7];
  int i;
  char ch;
  i = (int)(RFract(RAbs(angle))*100.0+rRound);
  ch = us.fAnsiChar > 1 ? 128 : chDeg1;
  if (us.fAnsiChar != 3) {
    sprintf(szLoc, "%3.0f%c%02d%c",
      RFloor(RAbs(angle)), ch, i, angle < 0.0 ? (latitude ? 'S' : 'E') : (latitude ? 'N' : 'W'));
  } else {
    sprintf(szLoc, "%3.0f%c%02d%3.0f%c%02d",
    RFloor(RAbs(angle)), ch, i, angle < 0.0 ? (latitude ? 'S' : 'E') : (latitude ? 'N' : 'W'));
  }
  return (char *)szLoc;
}
 
AstroInfo::AstroInfo(CI* ci)
{
  emit setCaption(tr("Enter Chart Info"));
  SetAstroInfo(ci, TRUE);
}

AstroInfo::AstroInfo(CI* ci, bool b)
{
  emit setCaption(tr("Default Info"));
  SetAstroInfo(ci, b);
}

void AstroInfo::SetAstroInfo(CI* ci, bool normal)
    {
  char buf[80];
  bool ansi = TRUE;
  ciptr = ci;
  myci = *ciptr;
  tzsave[0] = 0;
  if(normal)
  {
    Month->setCurrentItem(myci.mon - 1);
    sprintf(buf, "%d", myci.day);
    emit TheDay->setText(buf);
    sprintf(buf, "%d", myci.yea);
    emit Year->setText(buf);
    emit Time->setText(SzTim(myci.tim));
  }
  else
  {
    emit Month->setEnabled(FALSE);
    emit TheDay->setEnabled(FALSE);
    emit Year->setEnabled(FALSE);
    emit Time->setEnabled(FALSE);
    emit monthlabel->setEnabled(FALSE);
    emit daylabel->setEnabled(FALSE);
    emit yearlabel->setEnabled(FALSE);
    emit timelabel->setEnabled(FALSE);
    emit namelabel->setEnabled(FALSE);
    emit localtionlabel->setEnabled(FALSE);
    emit nowlabel->setEnabled(FALSE);
    emit previouslabel->setEnabled(FALSE);

  }
  if(myci.dst)
    Daylight->setChecked(TRUE);
  myci.zon = -myci.zon;
  emit Timezone->setText(SzZone(myci.zon));
  if(us.fAnsiChar)
  {
    us.fAnsiChar = fFalse;
    ansi = FALSE;
  }
  emit Longitude->setText(SzLatLong(myci.lon, FALSE));
  emit Latitude->setText(SzLatLong(myci.lat, TRUE));
  if(!ansi)
  {
    us.fAnsiChar = fTrue;
    ansi = TRUE;
  }
  if(normal)
  {
    strncpy(namebuf, ciptr->nam, 80);
    myci.nam = namebuf;
    emit Name->setText(myci.nam);
    strncpy(location, ciptr->loc, 80);
    myci.loc = location;
    emit Location->setText(myci.loc);
    strncpy(tzfile, ciptr->tzfile, 80);
    myci.tzfile = tzfile;
    sprintf(buf, tr("TZ file: %s"), myci.tzfile);
    WriteError(buf);
  }
  else
  {
    emit Name->setEnabled(FALSE);
    emit Location->setEnabled(FALSE);
  }
}

void AstroInfo::previousslot()
{
  SetAstroInfo(ciptr, TRUE);
}

void AstroInfo::okslot()
{
  close(FALSE);
  myci.mon = Month->currentItem() + 1;
  dayslot();
  yearslot();
  timeslot();
  myci.dst = Daylight->isChecked() ? 1.0 : 0.0;
  timezoneslot();
  latitudeslot();
  longitudeslot();
  nameslot();
  if(ciptr->nam != nullnamloc && ciptr->nam)
    DeallocateNear(ciptr->nam);
  locationslot();
  if(ciptr->loc != nullnamloc && ciptr->loc)
    DeallocateNear(ciptr->loc);
  if(ciptr->tzfile != nullnamloc && ciptr->tzfile)
    DeallocateNear(ciptr->tzfile);
  *ciptr = myci;
  ciptr->nam = SzPersist(namebuf);
  ciptr->loc = SzPersist(location);
  ciptr->tzfile = SzPersist(tzfile);
}

void AstroInfo::cancelslot()
{
  close(FALSE);
}

void AstroInfo::dayslot()
{
  int i = atoi(TheDay->text());
  if(!FBetween(i, 1, 31))
    WriteError(tr("Illegal day value"));
  else
    {
      myci.day = i;
      setdst();
      WriteError(NULL);
    }
}

void AstroInfo::yearslot()
{
  char *errptr = (char *)-1;
  int i = strtol(Year->text(), &errptr, 10);
  if(*errptr != 0 || errptr == Year->text())
    {
      WriteError(tr("Illegal year value"));
      return;
    }
    i = NParseSz((char *)Year->text(), pmYea);
  if(!FBetween(i, -5000, 5000))
    WriteError(tr("Illegal year value"));
  else
    {
      myci.yea = i;
      setdst();
      WriteError(NULL);
    }
}

void AstroInfo::WriteError(const char *c)
{
  emit Errors->setText(c ? c : "");
}

void AstroInfo::monthslot(int i)
{
   myci.mon = Month->currentItem() + 1;
   setdst();
}

void AstroInfo::timeslot()
{
  real r = RParseSz((char *)Time->text(), pmTim);
  if(!FBetween(r, 0.0, 23.59))
     WriteError(tr("Illegal time value"));
  else
  {
    WriteError(NULL);
    myci.tim = r;
    setdst();
  }
}

void AstroInfo::daylightslot(bool b)
{
  myci.dst = b ? 1.0 : 0.0;
}

void AstroInfo::timezoneslot()
{
  real r = RParseSz((char *)Timezone->text(), pmZon);
  if(!FBetween(r, -12.0, 12.0))
    WriteError(tr("Illegal time zone value"));
  else
  {
    WriteError(NULL);
    myci.zon = r;
    setdst();
  }
}

void AstroInfo::latitudeslot()
{
  real r = RParseSz((char *)Latitude->text(), pmLat);
  if(!FBetween(r, -90.0, 90.0))
    WriteError(tr("Illegal latitude value"));
  else
  {
    WriteError(NULL);
    myci.lat = r;
  }
}

void AstroInfo::longitudeslot()
{
  real r = RParseSz((char *)Longitude->text(), pmLon);
  if(!FBetween(r, -180.0, 180.0))
    WriteError(tr("Illegal longitude value"));
  else
  {
    WriteError(NULL);
    myci.lon = r;
  }
}

void AstroInfo::nameslot()
{
  strncpy(namebuf, Name->text(), 80);
}

void AstroInfo::locationslot()
{
  strncpy(location, Location->text(), 80);
}

void AstroInfo::setdst()
{
  if(!*tzfile) return;
  settime();
  if(isdst() > 0)
    {
      myci.dst = 1.0;
      Daylight->setChecked(TRUE);
    }
  else
    {
      myci.dst = 0.0;
      Daylight->setChecked(FALSE);
    }
}

void AstroInfo::settz(char *f)
{
  char *c, varbuf[60];
  if(f)
    {
      c = getenv("TZ");
      if(c)
	strncpy(tzsave, c, 80);
      varbuf[0] = ':';
      varbuf[1] = 0;
      strncat(varbuf, f, 80);
      setenv("TZ", varbuf, 1);
      tzset();
    }
  else if(tzsave[0])
    setenv("TZ", tzsave, 1);
  else
    unsetenv("TZ");
}

void AstroInfo::settime()
{
  struct tm tm;
  int h, m;
  h = (int)NFloor(myci.tim);
  m =  (int)(RFract(RAbs(myci.tim))*100.0+rRound/600.0);
  tm.tm_sec = 0;
  tm.tm_min = m;
  tm.tm_hour = h;
  tm.tm_mday = myci.day;
  tm.tm_mon = myci.mon - 1;
  tm.tm_year = myci.yea-1900;
  tt = mktime(&tm);
}

void AstroInfo::setztime()
{
  struct tm *tmptrg;
  double dt, zheure, zminute;
  //tmptrl = localtime(&tt);
  tmptrg =  gmtime(&tt);
  dt = difftime(mktime(tmptrg), tt);
  zminute = floor(dt/60.0);
  zheure = ceil(zminute / 60.0);
  zminute = floor(zminute - (zheure * 60.0));
  myci.zon = -(zheure + zminute / 100.0);
  emit Timezone->setText(SzZone(myci.zon));
}

int AstroInfo::isdst()
{
  struct tm *tmptrl;
  tmptrl = localtime(&tt);
 return tmptrl->tm_isdst;
}

void AstroInfo::timezonefileslot()
{
  QString buf;
  int i;
  buf.sprintf("%s", strlen(tzfile) ? tzfile : ZoneInfoPath);
  QString s = KFileDialog::getOpenFileName(buf.data());
  if(s.data())
    {
      emit dayslot();
      emit yearslot();
      emit timeslot();
      strncpy(tzfile, s.data(), 80);
      settz(s.data());
      setdst();
      setztime();
      buf.sprintf(tr("TZ file : %s"), s.data());
      WriteError(buf.data());
    }
}

void AstroInfo::nowslot()
{
  char buf[7];
  GetTimeNow(&myci.mon, &myci.day, &myci.yea, &myci.tim, myci.zon);
  Month->setCurrentItem(myci.mon - 1);
  sprintf(buf, "%d", myci.day);
  emit TheDay->setText(buf);
  sprintf(buf, "%d", myci.yea);
  emit Year->setText(buf);
  emit Time->setText(SzTim(myci.tim));
  emit Timezone->setText(SzZone(myci.zon));
  setdst();
}




