/***************************************************************************
                          kshowvcard.h  -  description
			This Class handles the display of cards
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <qpopmenu.h>
#include <qmenubar.h>
#include <qstrlist.h>
#include <qapp.h>
#include <qkeycode.h>
#include <qaccel.h>
#include <qregexp.h>
#include <qobject.h>
#include <qmlined.h>
#include <qlined.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qmsgbox.h>
#include <qcombo.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qregexp.h>
#include <qtstream.h>
#include <qkeycode.h>
#include <qscrollbar.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <ctype.h>
#include <pwd.h>

#include <kapp.h>
#include <kfiledialog.h>
#include "kcard.h"
#include "TabData.h"

class KShowvcard : public QFrame
{
	Q_OBJECT

public:

	KShowvcard (KApplication *a=NULL,QWidget *_parent=NULL, const char *name=NULL);
	~KShowvcard();
	KApplication* mykapp;
	
signals:
	void signal_kshowvcard_quit();
	void signal_kshowvcard_delcard(int me);
	void signal_kshowvcard_selectall();
	void signal_kshowvcard_unselectall();
	void signal_kshowvcard_invertselect();
	void signal_kshowvcard_whoselect();
	void signal_kshowvcard_tabgeneral(QString);
	void signal_kshowvcard_tabdetails(QString);
	void signal_kshowvcard_tabextensions(QString);
	void signal_kshowvcard_kcardgeneral(int,QString);
	void signal_kshowvcard_kcarddetails(int,QString);
	void signal_kshowvcard_kcardextensions(int,QString);
	void signal_kshowvcard_show(int);

public slots:
	void slot_kshowvcard_openfile();
	void slot_kshowvcard_importfiles();
	void slot_kshowvcard_exportfiles();
	void slot_kshowvcard_printcards();
	void slot_kshowvcard_savefiles();
	void slot_kshowvcard_quitcard();

	void slot_kshowvcard_addcard();
	void slot_kshowvcard_delcard();
	void slot_kshowvcard_selectall();
	void slot_kshowvcard_unselectall();
	void slot_kshowvcard_invertselect();
	void slot_kshowvcard_ordercards();
	void slot_kshowvcard_removeselect(int me);
	void slot_kshowvcard_slidermoved(int valeur);
	void slot_kshowvcard_valuechanged(int valeur);
	void slot_kshowvcard_nextline();
	void slot_kshowvcard_nextpage();
	void slot_kshowvcard_prevline();
	void slot_kshowvcard_prevpage();
	void slot_kshowvcard_sliderpressed();
	void slot_kshowvcard_sliderreleased();
	void slot_kshowvcard_reorder_positions();
	
	void slot_kshowvcard_mousedcgevent(int,QString);
	void slot_kshowvcard_mousedcdevent(int,QString);
	void slot_kshowvcard_mousedceevent(int,QString);
	
	void slot_kshowvcard_receivegeneral(QString);
	void slot_kshowvcard_receivedetails(QString);
	void slot_kshowvcard_receiveextensions(QString);	
	void slot_internal(int,QString);
	void slot_kshowvcard_show(int);
protected:
	virtual void resizeEvent(QResizeEvent*);
	QList <Kcard>	list_cards;	

private:
	QWidget	 *parent;
	KFileDialog	*file_dialog;
	QScrollBar	*ScrollBar;
	QPalette	palette_normal;
	QPalette	palette_select;
	QPalette	palette_active;
	QColorGroup	normal;
	QColorGroup	active;
	QColorGroup	select;
	QPrinter	*printer;
	
	void		add_scrollbar();		
	QString		convert_to_string(int this_int);	
	void		find_free_pos();
	void		reorder_positions();	
	const char *filename;
	int			filedescriptor;
	int			posx_free;
	int			posy_free;
	int			free_card;
	int			decalage;
	int			nb_col;
	int			cardnumber;
	int			appear;
	TabData *Complete_Data;
	QString	String_General,String_Details,String_Extensions;
	Kcard *KCard0;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
