/***************************************************************************
                          kcard.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include "kcard.h"

Kcard::Kcard
(	KApplication *a,
	QWidget *_parent,
	const QString& name,
	int posx,
	int posy,
	const QString &text,
	int number)
: QWidget (_parent,name)
{
int i;
	mykapp = a;
	parent = _parent;
	numero = number;
	hidden = false;
//palettes
	labels[0] = new Labels (this,text);
	labels[0]->changefont(1);
	labels[0]->changepalette(1);
	labels[0]->setFrameStyle(19);
	for (i=1; i<MAX_INFO ; i++)
		{
		labels[i] = new Labels(this,"labelsi");
		labels[i]->setGeometry(2,30+20*(i-1),96,18);
		labels[i]->hide();
		}
	selected=FALSE;
	dclicked=FALSE;
	old_number_of_fields=1;
	
	connect(_parent,SIGNAL(signal_kshowvcard_kcardgeneral(int,QString)),	this, SLOT(slot_kcard_updategeneral(int,QString)));
	connect(_parent,SIGNAL(signal_kshowvcard_kcarddetails(int,QString)),	this, SLOT(slot_kcard_updatedetails(int,QString)));
	connect(_parent,SIGNAL(signal_kshowvcard_kcardextensions(int,QString)),	this, SLOT(slot_kcard_updateextensions(int,QString)));
	
	connect(_parent,SIGNAL(signal_kshowvcard_delcard(int)),		this,SLOT(slot_kcard_delcard(int)));
	connect(_parent,SIGNAL(signal_kshowvcard_selectall()),		this,SLOT(slot_kcard_selectall()));
	connect(_parent,SIGNAL(signal_kshowvcard_unselectall()),	this,SLOT(slot_kcard_unselectall()));
	connect(_parent,SIGNAL(signal_kshowvcard_invertselect()),	this,SLOT(slot_kcard_invertselect()));
	connect(_parent,SIGNAL(signal_kshowvcard_whoselect()),		this, SLOT(slot_kcard_whoselect()));
	connect(_parent,SIGNAL(signal_kshowvcard_show(int)),		this, SLOT(slot_kcard_show(int)));

	connect(this, SIGNAL(signal_kcard_unselectall()),		_parent, SLOT(slot_kshowvcard_unselectall()));
	connect(this, SIGNAL(signal_kcard_ordercards()),		_parent, SLOT(slot_kshowvcard_ordercards()));
	connect(this, SIGNAL(signal_kcard_reorder_positions()),		_parent, SLOT(slot_kshowvcard_reorder_positions()));
	connect(this, SIGNAL(signal_kcard_whoselect(int)),		_parent, SLOT(slot_kshowvcard_removeselect(int)));
	connect(this, SIGNAL(signal_kcard_mousedcg(int,QString)),	_parent, SLOT(slot_kshowvcard_mousedcgevent(int,QString)));
	connect(this, SIGNAL(signal_kcard_mousedcd(int,QString)),	_parent, SLOT(slot_kshowvcard_mousedcdevent(int,QString)));
	connect(this, SIGNAL(signal_kcard_mousedce(int,QString)),	_parent, SLOT(slot_kshowvcard_mousedceevent(int,QString)));		
	
	this->show();
	this->setGeometry(posx,posy,100,30);
/*	emit signal_kcard_ordercards();*/
	emit signal_kcard_reorder_positions();
}

Kcard::~Kcard()
{
/*	emit signal_kcard_ordercards();*/
}

//SLOTS

void Kcard::slot_kcard_show(int this_int)
{
printf("kcard received show %d\n",this_int);
switch (this_int)
	{
	case 0 : {hidden=false;break;}
	case 1 : {if ((labels[1]->startswith('a'))||(labels[1]->startswith('b'))) {hidden=false;} else {hidden=true;} break;}
	case 2 : {if ((labels[1]->startswith('c'))||(labels[1]->startswith('d'))) {hidden=false;} else {hidden=true;} break;}
	case 3 : {if ((labels[1]->startswith('e'))||(labels[1]->startswith('f'))) {hidden=false;} else {hidden=true;} break;}
	case 4 : {if ((labels[1]->startswith('g'))||(labels[1]->startswith('h'))) {hidden=false;} else {hidden=true;} break;}
	case 5 : {if ((labels[1]->startswith('i'))||(labels[1]->startswith('j'))) {hidden=false;} else {hidden=true;} break;}
	case 6 : {if ((labels[1]->startswith('k'))||(labels[1]->startswith('l'))) {hidden=false;} else {hidden=true;} break;}
	case 7 : {if ((labels[1]->startswith('m'))||(labels[1]->startswith('n'))) {hidden=false;} else {hidden=true;} break;}
	case 8 : {if ((labels[1]->startswith('o'))||(labels[1]->startswith('p'))) {hidden=false;} else {hidden=true;} break;}
	case 9 : {if ((labels[1]->startswith('q'))||(labels[1]->startswith('r'))) {hidden=false;} else {hidden=true;} break;}
	case 10 :{if ((labels[1]->startswith('s'))||(labels[1]->startswith('t'))) {hidden=false;} else {hidden=true;} break;}
	case 11 :{if ((labels[1]->startswith('u'))||(labels[1]->startswith('v'))) {hidden=false;} else {hidden=true;} break;}
	case 12 :{if ((labels[1]->startswith('w'))||(labels[1]->startswith('x'))) {hidden=false;} else {hidden=true;} break;}
	case 13 :{if ((labels[1]->startswith('y'))||(labels[1]->startswith('z'))) {hidden=false;} else {hidden=true;} break;}
	}
emit signal_kcard_ordercards();
emit signal_kcard_reorder_positions();
}

void Kcard::slot_kcard_delcard(int me)
{
if ((selected==TRUE)&&(me==numero))
	{
	delete (this);
	}
else
	{if (numero>me)
		{numero--;}
	}
}

void Kcard::slot_kcard_selectall()
{
selected=TRUE;
labels[0]->changepalette(2);
}

void Kcard::slot_kcard_unselectall()
{
selected=FALSE;
labels[0]->changepalette(1);
}

void Kcard::slot_kcard_invertselect()
{
if (selected==TRUE)
	{
	selected=FALSE;
	labels[0]->changepalette(1);
	}
else
	{
	selected=TRUE;
	labels[0]->changepalette(2);
	}
emit signal_kcard_ordercards();	
}

void Kcard::slot_kcard_whoselect()
{
if (selected==TRUE)
	{
	emit signal_kcard_whoselect(this->numero);
	}
}

void Kcard::showsmalldata()
{
this->setGeometry(this->x(),this->y(),100,30);
}

void Kcard::showmediumdata()
{
int i,j;
j=1;
for (i=1; i <=8 ; i++)
	{
	if (labels[i]->text()!=QString(""))
		{
		QSize thislabelsize;
		thislabelsize=labels[i]->sizeHint();
		int x,y;
		x=thislabelsize.width;
		y=thislabelsize.height;
		labels[i]->setGeometry(2,30+20*(j-1),x,y);/*96,18*/
		labels[i]->show();
		labels[i]->changepalette(1);
		labels[i]->changefont(2);
		j++;
		}
	}
this->setGeometry(this->x(),this->y(),100,30+20*(j-1));
}

void Kcard::showcompletedata()
{
int i,j;
j=1;
for (i=1; i <=16 ; i++)
	{
	if (labels[i]->text()!=QString(""))
		{
		labels[i]->setGeometry(2,30+20*(j-1),96,18);
		labels[i]->show();
		labels[i]->changepalette(1);
		labels[i]->changefont(2);
		j++;
		}
	}
this->setGeometry(this->x(),this->y(),100,30+20*(j-1));
}

void Kcard::savecompletedata()
{
//Save the data into the config file
}

void Kcard::loadcompletedata()
{
//Load the data from the config file or from an imported Vcard
}

void Kcard::slot_kcard_mousePressEvent()
{
selected=!selected;
if (selected==TRUE)
	{
	labels[0]->changepalette(2);
	labels[1]->changepalette(2);
	}
else
	{
	labels[0]->changepalette(1);
	labels[1]->changepalette(1);
	}
}

void Kcard::slot_kcard_mouseDoubleClickEvent()
{
QString String_General, String_Details, String_Extensions;
emit signal_kcard_unselectall();
selected=FALSE;
labels[0]->changepalette(3);
labels[1]->changepalette(3);
emit signal_kcard_mousedcg(numero,String_General);
emit signal_kcard_mousedcd(numero,String_Details);
emit signal_kcard_mousedce(numero,String_Extensions);
labels[0]->changepalette(1);
labels[1]->changepalette(1);
emit signal_kcard_ordercards();
emit signal_kcard_reorder_positions();
}

void Kcard::slot_kcard_updategeneral(int this_int,QString this_string)
{
int found,number;
QString temp_string1;
QString temp_string2;
if (numero==this_int)
{
String_General=this_string;
temp_string1=this_string;
temp_string2=this_string;
if ((found=temp_string2.find("Prefix="))!=-1) {temp_string2.remove(found,7);}
if ((found=temp_string2.find("FirstName="))!=-1) {temp_string2.remove(found,10);}
if ((found=temp_string2.find("SecondName="))!=-1) {temp_string2.remove(found,11);}
if ((found=temp_string2.find("LastName="))!=-1) {temp_string2.remove(found,12);}
if ((found=temp_string2.find("Suffix="))!=-1) {temp_string2.remove(found,7);}
if ((found=temp_string2.find("\n"))!=-1) {temp_string2.left(found-1);}

labels[0]->setGeometry(0,0,100,50);
labels[0]->changefont(1);
labels[0]->show();
labels[1]->setText(temp_string2);
labels[1]->setGeometry(2,30,96,18);
labels[1]->changepalette(1);
labels[1]->changefont(2);
labels[1]->show();

this->setGeometry(this->x(),this->y(),100,50);
}
else
{
}
}

void Kcard::slot_kcard_updatedetails(int this_int,QString this_string)
{
int found,last_found,number;
if (numero==this_int)
{
String_Details=this_string;
found=0;
number=0;
while (found!=-1)
	{
	number++;
	last_found=found;
	found=this_string.find("\n",last_found+1);
	}
}
else
{
}
}

void Kcard::slot_kcard_updateextensions(int this_int, QString this_string)
{
int found,last_found,number;
if (numero==this_int)
{
String_Extensions=this_string;
found=0;
number=-1;
while (found!=-1)
	{
	number++;
	last_found=found;
	found=this_string.find("\n",last_found+1);
	}
}
else
{
}
}
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
