/***************************************************************************
                          GeneralData.h  -  description
		This Class handles the General Data fields and Tab
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <qwidget.h>
#include <qtabbar.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qmultilinedit.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qstring.h>
#include "AddressData.h"
#include "NameData.h"
#define MAX_GENERAL 35

class GeneralData : public QWidget
{
    Q_OBJECT

public:

    GeneralData
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~GeneralData();

signals :
	void signal_generaldata_apply(QString);
	void signal_generaldata_loadname(QString);
	void signal_generaldata_loadperaddress(QString);
	void signal_generaldata_loadcomaddress(QString);

public slots:
	void slot_generaldata_receivegeneral(QString);

protected slots:

    virtual void Validate_Company_Email();
    virtual void Display_Company_Email(int);
    virtual void Validate_Personnal_Web();
    virtual void Validate_Personnal_Name();
    virtual void Personnal_Email(const char*);
    virtual void Personnal_Web(const char*);
    virtual void Company_Phonenumber(const char*);
    virtual void Modify_Personnal_Name();
    virtual void Modify_Company_Email(int);
    virtual void Comments();
    virtual void Validate_Comments();
    virtual void Display_Company_Phonenumber(int);
    virtual void Personnal_Name(const char*);
    virtual void Validate_Company_Address();
    virtual void Modify_Company_Address();
    virtual void Modidy_Company_Phonenumber(int);
    virtual void Validate_Company_Web();
    virtual void Validate_Company_Name();
    virtual void Personnal_Phonenumber(const char*);
    virtual void Validate_Personnal_Phonenumber();
    virtual void Display_Personnal_Email(int);
    virtual void Company_Web(const char*);
    virtual void Company_Name(const char*);
    virtual void Modify_Personnal_Email(int);
    virtual void Personnal_Address();
    virtual void Display_Personnal_Phonenumber(int);
    virtual void Company_Address();
    virtual void Validate_Company_Phonenumber();
    virtual void Modify_Personnal_Address();
    virtual void Company_Email(const char*);
    virtual void Validate_Personnal_Address();
    virtual void Choose_Personnal_Phonenumber(int);
    virtual void Validate_Personnal_Email();
    void slot_generaldata_apply();
	void slot_generaldata_updatename(QString);
	void slot_generaldata_updatepaddress(QString);
	void slot_generaldata_updatecaddress(QString);	
	
protected:
	AddressData *Dialog_Address_P;
	AddressData *Dialog_Address_C;
	NameData	*Dialog_Name;
	QString		*Strings[MAX_GENERAL];
	QString		String_General;
	QString		String_Name, String_PerAddress, String_ComAddress;
	QLineEdit	*LineEdit_Complete_Name;
	QLineEdit	*LineEdit_Phonenumber;
	QLineEdit	*LineEdit_Personnal_Web;
	QLineEdit	*LineEdit_Personnal_Email;
	QLineEdit	*LineEdit_Company_Name;
	QLineEdit	*LineEdit_Company_Phonenumber;
	QLineEdit	*LineEdit_Company_Web;
	QLineEdit	*LineEdit_Company_Email;
	QMultiLineEdit	*MultiLineEdit_Address;
	QMultiLineEdit	*MultiLineEdit_Company_Address;
	QMultiLineEdit	*MultiLineEdit_Comments;
	QButtonGroup	*ButtonGroup_Personnal;
	QButtonGroup	*ButtonGroup_Company;
	QPushButton	*PushButton_Personnal_Name;
	QPushButton	*PushButton_Address;
	QPushButton	*PushButton_Company_Address;
	QComboBox	*ComboBox_Personnal_Phonenumber;
	QComboBox	*ComboBox_Personnal_Email;
	QComboBox	*ComboBox_Company_Phonenumber;
	QComboBox	*ComboBox_Company_Email;
	QLabel	*Label_Personnal_Web;
	QLabel	*Label_Company_Name;
	QLabel	*Label_Company_Web;
	QLabel	*Label_Comments;
	int personnal_phonenumber,personnal_email, company_phonenumber,company_email;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
