/***************************************************************************
                          AddressData.h  -  description
		This Class handles the Address Data fields
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Yoan Adida
    email                : yoan.adida@lip6.fr
 ***************************************************************************/
#include <qdialog.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qmultilinedit.h>
#include <qlineedit.h>
#include <kwizard.h>
#define MAX_ADDRESS 11

class AddressData : public KDialog
{

    Q_OBJECT

public:

    AddressData
    (
        QWidget* parent = NULL,
        const char* name = NULL,
        bool boolean = TRUE,
        int this_int=0
    );

    virtual ~AddressData();

signals :
	void signal_addressdata_apply(QString);

public slots:
	void Load(QString);

protected slots:

    virtual void ZIP(const char*);
    virtual void Validate_Door();
    virtual void Validate_Code();
    virtual void Stage(const char*);
    virtual void Validate_Stage();
    virtual void Street(const char*);
    virtual void Validate_Street();
    virtual void Comments();
    virtual void Validate_Comments();
    virtual void Validate_ZIP();
    virtual void Validate_Country(int);
    virtual void Address_OK();
    virtual void Code(const char*);
    virtual void State(const char*);
    virtual void Address_Cancel();
    virtual void Door(const char*);
    virtual void Validate_Innerphone();
    virtual void Country(int);
    virtual void Innerphone(const char*);
    virtual void Building(const char*);
    virtual void POBox(const char*);
    virtual void Validate_POBox();
    virtual void Validate_Building();
    virtual void Validate_State();
	virtual void Validate_Town();
	virtual void Town(const char*);

protected:
	QLabel *Label_Street;
	QLabel *Label_ZIP;
	QLabel *Label_Town;
	QLabel *Label_State;
	QLabel *Label_Country;
	QLabel *Label_Building;
	QLabel *Label_Code;
	QLabel *Label_Innerphone;
	QLabel *Label_Stage;
	QLabel *Label_Door;
	QLabel *Label_POBox;
	QLabel *Label_Comments;
	QPushButton *PushButton_Validate_Address;
	QPushButton *PushButton_Cancel;
	QLineEdit *LineEdit_Street;
	QLineEdit *LineEdit_ZIP;
	QLineEdit *LineEdit_Town;
	QLineEdit *LineEdit_State;
	QLineEdit *LineEdit_POBox;
	QLineEdit *LineEdit_Building;
	QLineEdit *LineEdit_Code;
	QLineEdit *LineEdit_Innerphone;
	QLineEdit *LineEdit_Stage;
	QLineEdit *LineEdit_Door;
	QComboBox *ComboBox_Country;
	QMultiLineEdit *MultiLineEdit_Comments;
	QString	Strings;
	int index_country;
};
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
