#include "kwvdialconfig.h"
#include "kwvdialconfig.moc"
#include <kapp.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>

KwvdialConfig::KwvdialConfig(QWidget *parent, const char *name,WvConf &_cfg)
	: QTabDialog(parent,name), cfg(_cfg)
{
    setCaption("KWvDial Configuration");

    // Start Defining new set of Controls on the First Tab
    QWidget *pr = new QWidget( this,"Profile");
    
    QGridLayout *grid1 = new QGridLayout(pr,4,4,10,-1);
    
    // Add the Combo Box to the Page
    profile = new QComboBox(pr,"Profile Combo Box");
    QLabel *profile_l = new QLabel(profile,i18n("&Selected Profile:"),pr);

    connect(profile,SIGNAL(activated(int)),SLOT(chgdsp(int)));
    
    // Make it span colums 2 and 3
    grid1->addMultiCellWidget(profile,0,0,2,3);
    
    // Add Label for Profile selection area to Row 1, Column 1
    grid1->addMultiCellWidget(profile_l,0,0,0,1);
    
    // Add an entry box for adding new sections
    newsection = new QLineEdit(pr,"New Section Name");
    QLabel *newsection_l = new QLabel(newsection,i18n("New Section:"),pr);
    
    grid1->addMultiCellWidget(newsection,1,1,2,3);
    
    grid1->addMultiCellWidget(newsection_l,1,1,0,1);
    
    /* Add a button to give the user the possibility of
     * Creating a new profile
     */
    newprofile = new QPushButton(i18n("Create New Profile"),pr,"newprof");
    
    // Connect a slot to the Button
    connect(newprofile, SIGNAL(clicked()),SLOT(newprofclick()));

    // Make the button span the center 2 columns of the dialog
    grid1->addMultiCellWidget(newprofile,2,2,1,2);
    
    delprofile = new QPushButton(i18n("Delete Selected Profile"),pr,"delprof");
    
    // Connect a slot to the Button
    connect(delprofile, SIGNAL(clicked()),SLOT(delprofclick()));

    // Make the button span the center 2 columns of the dialog
    grid1->addMultiCellWidget(delprofile,3,3,1,2);
    
    // Add this tab to the Dialog 
    addTab(pr,i18n("&Profile"));
    
    //Activate the layout so that it will display on the tab
    grid1->activate();

    // Start Defining new set of Controls on the Second Tab
    QWidget *mi = new QWidget( this,"Modem");
    
    //Set up a new grid layout
    QGridLayout *grid2 = new QGridLayout(mi,4,2,10,-1);
    
    // Enable or disable Microsoft Stupid Mode
    stupidmode = new QCheckBox(i18n("Emulate Win95/98?"),mi);
    grid2->addWidget(stupidmode,0,0);

    // Widget to ask if you are using the New PPPD?
    newpppd = new QCheckBox(i18n("New PPPD?"),mi);
    grid2->addWidget(newpppd,0,1);

    // Widget to set the Modem Volume
    volume = new QSlider(0,3,1,1,QSlider::Horizontal,mi,"Slider");
    QLabel *volume_l = new QLabel(volume,i18n("Modem Volume:"),mi);
    grid2->addWidget(volume_l,1,0);
    grid2->addWidget(volume,1,1);
    
    // Widget to Set Baud Rate
    baudrate = new QLineEdit(mi);
    QLabel *baudrate_l = new QLabel(baudrate,i18n("Baud Rate:"),mi);
    grid2->addWidget(baudrate_l,2,0);
    grid2->addWidget(baudrate,2,1);
    
    // Widget to select Auto-Redial on Disconnect
    autoredial = new QCheckBox(i18n("Redial on Disconnect?"),mi);
    grid2->addWidget(autoredial,3,0);
    
    // Widget to Kick Off AutoDetection of Modem
    detect = new QPushButton(i18n("AutoDetect Modem"),mi,"detect");
    
    // Connect a slot to the Button
    connect(detect, SIGNAL(clicked()),SLOT(wvautoconf()));
    
    grid2->addWidget(detect,3,1);
    
    // Add this tab to the Dialog
    addTab(mi,i18n("&Modem"));
    
    //Activate the layout so that it will display on the tab
    grid2->activate();

    // Start Defining new set of Controls on the Third Tab
    QWidget *di = new QWidget( this,"Dialing Information");

    QGridLayout *grid3 = new QGridLayout(di,4,2,10,-1);

    // Enable or disable Call Waiting
    callwtg = new QCheckBox(i18n("Call Waiting?"),di);
    grid3->addWidget(callwtg,0,0);

    // Widget to ask if you want to wait for a dialtone
    dialtone = new QCheckBox(i18n("No Wait for Dialtone?"),di);
    grid3->addWidget(dialtone,1,0);

    // Widget to ask if you want to dial this call as long distance
    dialasld = new QCheckBox(i18n("Dial as Long Distance?"),di);
    grid3->addWidget(dialasld,0,1);

    // Widget to ask if you want to redial on disconnect
    pulsetone = new QCheckBox(i18n("Dial as Pulse?"),di);
    grid3->addWidget(pulsetone,1,1);

    // Widget for Area Code
    areacode = new QLineEdit(di);
    QLabel *area_l = new QLabel(areacode,i18n("&Area Code:"),di);
    grid3->addWidget(area_l,2,0);
    grid3->addWidget(areacode,2,1);
    
    // Widget for Telephone Number
    telephone = new QLineEdit(di);
    QLabel *tel_l = new QLabel(telephone,i18n("P&hone Number:"),di);
    grid3->addWidget(tel_l,3,0);
    grid3->addWidget(telephone,3,1);
    
    // Add this tab to the Dialog 
    addTab(di,i18n("&Dialing"));

    //Activate the layout so that it will display on the tab
    grid3->activate();

    // Start Defining new set of Controls on the Third Tab
    QWidget *ui = new QWidget( this,"User Information");
    
    //Set up a new grid layout
    QGridLayout *grid4 = new QGridLayout(ui,4,2,10,-1);

    // Widgets for Name Entry:
    username = new QLineEdit(ui);
    QLabel *name_l = new QLabel(username,i18n("&Name:"),ui);
    grid4->addWidget(name_l,1,0);
    grid4->addWidget(username,1,1);

    // Create Password Widget and set the mode to * for entry
    pwd = new QLineEdit(ui);
    QLabel *pwd_l = new QLabel(pwd,i18n("&Password:"),ui);
    grid4->addWidget(pwd_l,2,0);
    grid4->addWidget(pwd,2,1);
    
    // Set the appropriate mode entry here...
    pwd->setEchoMode(QLineEdit::Password);
        
    // Add this tab to the Dialog
    addTab(ui,i18n("&User"));

    //Activate the layout so that it will display on the tab
    grid4->activate();
    
    // Add the Buttons to the bottom of the Dialog Box
    setApplyButton();
    setCancelButton();
    
    // Tell the dialog what to do when its buttons are pushed
    connect(this, SIGNAL(applyButtonPressed()), SLOT(apply()));
    connect(this, SIGNAL(cancelButtonPressed()), SLOT(setup()));
    
    // Initialize the dialogs before it is displayed for the first time
    connect(this, SIGNAL(aboutToShow()), SLOT(setup()));

    // give the program the correct sizing information
    resize(360,220);
    
    // display the dialog box
    show();
}

KwvdialConfig::~KwvdialConfig()
{
}

void KwvdialConfig::changedisplay(WvString sect)
{
    char *cptr;
    const char *tmp;
    WvString tmpnum;

    username->setText(cfg.get(sect,"Username"));
    pwd->setText(cfg.get(sect,"Password"));
    
    tmp = cfg.get(sect,"Phone");
    if (tmp != NULL)
    {
	if (!strncmp(tmp,"1-",2))
	{
	    dialasld->setChecked(TRUE);
	    tmp += 2;
	    
	    if (strchr(tmp, '-'))
	    {
		tmpnum = tmp;
		cptr = strchr(tmpnum.edit(), '-');
		telephone->setText(cptr + 1);
		*cptr = 0;
		areacode->setText(tmpnum);
	    }
	    else
	    {
		telephone->setText(tmp);
		areacode->setText("");
	    }
	}
	else
	{
	    areacode->setText("");
	    telephone->setText(tmp);
	}
    }   
    if (strstr(cfg.get(sect,"Dial Prefix",""),"*70,,"))
	callwtg->setChecked(TRUE);
    else
	callwtg->setChecked(FALSE);
    
    if (strstr(cfg.get(sect,"Auto Redial",""),"yes"))
	autoredial->setChecked(TRUE);
    else
	autoredial->setChecked(FALSE);
    
    if (strstr(cfg.get(sect,"Dial Command",""),"ATDP"))
	pulsetone->setChecked(TRUE);
    else
	pulsetone->setChecked(FALSE);
    
    if (strstr(cfg.get(sect,"Stupid Mode",""),"yes"))
	stupidmode->setChecked(TRUE);
    else
	stupidmode->setChecked(FALSE);
    
    if (strstr(cfg.get(sect,"New PPPD",""),"yes"))
	newpppd->setChecked(TRUE);
    else
	newpppd->setChecked(FALSE);
    
    if (strstr(cfg.get(sect,"Init3",""),"ATX1"))
	dialtone->setChecked(TRUE);
    else
	dialtone->setChecked(FALSE);
    
    if (strstr(cfg.get(sect,"Init4",""),"ATM0"))
	volume->setValue(0);
    else if (strstr(cfg.get(sect,"Init4",""),"ATM1L1"))
	volume->setValue(1);
    else if (strstr(cfg.get(sect,"Init4",""),"ATM1L2"))
	volume->setValue(2);
    else if (strstr(cfg.get(sect,"Init4",""),"ATM1L3"))
	volume->setValue(3);
    
    baudrate->setText(cfg.get(sect,"Baud"));
}

void KwvdialConfig::setup()
{
    
    profile->clear();
    
    WvConf::Iter i(cfg);
    for (i.rewind();i.next(); )
	profile->insertItem(i().name);
    
    if (profile->count() > 0)
    {
	WvString sect(profile->currentText());
    	changedisplay(sect);	
    } else { 
	// Call the AutoConf SLOT
	wvautoconf();
    }
}

void KwvdialConfig::apply()
{
    WvString InitStr1;
    WvString sect(profile->currentText());
    WvString phone;
    bool blank_area = (strlen(areacode->text()) == 0);
    
    if ((strlen(username->text()) != 0) && (strlen(pwd->text()) != 0) &&
	(strlen(telephone->text()) != 0))
    {	
	if (dialtone->isChecked())
	    InitStr1 = "ATX1";
	else
	    InitStr1 = "ATX4";
	
	if (dialasld->isChecked())
	    phone = WvString("1-%s%s%s", areacode->text(), 
			     blank_area ? "" : "-", telephone->text());
	else
	    phone = WvString("%s%s%s", areacode->text(),
			     blank_area ? "" : "-", telephone->text());
	
	cfg.set(sect,"Phone", phone);
	cfg.set(sect,"Username", username->text());
	cfg.set(sect,"Password", pwd->text());
	cfg.set(sect,"Init3", InitStr1);
	cfg.set(sect,"Baud",baudrate->text());
	
	if (callwtg->isChecked())
	    cfg.set(sect,"Dial Prefix","*70,,");
	else
	    cfg.set(sect,"Dial Prefix","");
	
	if (stupidmode->isChecked())
	    cfg.set(sect,"Stupid Mode","yes");
	else
	    cfg.set(sect,"Stupid Mode","no");
	
	if (autoredial->isChecked())
	    cfg.set(sect,"Auto Redial","yes");
	else
	    cfg.set(sect,"Auto Redial","no");
	
	if (newpppd->isChecked())
	    cfg.set(sect,"New PPPD","yes");
	else
	    cfg.set(sect,"New PPPD","no");
	
	if (pulsetone->isChecked())
	    cfg.set(sect,"Dial Command","ATDP");
	else
	    cfg.set(sect,"Dial Command","ATDT");
	
	switch(volume->value())
	{
	case 0:
	    cfg.set(sect,"Init4","ATM0");
	    break;
	case 1:
	    cfg.set(sect,"Init4","ATM1L1");
	    break;
	case 2:
	    cfg.set(sect,"Init4","ATM1L2");
	    break;
	case 3:
	    cfg.set(sect,"Init4","ATM1L3");
	}
    } else {
	QMessageBox::warning(this,"KWvDial",
			     "Please make sure that\nThe Name,Password and Telephone\nfields are filled in for\nthis profile");
    }
    repaint();
    cfg.flush();

    /* And in grand WorldVisions style:
     * 
     * This functions getting rather long
     * I think I'll sing this little song
     * We hope this works as advertised
     * Perhaps t'would better optimized
     * But for now we'll leave it as it is
     * Cause unlike Ave, I'm not a Wiz!
     */
}

void KwvdialConfig::newprofclick()
{
    // If the newsection box actually contains something -

    /* TODO:
     * This should also check if this entry is already in 
     * the List of Configurations.. but I haven't figured out a
     * way to do that elegantly yet
     */
    
    if ( strlen(newsection->text()) != 0)
    {
	profile->insertItem(newsection->text());
	/* Assume that it will always be added at the end
	 * Gives the number of elements, so subtract one since
	 * the index starts at 0
	 */
	profile->setCurrentItem(profile->count()-1);
	
	// Clear all of the Check boxes
	callwtg->setChecked(FALSE);
	dialtone->setChecked(FALSE);
	autoredial->setChecked(FALSE);
	dialasld->setChecked(FALSE);
	pulsetone->setChecked(FALSE);
	stupidmode->setChecked(FALSE);

	// We Want to initialize this with standard system settings
	if (strstr(cfg.get("Dialer Defaults","New PPPD",""),"yes"))
	    newpppd->setChecked(TRUE);
	else
	    newpppd->setChecked(FALSE);
	
	volume->setValue(2);
	// We want to get the detected baud rate
	baudrate->setText(cfg.get("Dialer Defaults","Baud"));
	
	/* Clear the User Entry Fields
	 * I may want to have these reset to Dialer Default Values
	 * I'll see what people say
	 */
	username->clear();
	pwd->clear();
	areacode->clear();
	telephone->clear();
	
	// And Finally... clear the newsection Entrybox
	
	newsection->clear();
	
    } else {
	// Pop Up a Message 
	QMessageBox::warning(this,"KWvDial","Please enter a name in the\nNew Section Field");
    }
    // Repaint the screen to have all the changes take effect ;)
    repaint();
}

void KwvdialConfig::delprofclick()
{
    WvString sect(profile->currentText());

    if ( strncmp(sect,"Dialer Defaults",15) != 0)
    {
	switch(QMessageBox::warning(this,"KWvDial",
				    "Are you sure you want to delete\n"+
				    sect +
				    "?\n",
				    QMessageBox::Ok,QMessageBox::Cancel))
	{
	case QMessageBox::Ok: 
	    cfg.delete_section(sect);
	    profile->removeItem(profile->currentItem());
	    setup();
	    cfg.flush();
	    break;
	case QMessageBox::Cancel:
	    break;
	}
    } else {
	QMessageBox::warning(this,"KWvDial",
			     "Sorry, not allowed to delete Default section\n");
    }
}

void KwvdialConfig::wvautoconf()
{
    WvLog log("KWvDial",WvLog::Info);
    
    WvModemScanList l;
    while (!l.isdone())
	l.execute();
    
    if (l.count() < 1)
    {
	log("\n\nSorry, no modem was detected! "
	    "Is it in use by another program?\n\n"
	    "If your modem is correctly installed and should have "
	    "been located,\nplease send mail to "
	    "wvdial@worldvisions.ca.\n");
	return;
    }
    
    WvModemScanList::Iter i(l);
    
    i.rewind(); i.next();
    WvModemScan &m = i;
    WvString fn = m.filename(), init = m.initstr();
    
    log("\nFound a modem on %s.\n", fn);
    log("\nWriting Default Section\n");
    
    static char s[]="Dialer Defaults";
    cfg.set(s, "Modem", fn);
    cfg.set(s, "Baud", m.maxbaud());
    cfg.set(s, "Init1", "ATZ");
    cfg.set(s, "Init2", init);
    
    log("AutoConfigure Done\n");
}

void KwvdialConfig::chgdsp(int id)
{
    WvString sect(profile->text(id));
    changedisplay(sect);
}
