/************************************************************
        Copyright (c) 1997 Michael Glauche
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "secondary.h"
#include "secondary.moc"
#define Inherited secondaryData
#include <qlabel.h>
#include <qlayout.h>
#include <qstring.h>

secondary::secondary(secondaryDomain *sl, QWidget* parent,
		     const char* name) : QDialog( parent, name, TRUE, 634880 )
{
  
  QBoxLayout *topLayout = new QVBoxLayout(this, 5);

  QBoxLayout *listLayout = new QHBoxLayout();
  QBoxLayout *buttonLayout = new QHBoxLayout();

  QBoxLayout *ipLayout = new QVBoxLayout();
  QBoxLayout *ipButtonLayout = new QVBoxLayout();
  QBoxLayout *entryLayout = new QVBoxLayout();

  topLayout->addLayout(listLayout, 1);
  topLayout->addLayout(buttonLayout,0);

  listLayout->addLayout(ipLayout, 0);
  listLayout->addLayout(ipButtonLayout, 0);
  listLayout->addLayout(entryLayout, 0);

  QLabel* dlgedit_Label_1;
  dlgedit_Label_1 = new QLabel( this, "Label_1" );
  dlgedit_Label_1->setFixedSize(100 , 20);
  dlgedit_Label_1->setText( i18n("Servers :") );

  ipLayout->addWidget(dlgedit_Label_1, 0,AlignLeft);

  IP_list = new QListBox( this, "ListBox_1" );
  IP_list->setFixedSize(140, 190);
  IP_list->setFrameStyle( 51 );
  IP_list->setLineWidth( 2 );
  IP_list->setMultiSelection( FALSE );

  ipLayout->addWidget(IP_list, 1,AlignLeft);

  add_Button = new QPushButton( this, "PushButton_1" );
  add_Button->setFixedSize( 30, 30 );
  add_Button->setText( "<-" );
  add_Button->setAutoRepeat( FALSE );
  add_Button->setAutoResize( FALSE );

  ipButtonLayout->addWidget(add_Button, 0);

  delete_Button = new QPushButton( this, "PushButton_2" );
  delete_Button->setFixedSize( 30, 30 );
  delete_Button->setText( "->" );
  delete_Button->setAutoRepeat( FALSE );
  delete_Button->setAutoResize( FALSE );

  ipButtonLayout->addWidget(delete_Button, 0);
  ipButtonLayout->addStretch(1);

  QLabel* dlgedit_Label_3;
  dlgedit_Label_3 = new QLabel( this, "Label_3" );
  dlgedit_Label_3->setFixedSize(100, 20);
  dlgedit_Label_3->setText(i18n("New Entry :"));

  entryLayout->addWidget(dlgedit_Label_3, 0,AlignLeft);

  IP_edit = new QLineEdit( this, "LineEdit_1" );
  IP_edit->setFixedSize( 130, 30 );
  IP_edit->setText( "" );
  IP_edit->setEchoMode( QLineEdit::Normal );
  IP_edit->setFrame( TRUE );

  entryLayout->addWidget(IP_edit, 0,AlignLeft);

  checkNameLabel = new QLabel( i18n("Check Names :"), this );
  checkNameLabel->setFixedSize(checkNameLabel->sizeHint());
  checkNameComboBox = new QComboBox( FALSE, this );   
  checkNameComboBox->insertItem( i18n("Default") );
  checkNameComboBox->insertItem( i18n("Fail") );
  checkNameComboBox->insertItem( i18n("Ignore") );
  checkNameComboBox->insertItem( i18n("Warn") );
  checkNameComboBox->setFixedSize(checkNameComboBox->sizeHint());
  entryLayout->addWidget(checkNameLabel, 0,AlignLeft);
  entryLayout->addWidget(checkNameComboBox, 0,AlignLeft);
  checkNameComboBox->setEnabled(false);

  non_check = new QCheckBox(i18n("No Notify"),this);
  non_check->setFixedSize(non_check->sizeHint());
  entryLayout->addWidget(non_check, 0,AlignLeft);
  non_check->setEnabled(false);

  entryLayout->addStretch(10);

  QLabel* dlgedit_Label_2;
  dlgedit_Label_2 = new QLabel( this, "Label_2" );
  dlgedit_Label_2->setFixedSize(100, 20);
  dlgedit_Label_2->setText(i18n("Datafile:"));
  entryLayout->addWidget(dlgedit_Label_2, 0,AlignLeft);

  file_edit = new QLineEdit( this, "LineEdit_2" );
  file_edit->setFixedSize( 130, 30 );
  file_edit->setText( "" );
  //	file_edit->setMaxLength( 32767 );
  //	file_edit->setEchoMode( QLineEdit::Normal );
  file_edit->setFrame( TRUE );

  entryLayout->addWidget(file_edit, 0,AlignLeft);

  OK_Button = new QPushButton( this, "PushButton_3" );
  OK_Button->setFixedSize(OK_Button->sizeHint());
  OK_Button->setText(i18n("OK"));
  OK_Button->setAutoRepeat( FALSE );
  OK_Button->setAutoResize( FALSE );

  buttonLayout->addStretch(1);
  buttonLayout->addWidget(OK_Button,0);

  Cancel_Button = new QPushButton( this, "PushButton_4" );
  Cancel_Button->setFixedSize(Cancel_Button->sizeHint());
  Cancel_Button->setText(i18n("Cancel"));
  Cancel_Button->setAutoRepeat( FALSE );
  Cancel_Button->setAutoResize( FALSE );

  buttonLayout->addWidget(Cancel_Button,0);

  setFixedSize(50,50);

  topLayout->activate();

  setCaption( sl->domain );
  connect(add_Button,SIGNAL(clicked()),SLOT(addclick()));
  connect(delete_Button,SIGNAL(clicked()),SLOT(removeclick()));
  connect(OK_Button,SIGNAL(clicked()),SLOT(secondary_exit()));
  connect(Cancel_Button,SIGNAL(clicked()),SLOT(secondary_cancel()));
  IP_list->insertStrList(sl->ip);
  sd=sl;
  file_edit->setText(sl->file);
}

secondary::~secondary()
{
}

void secondary::addclick()
{
	if(IP_edit->text() != "") IP_list->insertItem(IP_edit->text());
}

void secondary::removeclick()
{
	int n;
	n=IP_list->currentItem();
	IP_list->removeItem(n);
}

void secondary::secondary_exit()
{
	int n,m;
	sd->ip->setAutoDelete(TRUE);
	while (sd->ip->removeFirst());
	n=IP_list->count();
	for (m=0;m<n;m++) {
		sd->ip->append(IP_list->text(m));
	}	
	sd->file=file_edit->text();	
 	close();
}

void secondary::secondary_cancel()
{
   close();
}

