/***************************************************************************
                          kscalebar.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __KSCALEBAR__
#define __KSCALEBAR__

#include <qpainter.h>
#include <qframe.h>

#ifndef MIN
#define MIN(a,b)	((a) < (b)?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b)	((a) > (b)?(a):(b))
#endif

#define ZERO_TOP	0
#define ZERO_MID	1
#define ZERO_BOTTOM	2

#define LEFT_SIDED	0
#define RIGHT_SIDED	4

class KScaleBar : public QFrame
{
	Q_OBJECT
protected:

	uint		nmarks;
	double		min_value,max_value;
	uint		mode,mb_pressed;
	QString		format;

	QPainter	*qp;

protected:

	void	draw();

	//void	resizeEvent(QResizeEvent*);
	void	paintEvent(QPaintEvent*);

public:

	KScaleBar(QWidget *parent,uint m);
	~KScaleBar();

	void	setNMarks(uint n)
	{
		nmarks = n;
	};	
	void	setRange(double min,double max)
	{
		min_value = min;
		max_value = max;
	};
	void	setMode(uint m)
	{
		mode = m & (ZERO_TOP | ZERO_MID | ZERO_BOTTOM |
				LEFT_SIDED | RIGHT_SIDED);
	};
	void	setFormatString(QString f)
	{
		format = f;
	};

};

	
#endif


